/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.ImportFormat;
import com.dropbox.core.v2.files.PaperDocUpdatePolicy;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class PaperUpdateArg {
    @Nonnull
    protected final String path;
    @Nonnull
    protected final ImportFormat importFormat;
    @Nonnull
    protected final PaperDocUpdatePolicy docUpdatePolicy;
    @Nullable
    protected final Long paperRevision;

    public PaperUpdateArg(@Nonnull String path, @Nonnull ImportFormat importFormat, @Nonnull PaperDocUpdatePolicy docUpdatePolicy, @Nullable Long paperRevision) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)|(id:.*)", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        if (importFormat == null) {
            throw new IllegalArgumentException("Required value for 'importFormat' is null");
        }
        this.importFormat = importFormat;
        if (docUpdatePolicy == null) {
            throw new IllegalArgumentException("Required value for 'docUpdatePolicy' is null");
        }
        this.docUpdatePolicy = docUpdatePolicy;
        this.paperRevision = paperRevision;
    }

    public PaperUpdateArg(@Nonnull String path, @Nonnull ImportFormat importFormat, @Nonnull PaperDocUpdatePolicy docUpdatePolicy) {
        this(path, importFormat, docUpdatePolicy, null);
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public ImportFormat getImportFormat() {
        return this.importFormat;
    }

    @Nonnull
    public PaperDocUpdatePolicy getDocUpdatePolicy() {
        return this.docUpdatePolicy;
    }

    @Nullable
    public Long getPaperRevision() {
        return this.paperRevision;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.importFormat, this.docUpdatePolicy, this.paperRevision});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            PaperUpdateArg other = (PaperUpdateArg)obj;
            return !(this.path != other.path && !this.path.equals(other.path) || this.importFormat != other.importFormat && !this.importFormat.equals((Object)other.importFormat) || this.docUpdatePolicy != other.docUpdatePolicy && !this.docUpdatePolicy.equals((Object)other.docUpdatePolicy) || this.paperRevision != other.paperRevision && (this.paperRevision == null || !this.paperRevision.equals(other.paperRevision)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<PaperUpdateArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PaperUpdateArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("path");
            StoneSerializers.string().serialize(value.path, g);
            g.writeFieldName("import_format");
            ImportFormat.Serializer.INSTANCE.serialize(value.importFormat, g);
            g.writeFieldName("doc_update_policy");
            PaperDocUpdatePolicy.Serializer.INSTANCE.serialize(value.docUpdatePolicy, g);
            if (value.paperRevision != null) {
                g.writeFieldName("paper_revision");
                StoneSerializers.nullable(StoneSerializers.int64()).serialize(value.paperRevision, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public PaperUpdateArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_paperRevision;
            PaperDocUpdatePolicy f_docUpdatePolicy;
            ImportFormat f_importFormat;
            String f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_importFormat = null;
                f_docUpdatePolicy = null;
                f_paperRevision = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("import_format".equals(field)) {
                        f_importFormat = ImportFormat.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("doc_update_policy".equals(field)) {
                        f_docUpdatePolicy = PaperDocUpdatePolicy.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("paper_revision".equals(field)) {
                        f_paperRevision = StoneSerializers.nullable(StoneSerializers.int64()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
                if (f_importFormat == null) {
                    throw new JsonParseException(p, "Required field \"import_format\" missing.");
                }
                if (f_docUpdatePolicy == null) {
                    throw new JsonParseException(p, "Required field \"doc_update_policy\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            PaperUpdateArg value = new PaperUpdateArg(f_path, f_importFormat, f_docUpdatePolicy, f_paperRevision);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

