/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.aws.sqs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.AmazonSQSException;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import java.util.List;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transforms.aws.sqs.SqsReaderMeta;

public class AwsSqsReader {
    private AmazonSQSClient sqsClient;
    private SqsReaderMeta meta;
    private String awsKey;
    private String awsRegion;
    private String awsKeySecret;
    private BaseTransform baseTransform;
    private PipelineMeta pipelineMeta;
    private String awsCredChain;
    private String deleteMessage;

    public AwsSqsReader(SqsReaderMeta transformMeta, PipelineMeta t, BaseTransform bst) {
        this.meta = transformMeta;
        this.baseTransform = bst;
        this.pipelineMeta = t;
        this.awsCredChain = this.baseTransform.resolve(this.meta.getAwsCredChain());
        this.awsKey = this.baseTransform.resolve(this.meta.getAwsKey());
        this.awsKeySecret = this.baseTransform.resolve(this.meta.getAwsKeySecret());
        this.awsRegion = this.baseTransform.resolve(this.meta.getAwsRegion());
        this.deleteMessage = this.baseTransform.resolve(this.meta.getTFldMessageDelete());
    }

    public boolean getAWSConnection() {
        try {
            this.baseTransform.logBasic("Starting connection to AWS SQS");
            if (this.awsCredChain.equalsIgnoreCase("N")) {
                BasicAWSCredentials awsCreds = new BasicAWSCredentials(this.awsKey, this.awsKeySecret);
                this.sqsClient = (AmazonSQSClient)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCreds))).withRegion(this.awsRegion)).build();
            } else {
                DefaultAWSCredentialsProviderChain provider = new DefaultAWSCredentialsProviderChain();
                this.sqsClient = (AmazonSQSClient)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withCredentials((AWSCredentialsProvider)provider)).build();
                this.baseTransform.logBasic("Connected to SQS with provided Credentials Chain");
            }
            return true;
        }
        catch (Exception e) {
            this.baseTransform.logError(e.getMessage());
            return false;
        }
    }

    public void disconnectAWSConnection() {
        try {
            this.sqsClient.shutdown();
            this.baseTransform.logBasic("Disconnected from SQS");
        }
        catch (AmazonClientException e) {
            this.baseTransform.logError(e.getMessage());
            this.baseTransform.setErrors(1L);
        }
    }

    public List<Message> readMessages(String queueURL, int numMsgs, boolean isPreview) throws AmazonSQSException {
        int numMessages = numMsgs > 10 ? 10 : numMsgs;
        ReceiveMessageRequest receiveMessageRequest = new ReceiveMessageRequest(queueURL);
        receiveMessageRequest.setMaxNumberOfMessages(Integer.valueOf(numMessages));
        List messages = this.sqsClient.receiveMessage(receiveMessageRequest).getMessages();
        this.baseTransform.logDebug(messages.size() + " Message(s) retrieved from queue");
        if (this.deleteMessage.equalsIgnoreCase("Y") && !isPreview) {
            for (Message m : messages) {
                this.sqsClient.deleteMessage(queueURL, m.getReceiptHandle());
            }
            this.baseTransform.logDebug(messages.size() + " Message(s) deleted from queue");
        }
        return messages;
    }
}

