/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedHashSet;

public final class MDBvalidator {
    private static final String prg = "MDBvalidator";
    private Connection con;
    private int majorversion;
    private int minorversion;
    private boolean verbose = false;
    private boolean showValidationInfo = true;
    private static final String[][] sys_pkeys = new String[][]{{"schemas", "id", null}, {"_tables", "id", null}, {"tables", "id", null}, {"_columns", "id", null}, {"columns", "id", null}, {"functions", "id", null}, {"args", "id", null}, {"types", "id", null}, {"objects", "id, nr", null}, {"keys", "id", null}, {"idxs", "id", null}, {"triggers", "id", null}, {"sequences", "id", null}, {"dependency_types", "dependency_type_id", null}, {"dependencies", "id, depend_id", null}, {"auths", "id", null}, {"users", "name", null}, {"user_role", "login_id, role_id", null}, {"privileges", "obj_id, auth_id, privileges", null}, {"querylog_catalog", "id", null}, {"querylog_calls", "id", null}, {"querylog_history", "id", null}, {"optimizers", "name", null}, {"environment", "name", null}, {"db_user_info", "name", null}, {"statistics", "column_id", null}, {"\"storage\"()", "\"schema\", \"table\", \"column\"", null}, {"storagemodelinput", "\"schema\", \"table\", \"column\"", null}, {"rejects", "rowid", "19"}, {"keywords", "keyword", "21"}, {"table_types", "table_type_id", "21"}, {"function_languages", "language_id", "27"}, {"function_types", "function_type_id", "27"}, {"index_types", "index_type_id", "27"}, {"key_types", "key_type_id", "27"}, {"privilege_codes", "privilege_code_id", "27"}, {"comments", "id", "29"}, {"ids", "id", "29"}, {"var_values", "var_name", "29"}, {"table_partitions", "id", "33"}, {"range_partitions", "table_id, partition_id, minimum", "33"}, {"value_partitions", "table_id, partition_id, \"value\"", "33"}, {"queue", "tag", "37"}, {"sessions", "sessionid", "37"}, {"fkey_actions", "action_id", "43"}, {"fkeys", "id", "43"}};
    private static final String[][] tmp_pkeys = new String[][]{{"_tables", "id", null}, {"_columns", "id", null}, {"objects", "id, nr", null}, {"keys", "id", null}, {"idxs", "id", null}, {"triggers", "id", null}};
    private static final String[][] netcdf_pkeys = new String[][]{{"netcdf_files", "file_id", null}, {"netcdf_attrs", "file_id, att_name", null}, {"netcdf_dims", "dim_id, file_id", null}, {"netcdf_vars", "var_id, file_id", null}, {"netcdf_vardim", "var_id, dim_id, file_id", null}};
    private static final String[][] geom_pkeys = new String[][]{{"spatial_ref_sys", "srid", null}};
    private static final String[][] sys_akeys = new String[][]{{"schemas", "name", null}, {"_tables", "schema_id, name", null}, {"tables", "schema_id, name", null}, {"_columns", "table_id, name", null}, {"columns", "table_id, name", null}, {"_columns", "table_id, number", null}, {"columns", "table_id, number", null}, {"(SELECT id FROM sys.schemas UNION ALL SELECT id FROM sys._tables UNION ALL SELECT id FROM sys._columns UNION ALL SELECT id FROM sys.functions) as T", "T.id", null}, {"(SELECT id FROM sys.schemas UNION ALL SELECT id FROM sys.tables UNION ALL SELECT id FROM sys.columns UNION ALL SELECT id FROM sys.functions) as T", "T.id", null}, {"functions f join sys.args a on f.id=a.func_id", "schema_id, f.name, func, mod, \"language\", f.\"type\", side_effect, varres, vararg, a.id", null}, {"args", "func_id, name, inout", null}, {"types", "schema_id, systemname, sqlname", null}, {"objects", "id, name", null}, {"keys", "table_id, name", null}, {"idxs", "table_id, name", null}, {"triggers", "table_id, name", null}, {"sequences", "schema_id, name", null}, {"dependency_types", "dependency_type_name", null}, {"auths", "name", null}, {"optimizers", "def", null}, {"table_types", "table_type_name", "21"}, {"function_types", "function_type_name", "27"}, {"function_languages", "language_name", "27"}, {"index_types", "index_type_name", "27"}, {"key_types", "key_type_name", "27"}, {"privilege_codes", "privilege_code_name", "27"}, {"comments", "id", "29"}, {"table_partitions WHERE column_id IS NOT NULL", "table_id, column_id", "33"}, {"table_partitions WHERE \"expression\" IS NOT NULL", "table_id, \"expression\"", "33"}, {"range_partitions", "table_id, partition_id, \"maximum\"", "33"}, {"fkey_actions", "action_name", "43"}, {"fkeys", "table_id, name", "43"}};
    private static final String[][] tmp_akeys = new String[][]{{"_tables", "schema_id, name", null}, {"_columns", "table_id, name", null}, {"_columns", "table_id, number", null}, {"objects", "id, name", null}, {"keys", "table_id, name", null}, {"idxs", "table_id, name", null}, {"triggers", "table_id, name", null}};
    private static final String[][] netcdf_akeys = new String[][]{{"netcdf_files", "location", null}};
    private static final String[][] geom_akeys = new String[][]{{"spatial_ref_sys", "auth_name, auth_srid, srtext, proj4text", null}};
    private static final String[][] sys_fkeys = new String[][]{{"schemas", "authorization", "id", "auths", null}, {"schemas", "owner", "id", "auths", null}, {"_tables", "schema_id", "id", "schemas", null}, {"tables", "schema_id", "id", "schemas", null}, {"_tables", "\"type\"", "table_type_id", "table_types", "21"}, {"tables", "\"type\"", "table_type_id", "table_types", "21"}, {"_columns", "table_id", "id", "_tables", null}, {"columns", "table_id", "id", "tables", null}, {"_columns", "\"type\"", "sqlname", "types", null}, {"columns", "\"type\"", "sqlname", "types", null}, {"functions", "schema_id", "id", "schemas", null}, {"functions", "\"type\"", "function_type_id", "function_types", "27"}, {"functions", "\"language\"", "language_id", "function_languages", "27"}, {"functions WHERE system AND ", "schema_id", "id", "schemas WHERE system", "33"}, {"args", "func_id", "id", "functions", null}, {"args", "\"type\"", "sqlname", "types", null}, {"types", "schema_id", "id", "schemas", null}, {"objects", "id", "id", "ids", "29"}, {"ids WHERE obj_type IN ('key', 'index') AND ", "id", "id", "objects", "29"}, {"keys", "id", "id", "objects", null}, {"keys", "table_id", "id", "_tables", null}, {"keys", "table_id", "id", "tables", null}, {"keys", "\"type\"", "key_type_id", "key_types", "27"}, {"keys WHERE rkey <> -1 AND ", "rkey", "id", "keys", null}, {"idxs", "id", "id", "objects", null}, {"idxs", "table_id", "id", "_tables", null}, {"idxs", "table_id", "id", "tables", null}, {"idxs", "\"type\"", "index_type_id", "index_types", "27"}, {"sequences", "schema_id", "id", "schemas", null}, {"triggers", "table_id", "id", "_tables", null}, {"triggers", "table_id", "id", "tables", null}, {"comments", "id", "id", "ids", "29"}, {"dependencies", "id", "id", "ids", "29"}, {"dependencies", "depend_id", "id", "ids", "29"}, {"dependencies", "depend_type", "dependency_type_id", "dependency_types", null}, {"dependencies", "id, depend_id, depend_type", "v.id, v.used_by_id, v.depend_type", "dependencies_vw v", "29"}, {"auths WHERE grantor > 0 AND ", "grantor", "id", "auths", null}, {"users", "name", "name", "auths", null}, {"users", "default_schema", "id", "schemas", null}, {"db_user_info", "name", "name", "auths", null}, {"db_user_info", "default_schema", "id", "schemas", null}, {"user_role", "login_id", "id", "auths", null}, {"user_role", "login_id", "a.id", "auths a WHERE a.name IN (SELECT u.name FROM sys.users u)", null}, {"user_role", "role_id", "id", "auths", null}, {"user_role", "role_id", "a.id", "auths a WHERE a.name IN (SELECT u.name FROM sys.users u)", null}, {"user_role", "role_id", "id", "roles", "29"}, {"privileges", "obj_id", "id", "(SELECT id FROM sys.schemas UNION ALL SELECT id FROM sys._tables UNION ALL SELECT id FROM sys._columns UNION ALL SELECT id FROM sys.functions) as t", null}, {"privileges", "auth_id", "id", "auths", null}, {"privileges WHERE grantor > 0 AND ", "grantor", "id", "auths", null}, {"privileges", "privileges", "privilege_code_id", "privilege_codes", "27"}, {"querylog_catalog", "owner", "name", "users", null}, {"querylog_catalog", "pipe", "name", "optimizers", null}, {"querylog_calls", "id", "id", "querylog_catalog", null}, {"querylog_history", "id", "id", "querylog_catalog", null}, {"querylog_history", "owner", "name", "users", null}, {"querylog_history", "pipe", "name", "optimizers", null}, {"sessions", "\"username\"", "name", "users", "37"}, {"sessions", "sessions.optimizer", "name", "optimizers", "37"}, {"statistics", "column_id", "id", "(SELECT id FROM sys._columns UNION ALL SELECT id FROM tmp._columns) as c", null}, {"statistics", "\"type\"", "sqlname", "types", null}, {"storage()", "\"schema\"", "name", "schemas", null}, {"storage()", "\"table\"", "name", "(SELECT name FROM sys._tables UNION ALL SELECT name FROM tmp._tables) as t", null}, {"storage()", "\"schema\", \"table\"", "sname, tname", "(SELECT sch.name as sname, tbl.name as tname FROM sys.schemas AS sch JOIN sys.tables AS tbl ON sch.id = tbl.schema_id) as t", null}, {"storage()", "\"column\"", "name", "(SELECT name FROM sys._columns UNION ALL SELECT name FROM tmp._columns UNION ALL SELECT name FROM sys.keys UNION ALL SELECT name FROM tmp.keys UNION ALL SELECT name FROM sys.idxs UNION ALL SELECT name FROM tmp.idxs) as c", null}, {"storage()", "\"type\"", "sqlname", "types", null}, {"storage", "\"schema\"", "name", "schemas", null}, {"storage", "\"table\"", "name", "(SELECT name FROM sys._tables UNION ALL SELECT name FROM tmp._tables) as t", null}, {"storage", "\"schema\", \"table\"", "sname, tname", "(SELECT sch.name as sname, tbl.name as tname FROM sys.schemas AS sch JOIN sys.tables AS tbl ON sch.id = tbl.schema_id) as t", null}, {"storage", "\"column\"", "name", "(SELECT name FROM sys._columns UNION ALL SELECT name FROM tmp._columns UNION ALL SELECT name FROM sys.keys UNION ALL SELECT name FROM tmp.keys UNION ALL SELECT name FROM sys.idxs UNION ALL SELECT name FROM tmp.idxs) as c", null}, {"storage", "\"type\"", "sqlname", "types", null}, {"storagemodel", "\"schema\"", "name", "schemas", null}, {"storagemodel", "\"table\"", "name", "(SELECT name FROM sys._tables UNION ALL SELECT name FROM tmp._tables) as t", null}, {"storagemodel", "\"schema\", \"table\"", "sname, tname", "(SELECT sch.name as sname, tbl.name as tname FROM sys.schemas AS sch JOIN sys.tables AS tbl ON sch.id = tbl.schema_id) as t", null}, {"storagemodel", "\"column\"", "name", "(SELECT name FROM sys._columns UNION ALL SELECT name FROM tmp._columns UNION ALL SELECT name FROM sys.keys UNION ALL SELECT name FROM tmp.keys UNION ALL SELECT name FROM sys.idxs UNION ALL SELECT name FROM tmp.idxs) as c", null}, {"storagemodel", "\"type\"", "sqlname", "types", null}, {"storagemodelinput", "\"schema\"", "name", "schemas", null}, {"storagemodelinput", "\"table\"", "name", "(SELECT name FROM sys._tables UNION ALL SELECT name FROM tmp._tables) as t", null}, {"storagemodelinput", "\"schema\", \"table\"", "sname, tname", "(SELECT sch.name as sname, tbl.name as tname FROM sys.schemas AS sch JOIN sys.tables AS tbl ON sch.id = tbl.schema_id) as t", null}, {"storagemodelinput", "\"column\"", "name", "(SELECT name FROM sys._columns UNION ALL SELECT name FROM tmp._columns UNION ALL SELECT name FROM sys.keys UNION ALL SELECT name FROM tmp.keys UNION ALL SELECT name FROM sys.idxs UNION ALL SELECT name FROM tmp.idxs) as c", null}, {"storagemodelinput", "\"type\"", "sqlname", "types", null}, {"tablestoragemodel", "\"schema\"", "name", "schemas", null}, {"tablestoragemodel", "\"table\"", "name", "(SELECT name FROM sys._tables UNION ALL SELECT name FROM tmp._tables) as t", null}, {"tablestoragemodel", "\"schema\", \"table\"", "sname, tname", "(SELECT sch.name as sname, tbl.name as tname FROM sys.schemas AS sch JOIN sys.tables AS tbl ON sch.id = tbl.schema_id) as t", null}, {"schemastorage", "\"schema\"", "name", "schemas", "33"}, {"tablestorage", "\"schema\"", "name", "schemas", "33"}, {"tablestorage", "\"table\"", "name", "(SELECT name FROM sys._tables UNION ALL SELECT name FROM tmp._tables) as t", "33"}, {"tablestorage", "\"schema\", \"table\"", "sname, tname", "(SELECT sch.name as sname, tbl.name as tname FROM sys.schemas AS sch JOIN sys.tables AS tbl ON sch.id = tbl.schema_id) as t", "33"}, {"table_partitions", "table_id", "id", "_tables", "33"}, {"table_partitions WHERE column_id IS NOT NULL AND ", "column_id", "id", "_columns", "33"}, {"range_partitions", "table_id", "id", "_tables", "33"}, {"range_partitions", "partition_id", "id", "table_partitions", "33"}, {"value_partitions", "table_id", "id", "_tables", "33"}, {"value_partitions", "partition_id", "id", "table_partitions", "33"}, {"keys WHERE action >= 0 AND ", "cast(((action >> 8) & 255) as smallint)", "action_id", "fkey_actions", "43"}, {"keys WHERE action >= 0 AND ", "cast((action & 255) as smallint)", "action_id", "fkey_actions", "43"}, {"fkeys", "id, table_id, \"type\", name, rkey", "id, table_id, \"type\", name, rkey", "keys", "43"}, {"fkeys", "update_action_id", "action_id", "fkey_actions", "43"}, {"fkeys", "delete_action_id", "action_id", "fkey_actions", "43"}};
    private static final String[][] tmp_fkeys = new String[][]{{"_tables", "schema_id", "id", "sys.schemas", null}, {"_tables", "\"type\"", "table_type_id", "sys.table_types", "21"}, {"_columns", "table_id", "id", "_tables", null}, {"_columns", "\"type\"", "sqlname", "sys.types", null}, {"keys", "id", "id", "objects", null}, {"keys", "table_id", "id", "_tables", null}, {"keys", "\"type\"", "key_type_id", "sys.key_types", "27"}, {"keys WHERE rkey <> -1 AND ", "rkey", "id", "keys", null}, {"keys WHERE action >= 0 AND ", "cast(((action >> 8) & 255) as smallint)", "action_id", "sys.fkey_actions", "43"}, {"keys WHERE action >= 0 AND ", "cast((action & 255) as smallint)", "action_id", "sys.fkey_actions", "43"}, {"idxs", "id", "id", "objects", null}, {"idxs", "table_id", "id", "_tables", null}, {"idxs", "\"type\"", "index_type_id", "sys.index_types", "27"}, {"objects", "id", "id", "sys.ids", "29"}, {"triggers", "table_id", "id", "_tables", null}};
    private static final String[][] netcdf_fkeys = new String[][]{{"netcdf_attrs", "file_id", "file_id", "netcdf_files", null}, {"netcdf_dims", "file_id", "file_id", "netcdf_files", null}, {"netcdf_vars", "file_id", "file_id", "netcdf_files", null}, {"netcdf_vardim", "file_id", "file_id", "netcdf_files", null}, {"netcdf_vardim", "dim_id", "dim_id", "netcdf_dims", null}, {"netcdf_vardim", "dim_id, file_id", "dim_id, file_id", "netcdf_dims", null}, {"netcdf_vardim", "var_id", "var_id", "netcdf_vars", null}, {"netcdf_vardim", "var_id, file_id", "var_id, file_id", "netcdf_vars", null}};
    private static final String[][] geom_fkeys = new String[][]{{"spatial_ref_sys", "auth_srid", "srid", "spatial_ref_sys", null}};
    private static final String[][] sys_notnull = new String[][]{{"_columns", "id", null}, {"_columns", "name", null}, {"_columns", "\"type\"", null}, {"_columns", "type_digits", null}, {"_columns", "type_scale", null}, {"_columns", "table_id", null}, {"_columns", "\"null\"", null}, {"_columns", "number", null}, {"_tables", "id", null}, {"_tables", "name", null}, {"_tables", "schema_id", null}, {"_tables", "\"type\"", null}, {"_tables", "system", null}, {"_tables", "commit_action", null}, {"_tables", "access", null}, {"args", "id", null}, {"args", "func_id", null}, {"args", "name", null}, {"args", "\"type\"", null}, {"args", "type_digits", null}, {"args", "type_scale", null}, {"args", "inout", null}, {"args", "number", null}, {"auths", "id", null}, {"auths", "name", null}, {"auths", "grantor", null}, {"db_user_info", "name", null}, {"db_user_info", "fullname", null}, {"db_user_info", "default_schema", null}, {"dependencies", "id", null}, {"dependencies", "depend_id", null}, {"dependencies", "depend_type", null}, {"function_languages", "language_id", "27"}, {"function_languages", "language_name", "27"}, {"function_types", "function_type_id", "27"}, {"function_types", "function_type_name", "27"}, {"function_types", "function_type_keyword", "29"}, {"functions", "id", null}, {"functions", "name", null}, {"functions", "func", null}, {"functions", "mod", null}, {"functions", "\"language\"", null}, {"functions", "\"type\"", null}, {"functions", "side_effect", null}, {"functions", "varres", null}, {"functions", "vararg", null}, {"functions", "schema_id", null}, {"functions", "system", "33"}, {"idxs", "id", null}, {"idxs", "table_id", null}, {"idxs", "\"type\"", null}, {"idxs", "name", null}, {"index_types", "index_type_id", "27"}, {"index_types", "index_type_name", "27"}, {"key_types", "key_type_id", "27"}, {"key_types", "key_type_name", "27"}, {"keys", "id", null}, {"keys", "table_id", null}, {"keys", "\"type\"", null}, {"keys", "name", null}, {"keys", "rkey", null}, {"keys", "action", null}, {"keywords", "keyword", "21"}, {"objects", "id", null}, {"objects", "name", null}, {"objects", "nr", null}, {"optimizers", "name", null}, {"optimizers", "def", null}, {"optimizers", "status", null}, {"privilege_codes", "privilege_code_id", "27"}, {"privilege_codes", "privilege_code_name", "27"}, {"privileges", "obj_id", null}, {"privileges", "auth_id", null}, {"privileges", "privileges", null}, {"privileges", "grantor", null}, {"privileges", "grantable", null}, {"schemas", "id", null}, {"schemas", "name", null}, {"schemas", "authorization", null}, {"schemas", "owner", null}, {"schemas", "system", null}, {"sequences", "id", null}, {"sequences", "schema_id", null}, {"sequences", "name", null}, {"sequences", "start", null}, {"sequences", "minvalue", null}, {"sequences", "maxvalue", null}, {"sequences", "increment", null}, {"sequences", "cacheinc", null}, {"sequences", "cycle", null}, {"statistics", "column_id", null}, {"statistics", "\"schema\"", "43"}, {"statistics", "\"table\"", "43"}, {"statistics", "\"column\"", "43"}, {"statistics", "\"type\"", null}, {"statistics", "\"width\"", null}, {"statistics", "\"count\"", null}, {"statistics", "\"unique\"", null}, {"statistics", "nils", null}, {"statistics", "sorted", null}, {"statistics", "revsorted", null}, {"\"storage\"()", "\"schema\"", null}, {"\"storage\"()", "\"table\"", null}, {"\"storage\"()", "\"column\"", null}, {"\"storage\"()", "\"type\"", null}, {"\"storage\"()", "mode", null}, {"\"storage\"()", "location", null}, {"\"storage\"()", "count", null}, {"\"storage\"()", "typewidth", null}, {"\"storage\"()", "columnsize", null}, {"\"storage\"()", "heapsize", null}, {"\"storage\"()", "hashes", null}, {"\"storage\"()", "phash", null}, {"\"storage\"()", "imprints", null}, {"\"storage\"()", "orderidx", null}, {"storagemodelinput", "\"schema\"", null}, {"storagemodelinput", "\"table\"", null}, {"storagemodelinput", "\"column\"", null}, {"storagemodelinput", "\"type\"", null}, {"storagemodelinput", "typewidth", null}, {"storagemodelinput", "count", null}, {"storagemodelinput", "\"distinct\"", null}, {"storagemodelinput", "atomwidth", null}, {"storagemodelinput", "reference", null}, {"storagemodelinput", "sorted", null}, {"storagemodelinput", "\"unique\"", null}, {"storagemodelinput", "isacolumn", "33"}, {"table_types", "table_type_id", "21"}, {"table_types", "table_type_name", "21"}, {"tables", "id", null}, {"tables", "name", null}, {"tables", "schema_id", null}, {"tables", "\"type\"", null}, {"tables", "system", null}, {"tables", "commit_action", null}, {"tables", "access", null}, {"tables", "temporary", null}, {"tracelog", "ticks", null}, {"tracelog", "stmt", null}, {"triggers", "id", null}, {"triggers", "name", null}, {"triggers", "table_id", null}, {"triggers", "time", null}, {"triggers", "orientation", null}, {"triggers", "event", null}, {"triggers", "statement", null}, {"types", "id", null}, {"types", "systemname", null}, {"types", "sqlname", null}, {"types", "digits", null}, {"types", "scale", null}, {"types", "radix", null}, {"types", "eclass", null}, {"types", "schema_id", null}, {"user_role", "login_id", null}, {"user_role", "role_id", null}, {"users", "name", null}, {"users", "fullname", null}, {"users", "default_schema", null}, {"var_values", "var_name", "29"}, {"var_values", "value", "29"}, {"range_partitions", "table_id", "33"}, {"range_partitions", "partition_id", "33"}, {"range_partitions", "with_nulls", "33"}, {"table_partitions", "id", "33"}, {"table_partitions", "table_id", "33"}, {"table_partitions", "\"type\"", "33"}, {"value_partitions", "table_id", "33"}, {"value_partitions", "partition_id", "33"}, {"fkey_actions", "action_id", "43"}, {"fkey_actions", "action_name", "43"}, {"fkeys", "id", "43"}, {"fkeys", "table_id", "43"}, {"fkeys", "\"type\"", "43"}, {"fkeys", "name", "43"}, {"fkeys", "rkey", "43"}, {"fkeys", "update_action_id", "43"}, {"fkeys", "update_action", "43"}, {"fkeys", "delete_action_id", "43"}, {"fkeys", "delete_action", "43"}};
    private static final String[][] tmp_notnull = new String[][]{{"_columns", "id", null}, {"_columns", "name", null}, {"_columns", "\"type\"", null}, {"_columns", "type_digits", null}, {"_columns", "type_scale", null}, {"_columns", "table_id", null}, {"_columns", "\"null\"", null}, {"_columns", "number", null}, {"_tables", "id", null}, {"_tables", "name", null}, {"_tables", "schema_id", null}, {"_tables", "\"type\"", null}, {"_tables", "system", null}, {"_tables", "commit_action", null}, {"_tables", "access", null}, {"idxs", "id", null}, {"idxs", "table_id", null}, {"idxs", "\"type\"", null}, {"idxs", "name", null}, {"keys", "id", null}, {"keys", "table_id", null}, {"keys", "\"type\"", null}, {"keys", "name", null}, {"keys", "rkey", null}, {"keys", "action", null}, {"objects", "id", null}, {"objects", "name", null}, {"objects", "nr", null}, {"triggers", "id", null}, {"triggers", "name", null}, {"triggers", "table_id", null}, {"triggers", "time", null}, {"triggers", "orientation", null}, {"triggers", "event", null}, {"triggers", "statement", null}};
    private static final String[][] netcdf_notnull = new String[][]{{"netcdf_files", "file_id", null}, {"netcdf_files", "location", null}, {"netcdf_dims", "dim_id", null}, {"netcdf_dims", "file_id", null}, {"netcdf_dims", "name", null}, {"netcdf_dims", "length", null}, {"netcdf_vars", "var_id", null}, {"netcdf_vars", "file_id", null}, {"netcdf_vars", "name", null}, {"netcdf_vars", "vartype", null}, {"netcdf_vardim", "var_id", null}, {"netcdf_vardim", "dim_id", null}, {"netcdf_vardim", "file_id", null}, {"netcdf_vardim", "dimpos", null}, {"netcdf_attrs", "obj_name", null}, {"netcdf_attrs", "att_name", null}, {"netcdf_attrs", "att_type", null}, {"netcdf_attrs", "value", null}, {"netcdf_attrs", "file_id", null}, {"netcdf_attrs", "gr_name", null}};
    private static final String[][] geom_notnull = new String[][]{{"spatial_ref_sys", "srid", null}, {"spatial_ref_sys", "auth_name", null}, {"spatial_ref_sys", "auth_srid", null}, {"spatial_ref_sys", "srtext", null}, {"spatial_ref_sys", "proj4text", null}};

    MDBvalidator(Connection connection) {
        this.con = connection;
    }

    public static void validateSqlCatalogIntegrity(Connection connection, boolean bl) {
        MDBvalidator mDBvalidator = new MDBvalidator(connection);
        mDBvalidator.showValidationInfo = bl;
        if (mDBvalidator.checkMonetDBVersion()) {
            mDBvalidator.validateSchema("sys", null, sys_pkeys, sys_akeys, sys_fkeys, sys_notnull, true);
            mDBvalidator.validateSchema("tmp", null, tmp_pkeys, tmp_akeys, tmp_fkeys, tmp_notnull, true);
        }
    }

    public static void validateSqlNetcdfTablesIntegrity(Connection connection, boolean bl) {
        MDBvalidator mDBvalidator = new MDBvalidator(connection);
        mDBvalidator.showValidationInfo = bl;
        if (mDBvalidator.checkMonetDBVersion() && mDBvalidator.checkTableExists("sys", "netcdf_files") && mDBvalidator.checkTableExists("sys", "netcdf_dims") && mDBvalidator.checkTableExists("sys", "netcdf_vars") && mDBvalidator.checkTableExists("sys", "netcdf_vardim") && mDBvalidator.checkTableExists("sys", "netcdf_attrs")) {
            mDBvalidator.validateSchema("sys", "netcdf", netcdf_pkeys, netcdf_akeys, netcdf_fkeys, netcdf_notnull, false);
        }
    }

    public static void validateSqlGeomTablesIntegrity(Connection connection, boolean bl) {
        MDBvalidator mDBvalidator = new MDBvalidator(connection);
        mDBvalidator.showValidationInfo = bl;
        if (mDBvalidator.checkMonetDBVersion() && mDBvalidator.checkTableExists("sys", "spatial_ref_sys")) {
            mDBvalidator.validateSchema("sys", "geom", geom_pkeys, geom_akeys, geom_fkeys, geom_notnull, false);
        }
    }

    public static void validateSchemaIntegrity(Connection connection, String string, boolean bl) {
        MDBvalidator mDBvalidator = new MDBvalidator(connection);
        mDBvalidator.showValidationInfo = bl;
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if (mDBvalidator.checkSchemaExists(string)) {
            mDBvalidator.validateSchema(string, null, null, null, null, null, true);
        } else if (bl) {
            System.out.println("Schema: " + string + " does not exist in this database.");
        }
    }

    public static void validateDBIntegrity(Connection connection, boolean bl) {
        MDBvalidator mDBvalidator = new MDBvalidator(connection);
        mDBvalidator.showValidationInfo = bl;
        Statement statement = mDBvalidator.createStatement("validateDBIntegrity()");
        if (statement == null) {
            return;
        }
        boolean bl2 = false;
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SELECT name FROM sys.schemas WHERE NOT system ORDER BY name;");
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string = resultSet.getString(1);
                    if (string == null || string.isEmpty()) continue;
                    bl2 = true;
                    mDBvalidator.validateSchema(string, null, null, null, null, null, true);
                }
            }
        }
        catch (SQLException sQLException) {
            MDBvalidator.printExceptions(sQLException);
        }
        MDBvalidator.freeStmtRs(statement, resultSet);
        if (bl && !bl2) {
            System.out.println("No user schemas found in this database.");
        }
    }

    private void validateSchema(String string, String string2, String[][] stringArray, String[][] stringArray2, String[][] stringArray3, String[][] stringArray4, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = "sys".equals(string) || "tmp".equals(string);
        if (stringArray != null) {
            this.validateUniqueness(string, string2, stringArray, "Primary Key uniqueness");
            this.validateNotNull(string, string2, stringArray, "Primary Key Not Null");
        } else {
            this.validateUniqueness(string, true, "Primary Key uniqueness");
        }
        if (stringArray2 != null) {
            this.validateUniqueness(string, string2, stringArray2, "Unique Constraint");
        } else {
            this.validateUniqueness(string, false, "Unique Constraint");
        }
        if (stringArray3 != null) {
            this.validateFKs(string, string2, stringArray3, "Foreign Key referential integrity");
        } else {
            this.validateFKs(string, "Foreign Key referential integrity");
        }
        if (stringArray4 != null) {
            this.validateNotNull(string, string2, stringArray4, "Not Null");
        } else {
            this.validateNotNull(string, bl2, "Not Null");
        }
        if (bl) {
            this.validateMaxCharStrLength(string, bl2, "Max Character Length");
        }
    }

    private void validateUniqueness(String string, String string2, String[][] stringArray, String string3) {
        int n = stringArray.length;
        if (this.showValidationInfo) {
            System.out.println("Checking " + MDBvalidator.minimumWidth(n, 6) + (string2 != null ? " " + string2 : "") + " tables/keys  in schema " + string + " for " + string3 + " violations.");
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("SELECT COUNT(*) AS duplicates, ");
        int n2 = stringBuilder.length();
        for (int i = 0; i < n; ++i) {
            if (!this.isValidVersion(stringArray[i][2])) continue;
            String string4 = stringArray[i][0];
            String string5 = stringArray[i][1];
            stringBuilder.setLength(n2);
            stringBuilder.append(string5).append(" FROM ");
            if (!string4.startsWith("(")) {
                stringBuilder.append(string).append('.');
            }
            stringBuilder.append(string4).append(" GROUP BY ").append(string5).append(" HAVING COUNT(*) > 1;");
            this.validateQuery(stringBuilder.toString(), string, string4, string5, string3);
        }
    }

    private void validateUniqueness(String string, boolean bl, String string2) {
        Statement statement = this.createStatement("validateUniqueness()");
        if (statement == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(400);
        stringBuilder.append(" FROM sys.keys k JOIN sys.tables t ON k.table_id = t.id JOIN sys.schemas s ON t.schema_id = s.id WHERE k.\"type\" ").append(bl ? "= 0" : "IN (1,3)").append(" and s.name = '").append(string).append('\'');
        String string3 = stringBuilder.toString();
        int n = this.runCountQuery(string3);
        if (this.showValidationInfo) {
            System.out.println("Checking " + MDBvalidator.minimumWidth(n, 6) + " keys         in schema " + string + " for " + string2 + " violations.");
        }
        ResultSet resultSet = null;
        try {
            stringBuilder.setLength(0);
            stringBuilder.append("SELECT s.name as sch_nm, t.name as tbl_nm, k.name as key_nm, o.name as col_nm, o.nr").append(" FROM sys.keys k JOIN sys.objects o ON k.id = o.id JOIN sys.tables t ON k.table_id = t.id JOIN sys.schemas s ON t.schema_id = s.id WHERE k.\"type\" ").append(bl ? "= 0" : "IN (1,3)").append(" and s.name = '").append(string).append('\'').append(" ORDER BY t.name, k.name, o.nr;");
            string3 = stringBuilder.toString();
            resultSet = statement.executeQuery(string3);
            if (resultSet != null) {
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                stringBuilder.setLength(0);
                stringBuilder.append("SELECT COUNT(*) AS duplicates, ");
                int n2 = stringBuilder.length();
                while (resultSet.next()) {
                    string4 = resultSet.getString(1);
                    String string8 = resultSet.getString(2);
                    String string9 = resultSet.getString(3);
                    String string10 = resultSet.getString(4);
                    if (string5 == null) {
                        string5 = string8;
                    }
                    if (string6 == null) {
                        string6 = string9;
                    }
                    if (string8.equals(string5) && string9.equals(string6)) {
                        if (string7 == null) {
                            string7 = "\"" + string10 + "\"";
                            continue;
                        }
                        string7 = string7 + ", \"" + string10 + "\"";
                        continue;
                    }
                    stringBuilder.setLength(n2);
                    stringBuilder.append(string7).append(" FROM \"").append(string4).append("\".\"").append(string5).append('\"').append(" GROUP BY ").append(string7).append(" HAVING COUNT(*) > 1;");
                    this.validateQuery(stringBuilder.toString(), string4, string5, string7, string2);
                    string5 = string8;
                    string6 = string9;
                    string7 = "\"" + string10 + "\"";
                }
                if (string4 != null && string5 != null && string7 != null) {
                    stringBuilder.setLength(n2);
                    stringBuilder.append(string7).append(" FROM \"").append(string4).append("\".\"").append(string5).append('\"').append(" GROUP BY ").append(string7).append(" HAVING COUNT(*) > 1;");
                    this.validateQuery(stringBuilder.toString(), string4, string5, string7, string2);
                }
            }
        }
        catch (SQLException sQLException) {
            System.err.println("Failed to execute query: " + string3);
            MDBvalidator.printExceptions(sQLException);
        }
        MDBvalidator.freeStmtRs(statement, resultSet);
    }

    private void validateFKs(String string, String string2, String[][] stringArray, String string3) {
        int n = stringArray.length;
        if (this.showValidationInfo) {
            System.out.println("Checking " + MDBvalidator.minimumWidth(n, 6) + (string2 != null ? " " + string2 : "") + " foreign keys in schema " + string + " for " + string3 + " violations.");
        }
        StringBuilder stringBuilder = new StringBuilder(400);
        stringBuilder.append("SELECT ");
        int n2 = stringBuilder.length();
        for (int i = 0; i < n; ++i) {
            if (!this.isValidVersion(stringArray[i][4])) continue;
            String string4 = stringArray[i][0];
            String string5 = stringArray[i][1];
            String string6 = stringArray[i][2];
            String string7 = stringArray[i][3];
            stringBuilder.setLength(n2);
            stringBuilder.append(string5).append(", * FROM ").append(string).append('.').append(string4);
            if (!string4.contains(" WHERE ")) {
                stringBuilder.append(" WHERE ");
            }
            stringBuilder.append('(').append(string5).append(") NOT IN (SELECT ").append(string6).append(" FROM ");
            if (!string7.contains(".")) {
                stringBuilder.append(string).append('.');
            }
            stringBuilder.append(string7).append(");");
            this.validateQuery(stringBuilder.toString(), string, string4, string5, string3);
        }
    }

    private void validateFKs(String string, String string2) {
        Statement statement = null;
        try {
            statement = this.con.createStatement(1004, 1007);
        }
        catch (SQLException sQLException) {
            System.err.print("Failed to create Statement in validateFKs()");
            MDBvalidator.printExceptions(sQLException);
        }
        if (statement == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(400);
        stringBuilder.append(" FROM sys.keys k JOIN sys.tables t ON k.table_id = t.id JOIN sys.schemas s ON t.schema_id = s.id WHERE k.\"type\" = 2").append(" and s.name = '").append(string).append('\'');
        String string3 = stringBuilder.toString();
        int n = this.runCountQuery(string3);
        if (this.showValidationInfo) {
            System.out.println("Checking " + MDBvalidator.minimumWidth(n, 6) + " foreign keys in schema " + string + " for " + string2 + " violations.");
        }
        ResultSet resultSet = null;
        try {
            stringBuilder.setLength(0);
            stringBuilder.append("SELECT fs.name as fsch, ft.name as ftbl, fo.name as fcol, fo.nr as fnr,ps.name as psch, pt.name as ptbl, po.name as pcol FROM sys.keys fk JOIN sys.objects fo ON fk.id = fo.id JOIN sys.tables ft ON fk.table_id = ft.id JOIN sys.schemas fs ON ft.schema_id = fs.id JOIN sys.keys pk ON fk.rkey = pk.id JOIN sys.objects po ON pk.id = po.id JOIN sys.tables pt ON pk.table_id = pt.id JOIN sys.schemas ps ON pt.schema_id = ps.id WHERE fk.\"type\" = 2 AND fo.nr = po.nr").append(" AND fs.name = '").append(string).append('\'').append(" ORDER BY ft.name, fk.name, fo.nr;");
            string3 = stringBuilder.toString();
            resultSet = statement.executeQuery(string3);
            if (resultSet != null) {
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                String string9 = null;
                int n2 = -1;
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(6);
                LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>(6);
                while (resultSet.next()) {
                    boolean bl;
                    string4 = resultSet.getString(1);
                    string5 = resultSet.getString(2);
                    string6 = resultSet.getString(3);
                    n2 = resultSet.getInt(4);
                    string7 = resultSet.getString(5);
                    string8 = resultSet.getString(6);
                    string9 = resultSet.getString(7);
                    linkedHashSet.clear();
                    linkedHashSet.add(string6);
                    linkedHashSet2.clear();
                    linkedHashSet2.add(string9);
                    while ((bl = resultSet.next()) && resultSet.getInt(4) > 0) {
                        linkedHashSet.add(resultSet.getString(3));
                        linkedHashSet2.add(resultSet.getString(7));
                    }
                    if (bl) {
                        resultSet.previous();
                    }
                    stringBuilder.setLength(0);
                    stringBuilder.append("SELECT ");
                    Iterator iterator = linkedHashSet.iterator();
                    int n3 = 0;
                    while (iterator.hasNext()) {
                        if (n3 > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append('\"').append((String)iterator.next()).append('\"');
                        ++n3;
                    }
                    stringBuilder.append(", * FROM \"").append(string4).append("\".\"").append(string5).append('\"');
                    stringBuilder.append(" WHERE ");
                    iterator = linkedHashSet.iterator();
                    n3 = 0;
                    while (iterator.hasNext()) {
                        if (n3 > 0) {
                            stringBuilder.append(" AND ");
                        }
                        stringBuilder.append('\"').append((String)iterator.next()).append("\" IS NOT NULL");
                        ++n3;
                    }
                    stringBuilder.append(" AND (");
                    iterator = linkedHashSet.iterator();
                    n3 = 0;
                    while (iterator.hasNext()) {
                        if (n3 > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append('\"').append((String)iterator.next()).append('\"');
                        ++n3;
                    }
                    stringBuilder.append(") NOT IN (SELECT ");
                    iterator = linkedHashSet2.iterator();
                    n3 = 0;
                    while (iterator.hasNext()) {
                        if (n3 > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append('\"').append((String)iterator.next()).append('\"');
                        ++n3;
                    }
                    stringBuilder.append(" FROM \"").append(string7).append("\".\"").append(string8).append("\");");
                    this.validateQuery(stringBuilder.toString(), string4, string5, string6, string2);
                }
            }
        }
        catch (SQLException sQLException) {
            System.err.println("Failed to execute query: " + string3);
            MDBvalidator.printExceptions(sQLException);
        }
        MDBvalidator.freeStmtRs(statement, resultSet);
    }

    private void validateNotNull(String string, String string2, String[][] stringArray, String string3) {
        int n = stringArray.length;
        if (this.showValidationInfo) {
            System.out.println("Checking " + MDBvalidator.minimumWidth(n, 6) + (string2 != null ? " " + string2 : "") + " columns      in schema " + string + " for " + string3 + " violations.");
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("SELECT ");
        int n2 = stringBuilder.length();
        boolean bl = false;
        StringBuilder stringBuilder2 = new StringBuilder(80);
        for (int i = 0; i < n; ++i) {
            if (!this.isValidVersion(stringArray[i][2])) continue;
            String string4 = stringArray[i][0];
            String string5 = stringArray[i][1];
            bl = string5.contains(", ");
            stringBuilder2.setLength(0);
            if (bl) {
                String[] stringArray2 = string5.split(", ");
                for (int j = 0; j < stringArray2.length; ++j) {
                    String string6 = stringArray2[j];
                    if (j > 0) {
                        stringBuilder2.append(" OR ");
                    }
                    stringBuilder2.append(string6).append(" IS NULL");
                    if (!string6.endsWith("name") && !string6.endsWith("keyword") && !"\"schema\"".equals(string6) && !"\"table\"".equals(string6) && !"\"column\"".equals(string6) && !"func".equals(string6) && !"mod".equals(string6) && !"statement".equals(string6) && (!"\"type\"".equals(string6) || !"_columns".equals(string4) && !"args".equals(string4) && !"storage()".equals(string4) && !"storagemodelinput".equals(string4))) continue;
                    stringBuilder2.append(" OR ").append(string6).append(" = ''");
                }
            } else {
                stringBuilder2.append(string5).append(" IS NULL");
                if (string5.endsWith("name") || string5.endsWith("keyword") || "\"schema\"".equals(string5) || "\"table\"".equals(string5) || "\"column\"".equals(string5) || "func".equals(string5) || "mod".equals(string5) || "statement".equals(string5) || "\"type\"".equals(string5) && ("_columns".equals(string4) || "args".equals(string4) || "storage()".equals(string4) || "storagemodelinput".equals(string4))) {
                    stringBuilder2.append(" OR ").append(string5).append(" = ''");
                }
            }
            stringBuilder.setLength(n2);
            stringBuilder.append(string5).append(", * FROM ").append(string).append('.').append(string4).append(" WHERE ").append((CharSequence)stringBuilder2).append(';');
            this.validateQuery(stringBuilder.toString(), string, string4, string5, string3);
        }
    }

    private void validateNotNull(String string, boolean bl, String string2) {
        Statement statement = this.createStatement("validateNotNull()");
        if (statement == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(400);
        stringBuilder.append(" from sys.columns c join sys.tables t on c.table_id = t.id join sys.schemas s on t.schema_id = s.id where t.\"type\" in (0, 10, 1, 11) and c.\"null\" = false and t.system = ").append(bl).append(" and s.name = '").append(string).append('\'');
        String string3 = stringBuilder.toString();
        int n = this.runCountQuery(string3);
        if (this.showValidationInfo) {
            System.out.println("Checking " + MDBvalidator.minimumWidth(n, 6) + " columns      in schema " + string + " for " + string2 + " violations.");
        }
        ResultSet resultSet = null;
        try {
            stringBuilder.setLength(0);
            stringBuilder.append("SELECT s.name as sch_nm, t.name as tbl_nm, c.name as col_nm").append(string3).append(" ORDER BY s.name, t.name, c.name;");
            string3 = stringBuilder.toString();
            resultSet = statement.executeQuery(string3);
            if (resultSet != null) {
                while (resultSet.next()) {
                    String string4 = resultSet.getString(1);
                    String string5 = resultSet.getString(2);
                    String string6 = resultSet.getString(3);
                    stringBuilder.setLength(0);
                    stringBuilder.append("SELECT '").append(string4).append('.').append(string5).append('.').append(string6).append("' as full_col_nm, *").append(" FROM \"").append(string4).append("\".\"").append(string5).append('\"').append(" WHERE \"").append(string6).append("\" IS NULL;");
                    this.validateQuery(stringBuilder.toString(), string4, string5, string6, string2);
                }
            }
        }
        catch (SQLException sQLException) {
            System.err.println("Failed to execute query: " + string3);
            MDBvalidator.printExceptions(sQLException);
        }
        MDBvalidator.freeStmtRs(statement, resultSet);
    }

    private void validateMaxCharStrLength(String string, boolean bl, String string2) {
        Statement statement = this.createStatement("validateMaxCharStrLength()");
        if (statement == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(400);
        stringBuilder.append(" from sys.columns c join sys.tables t on c.table_id = t.id join sys.schemas s on t.schema_id = s.id where t.\"type\" in (0, 10, 1, 11) and c.type_digits >= 1 and t.system = ").append(bl).append(" and c.\"type\" in ('varchar','char','clob','json','url','blob')").append(" and s.name = '").append(string).append('\'');
        String string3 = stringBuilder.toString();
        int n = this.runCountQuery(string3);
        if (this.showValidationInfo) {
            System.out.println("Checking " + MDBvalidator.minimumWidth(n, 6) + " columns      in schema " + string + " for " + string2 + " violations.");
        }
        ResultSet resultSet = null;
        try {
            stringBuilder.setLength(0);
            stringBuilder.append("SELECT s.name as sch_nm, t.name as tbl_nm, c.name as col_nm, c.type_digits").append(string3).append(" ORDER BY s.name, t.name, c.name, c.type_digits;");
            string3 = stringBuilder.toString();
            resultSet = statement.executeQuery(string3);
            if (resultSet != null) {
                long l = 0L;
                while (resultSet.next()) {
                    String string4 = resultSet.getString(1);
                    String string5 = resultSet.getString(2);
                    String string6 = resultSet.getString(3);
                    l = resultSet.getLong(4);
                    if (bl && l == 2048L && string6.equals("query")) {
                        l = 0x100000L;
                    }
                    stringBuilder.setLength(0);
                    stringBuilder.append("SELECT '").append(string4).append('.').append(string5).append('.').append(string6).append("' as full_col_nm, ").append(l).append(" as max_allowed_length, ").append("length(\"").append(string6).append("\") as data_length, ").append('\"').append(string6).append("\" as data_value").append(" FROM \"").append(string4).append("\".\"").append(string5).append('\"').append(" WHERE \"").append(string6).append("\" IS NOT NULL AND length(\"").append(string6).append("\") > ").append(l);
                    this.validateQuery(stringBuilder.toString(), string4, string5, string6, string2);
                }
            }
        }
        catch (SQLException sQLException) {
            System.err.println("Failed to execute query: " + string3);
            MDBvalidator.printExceptions(sQLException);
        }
        MDBvalidator.freeStmtRs(statement, resultSet);
    }

    private void validateQuery(String string, String string2, String string3, String string4, String string5) {
        ResultSet resultSet;
        Statement statement;
        block14: {
            statement = this.createStatement("validateQuery()");
            if (statement == null) {
                return;
            }
            resultSet = null;
            try {
                if (this.verbose) {
                    System.out.println(string);
                }
                if ((resultSet = statement.executeQuery(string)) != null) {
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n = resultSetMetaData.getColumnCount();
                    StringBuilder stringBuilder = new StringBuilder(1024);
                    int n2 = 0;
                    while (resultSet.next()) {
                        int n3;
                        if (++n2 == 1) {
                            for (n3 = 1; n3 <= n; ++n3) {
                                stringBuilder.append(n3 > 1 ? ", " : "\t");
                                stringBuilder.append(resultSetMetaData.getColumnLabel(n3));
                            }
                            stringBuilder.append('\n');
                        }
                        if (n2 > 16) continue;
                        for (n3 = 1; n3 <= n; ++n3) {
                            stringBuilder.append(n3 > 1 ? ", " : "\t");
                            String string6 = resultSet.getString(n3);
                            if (string6 == null || resultSet.wasNull()) {
                                stringBuilder.append("null");
                                continue;
                            }
                            int n4 = resultSetMetaData.getColumnType(n3);
                            if (n4 == 12 || n4 == 1 || n4 == 2005 || n4 == -3 || n4 == 2004 || n4 == 91 || n4 == 92 || n4 == 93 || n4 == 2013 || n4 == 2014) {
                                stringBuilder.append('\"').append(string6).append('\"');
                                continue;
                            }
                            stringBuilder.append(string6);
                        }
                        stringBuilder.append('\n');
                    }
                    if (n2 > 0) {
                        if (n2 > 16) {
                            stringBuilder.append("...\n");
                            stringBuilder.append("Listed only first ").append(16).append(" violations of ").append(n2).append(" found!\n");
                        }
                        this.logViolations(string5, string2, string3, string4, string, stringBuilder.toString());
                    }
                }
            }
            catch (SQLException sQLException) {
                String string7;
                String string8 = sQLException.getSQLState();
                boolean bl = "42000".equals(string8);
                if (bl && (string7 = sQLException.getMessage()) != null) {
                    boolean bl2 = bl = string7.startsWith("SELECT: access denied for") || string7.startsWith("SELECT: insufficient privileges for");
                }
                if (bl) break block14;
                System.err.println("Failed to execute query: " + string);
                MDBvalidator.printExceptions(sQLException);
            }
        }
        MDBvalidator.freeStmtRs(statement, resultSet);
    }

    private int runCountQuery(String string) {
        Statement statement = this.createStatement("runCountQuery()");
        if (statement == null) {
            return 0;
        }
        ResultSet resultSet = null;
        int n = 0;
        try {
            resultSet = statement.executeQuery("SELECT COUNT(*) " + string);
            if (resultSet != null && resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            System.err.println("Failed to execute SELECT COUNT(*) " + string);
            MDBvalidator.printExceptions(sQLException);
        }
        MDBvalidator.freeStmtRs(statement, resultSet);
        return n;
    }

    private Statement createStatement(String string) {
        try {
            return this.con.createStatement();
        }
        catch (SQLException sQLException) {
            System.err.print("Failed to create Statement in " + string);
            MDBvalidator.printExceptions(sQLException);
            return null;
        }
    }

    private boolean checkMonetDBVersion() {
        if (this.majorversion == 0 && this.minorversion == 0) {
            try {
                DatabaseMetaData databaseMetaData = this.con.getMetaData();
                if (databaseMetaData != null) {
                    this.majorversion = databaseMetaData.getDatabaseMajorVersion();
                    this.minorversion = databaseMetaData.getDatabaseMinorVersion();
                    if (this.minorversion / 2 * 2 == this.minorversion) {
                        ++this.minorversion;
                    }
                }
            }
            catch (SQLException sQLException) {
                MDBvalidator.printExceptions(sQLException);
            }
        }
        if (this.majorversion < 11 || this.majorversion == 11 && this.minorversion < 19) {
            System.out.println("Warning: this MonetDB server is too old for MDBvalidator. Please upgrade MonetDB server.");
            return false;
        }
        return true;
    }

    private boolean isValidVersion(String string) {
        if (string == null) {
            return true;
        }
        try {
            int n = Integer.parseInt(string);
            return this.minorversion >= n;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Failed to parse version string '" + string + "' as an integer number.");
            return false;
        }
    }

    private boolean checkSchemaExists(String string) {
        Statement statement = this.createStatement("checkSchemaExists()");
        if (statement == null) {
            return false;
        }
        String string2 = "SELECT name FROM sys.schemas WHERE name = '" + string + "';";
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            resultSet = statement.executeQuery(string2);
            if (resultSet != null && resultSet.next() && string != null && string.equals(resultSet.getString(1))) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            System.err.println("Failed to execute " + string2);
            MDBvalidator.printExceptions(sQLException);
        }
        MDBvalidator.freeStmtRs(statement, resultSet);
        return bl;
    }

    private boolean checkTableExists(String string, String string2) {
        Statement statement = this.createStatement("checkTableExists()");
        if (statement == null) {
            return false;
        }
        String string3 = "SELECT s.name, t.name FROM sys.tables t JOIN sys.schemas s ON t.schema_id = s.id WHERE t.name = '" + string2 + "' AND s.name = '" + string + "';";
        ResultSet resultSet = null;
        boolean bl = false;
        try {
            resultSet = statement.executeQuery(string3);
            if (resultSet != null && resultSet.next() && string != null && string.equals(resultSet.getString(1)) && string2 != null && string2.equals(resultSet.getString(2))) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            System.err.println("Failed to execute " + string3);
            MDBvalidator.printExceptions(sQLException);
        }
        MDBvalidator.freeStmtRs(statement, resultSet);
        return bl;
    }

    private void logViolations(String string, String string2, String string3, String string4, String string5, String string6) {
        StringBuilder stringBuilder = new StringBuilder(2048);
        stringBuilder.append(string).append(" violation(s) found in \"").append(string2).append("\".\"").append(string3).append("\" (").append(string4).append("):\n").append(string6).append("Found using query: ").append(string5).append("\n");
        System.out.println(stringBuilder.toString());
    }

    private static void printExceptions(SQLException sQLException) {
        while (sQLException != null) {
            System.err.println(sQLException.getSQLState() + " " + sQLException.getMessage());
            sQLException = sQLException.getNextException();
        }
    }

    private static void freeStmtRs(Statement statement, ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static String minimumWidth(int n, int n2) {
        String string = Integer.toString(n);
        int n3 = n2 - string.length();
        switch (n3) {
            case 1: {
                return " " + string;
            }
            case 2: {
                return "  " + string;
            }
            case 3: {
                return "   " + string;
            }
            case 4: {
                return "    " + string;
            }
            case 5: {
                return "     " + string;
            }
            case 6: {
                return "      " + string;
            }
        }
        return string;
    }
}

