/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo.wrapper.collection;

import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hop.mongo.MongoDbException;
import org.apache.hop.mongo.wrapper.collection.MongoCollectionWrapper;
import org.apache.hop.mongo.wrapper.cursor.DefaultCursorWrapper;
import org.apache.hop.mongo.wrapper.cursor.MongoCursorWrapper;
import org.bson.Document;
import org.bson.conversions.Bson;

public class DefaultMongoCollectionWrapper
implements MongoCollectionWrapper {
    private final MongoCollection<Document> collection;

    public DefaultMongoCollectionWrapper(MongoCollection<Document> collection) {
        this.collection = collection;
    }

    @Override
    public MongoCursorWrapper find(Bson query, Bson projection) throws MongoDbException {
        FindIterable findIterable = this.collection.find(query);
        if (projection != null) {
            findIterable = findIterable.projection(projection);
        }
        return this.wrap((FindIterable<Document>)findIterable);
    }

    @Override
    public AggregateIterable<Document> aggregate(List<? extends Bson> pipeline) {
        return this.collection.aggregate(new ArrayList<Bson>(pipeline));
    }

    @Override
    public AggregateIterable<Document> aggregate(Bson firstP, Bson[] remainder) throws MongoDbException {
        ArrayList<Bson> pipeline = new ArrayList<Bson>();
        pipeline.add(firstP);
        Collections.addAll(pipeline, remainder);
        return this.aggregate(pipeline);
    }

    @Override
    public MongoCursorWrapper find() throws MongoDbException {
        return this.wrap((FindIterable<Document>)this.collection.find());
    }

    @Override
    public void drop() throws MongoDbException {
        this.collection.drop();
    }

    @Override
    public UpdateResult update(Bson updateQuery, Bson insertUpdate, boolean upsert, boolean multi) throws MongoDbException {
        UpdateOptions options = new UpdateOptions().upsert(upsert);
        if (multi) {
            return this.collection.updateMany(updateQuery, insertUpdate, options);
        }
        return this.collection.updateOne(updateQuery, insertUpdate, options);
    }

    @Override
    public InsertManyResult insert(List<Document> batch) throws MongoDbException {
        return this.collection.insertMany(batch);
    }

    @Override
    public MongoCursorWrapper find(Bson query) throws MongoDbException {
        return this.wrap((FindIterable<Document>)this.collection.find(query));
    }

    @Override
    public void dropIndex(Bson mongoIndex) throws MongoDbException {
        this.collection.dropIndex(mongoIndex);
    }

    @Override
    public void createIndex(Bson mongoIndex) throws MongoDbException {
        this.collection.createIndex(mongoIndex);
    }

    @Override
    public void createIndex(Bson mongoIndex, Bson options) throws MongoDbException {
        IndexOptions indexOptions = new IndexOptions();
        if (options instanceof Document) {
            Document doc = (Document)options;
            if (doc.containsKey((Object)"background")) {
                indexOptions.background(doc.getBoolean((Object)"background", false));
            }
            if (doc.containsKey((Object)"unique")) {
                indexOptions.unique(doc.getBoolean((Object)"unique", false));
            }
            if (doc.containsKey((Object)"sparse")) {
                indexOptions.sparse(doc.getBoolean((Object)"sparse", false));
            }
            if (doc.containsKey((Object)"name")) {
                indexOptions.name(doc.getString((Object)"name"));
            }
        }
        this.collection.createIndex(mongoIndex, indexOptions);
    }

    @Override
    public DeleteResult remove() throws MongoDbException {
        return this.remove((Bson)new Document());
    }

    @Override
    public DeleteResult remove(Bson query) throws MongoDbException {
        return this.collection.deleteMany(query);
    }

    @Override
    public UpdateResult save(Document toTry) throws MongoDbException {
        Object id = toTry.get((Object)"_id");
        if (id != null) {
            return this.collection.replaceOne(Filters.eq((String)"_id", (Object)id), (Object)toTry, new ReplaceOptions().upsert(true));
        }
        this.collection.insertOne((Object)toTry);
        return UpdateResult.acknowledged((long)0L, (Long)1L, null);
    }

    @Override
    public long count() throws MongoDbException {
        return this.collection.countDocuments();
    }

    @Override
    public List distinct(String key) throws MongoDbException {
        ArrayList result = new ArrayList();
        this.collection.distinct(key, Object.class).into(result);
        return result;
    }

    protected MongoCursorWrapper wrap(FindIterable<Document> findIterable) {
        return new DefaultCursorWrapper(findIterable);
    }
}

