/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.impl.AmqpResponseCode;
import com.microsoft.azure.eventhubs.impl.ExceptionUtil;
import com.microsoft.azure.eventhubs.impl.OperationResult;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.qpid.proton.message.Message;

class MessageOperationResult
implements OperationResult<Message, Exception> {
    private final Consumer<Message> onComplete;
    private final Consumer<Exception> onError;

    MessageOperationResult(Consumer<Message> onComplete, Consumer<Exception> onError) {
        Objects.requireNonNull(onComplete);
        Objects.requireNonNull(onError);
        this.onComplete = onComplete;
        this.onError = onError;
    }

    @Override
    public void onComplete(Message response) {
        int statusCode = (Integer)response.getApplicationProperties().getValue().get("status-code");
        String statusDescription = (String)response.getApplicationProperties().getValue().get("status-description");
        if (statusCode == AmqpResponseCode.ACCEPTED.getValue() || statusCode == AmqpResponseCode.OK.getValue()) {
            this.onComplete.accept(response);
        } else {
            this.onError(ExceptionUtil.amqpResponseCodeToException(statusCode, statusDescription));
        }
    }

    @Override
    public void onError(Exception error) {
        this.onError.accept(error);
    }
}

