/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hosted.kafka.auth;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.BearerAuthCredentialProvider;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;

public class GcpBearerAuthCredentialProvider
implements BearerAuthCredentialProvider {
    private static final String GOOGLE_CLOUD_PLATFORM_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    private static final String GCP_ALIAS = "GCP";
    private final GoogleCredentials credentials;
    private String targetSchemaRegistry;
    private String targetIdentityPoolId;

    public GcpBearerAuthCredentialProvider() {
        try {
            this.credentials = GoogleCredentials.getApplicationDefault().createScoped(new String[]{GOOGLE_CLOUD_PLATFORM_SCOPE});
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create Google credentials", e);
        }
    }

    @VisibleForTesting
    public GcpBearerAuthCredentialProvider(GoogleCredentials credentials) {
        this.credentials = credentials;
    }

    public String alias() {
        return GCP_ALIAS;
    }

    public String getTargetSchemaRegistry() {
        return this.targetSchemaRegistry;
    }

    public String getTargetIdentityPoolId() {
        return this.targetIdentityPoolId;
    }

    public String getBearerToken(URL url) {
        String tokenValue;
        try {
            this.credentials.refreshIfExpired();
            tokenValue = this.credentials.getAccessToken().getTokenValue();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to refresh or fetch Google credentials ", e);
        }
        return tokenValue;
    }

    public void configure(Map<String, ?> configs) {
        ConfigurationUtils cu = new ConfigurationUtils(configs);
        this.targetSchemaRegistry = cu.validateString("bearer.auth.logical.cluster", false);
        this.targetIdentityPoolId = cu.validateString("bearer.auth.identity.pool.id", false);
    }
}

