/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.telemetry;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.telemetry.TelemetryApi;
import org.neo4j.driver.internal.util.Futures;

public class ApiTelemetryWork {
    private final TelemetryApi telemetryApi;
    private final AtomicBoolean completedWithSuccess;
    private final AtomicBoolean enabled;

    public ApiTelemetryWork(TelemetryApi telemetryApi) {
        this.telemetryApi = telemetryApi;
        this.completedWithSuccess = new AtomicBoolean(false);
        this.enabled = new AtomicBoolean(true);
    }

    public void setEnabled(boolean enabled) {
        this.enabled.set(enabled);
    }

    public CompletionStage<Void> execute(Connection connection, BoltProtocol protocol) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (connection.isTelemetryEnabled() && this.enabled.get() && !this.completedWithSuccess.get()) {
            protocol.telemetry(connection, this.telemetryApi.getValue()).thenAccept(unused -> this.completedWithSuccess.set(true)).whenComplete(Futures.futureCompletingConsumer(future));
        } else {
            future.complete(null);
        }
        return future;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiTelemetryWork that = (ApiTelemetryWork)o;
        return this.telemetryApi == that.telemetryApi && Objects.equals(this.completedWithSuccess.get(), that.completedWithSuccess.get()) && Objects.equals(this.enabled.get(), that.enabled.get());
    }

    public String toString() {
        return "ApiTelemetryWork{telemetryApi=" + this.telemetryApi + ", completedWithSuccess=" + this.completedWithSuccess.get() + ", enabled=" + this.enabled.get() + "}";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.telemetryApi, this.completedWithSuccess, this.enabled});
    }
}

