/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.setvariable;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;

public class VariableItem {
    private static final Class<?> PKG = VariableItem.class;
    public static final String VARIABLE_TYPE_ROOT_WORKFLOW = "ROOT_WORKFLOW";
    public static final String VARIABLE_TYPE_GRAND_PARENT_WORKFLOW = "GP_WORKFLOW";
    public static final String VARIABLE_TYPE_PARENT_WORKFLOW = "PARENT_WORKFLOW";
    public static final String VARIABLE_TYPE_JVM = "JVM";
    private static final String[] variableTypeCodes = new String[]{"JVM", "PARENT_WORKFLOW", "GP_WORKFLOW", "ROOT_WORKFLOW"};
    private static final String[] variableTypeDescriptions = new String[]{"SetVariable.Validity.Jvm", "SetVariable.Validity.Parent", "SetVariable.Validity.GParent", "SetVariable.Validity.RootWf"};
    @HopMetadataProperty(key="field_name")
    private String fieldName;
    @HopMetadataProperty(key="variable_name")
    private String variableName;
    @HopMetadataProperty(key="variable_type")
    private String variableType;
    @HopMetadataProperty(key="default_value")
    private String defaultValue;

    public VariableItem() {
    }

    public VariableItem(String fieldName, String variableName, String variableType, String defaultValue) {
        this.fieldName = fieldName;
        this.variableName = variableName;
        this.variableType = variableType;
        this.defaultValue = defaultValue;
    }

    public static final String[] getVariableTypeDescriptionsList() {
        ArrayList<String> variableTypesList = new ArrayList<String>(variableTypeDescriptions.length);
        for (String variableTypeDescription : variableTypeDescriptions) {
            variableTypesList.add(BaseMessages.getString(PKG, (String)variableTypeDescription, (String[])new String[0]));
        }
        return variableTypesList.toArray(new String[0]);
    }

    public static final String getVariableTypeDescription(String variableType) {
        String vt = null;
        for (int i = 0; i < variableTypeCodes.length; ++i) {
            if (!variableTypeCodes[i].equalsIgnoreCase(variableType)) continue;
            vt = BaseMessages.getString(PKG, (String)variableTypeDescriptions[i], (String[])new String[0]);
        }
        return vt;
    }

    public static final String getVariableTypeFromDesc(String variableTypeDesc) {
        String vt = variableTypeCodes[0];
        for (int i = 0; i < variableTypeDescriptions.length; ++i) {
            if (!BaseMessages.getString(PKG, (String)variableTypeDescriptions[i], (String[])new String[0]).equalsIgnoreCase(variableTypeDesc)) continue;
            vt = variableTypeCodes[i];
        }
        return vt;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getVariableType() {
        return this.variableType;
    }

    public void setVariableType(String variableType) {
        this.variableType = variableType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableItem that = (VariableItem)o;
        return this.variableType == that.variableType && this.fieldName.equals(that.fieldName) && this.variableName.equals(that.variableName) && this.defaultValue.equals(that.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.variableName, this.variableType, this.defaultValue);
    }
}

