/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.setvariable;

import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.setvariable.SetVariableData;
import org.apache.hop.pipeline.transforms.setvariable.SetVariableMeta;
import org.apache.hop.pipeline.transforms.setvariable.VariableItem;
import org.apache.hop.workflow.engine.IWorkflowEngine;

public class SetVariable
extends BaseTransform<SetVariableMeta, SetVariableData> {
    private static final Class<?> PKG = SetVariableMeta.class;
    public static final String CONST_WARNING_CAN_T_SET_VARIABLE = "WARNING: Can't set variable [";

    public SetVariable(TransformMeta transformMeta, SetVariableMeta meta, SetVariableData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] rowData = this.getRow();
        if (rowData == null) {
            if (this.first) {
                if (this.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"SetVariable.Log.NoInputRowSetDefault", (String[])new String[0]));
                }
                List<VariableItem> vars = ((SetVariableMeta)this.meta).getVariables();
                for (int i = 0; i < vars.size(); ++i) {
                    if (Utils.isEmpty((CharSequence)vars.get(i).getDefaultValue())) continue;
                    this.setValue(rowData, i, true);
                }
            }
            if (this.isBasic()) {
                this.logBasic("Finished after " + this.getLinesWritten() + " rows.");
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((SetVariableData)this.data).outputMeta = this.getInputRowMeta().clone();
            if (this.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"SetVariable.Log.SettingVar", (String[])new String[0]));
            }
            for (int i = 0; i < ((SetVariableMeta)this.meta).getVariables().size(); ++i) {
                this.setValue(rowData, i, false);
            }
            this.putRow(((SetVariableData)this.data).outputMeta, rowData);
            return true;
        }
        throw new HopTransformException(BaseMessages.getString(PKG, (String)"SetVariable.RuntimeError.MoreThanOneRowReceived.SETVARIABLE0007", (String[])new String[0]));
    }

    private void setValue(Object[] rowData, int i, boolean usedefault) throws HopException {
        String varname;
        String value = null;
        List<VariableItem> vars = ((SetVariableMeta)this.meta).getVariables();
        if (usedefault) {
            value = this.resolve(vars.get(i).getDefaultValue());
        } else {
            int index = ((SetVariableData)this.data).outputMeta.indexOfValue(vars.get(i).getFieldName());
            if (index < 0) {
                throw new HopException("Unable to find field [" + vars.get(i).getFieldName() + "] in input row");
            }
            IValueMeta valueMeta = ((SetVariableData)this.data).outputMeta.getValueMeta(index);
            Object valueData = rowData[index];
            value = ((SetVariableMeta)this.meta).isUsingFormatting() ? valueMeta.getString(valueData) : valueMeta.getCompatibleString(valueData);
        }
        if (value == null) {
            value = "";
        }
        if (Utils.isEmpty((CharSequence)(varname = vars.get(i).getVariableName()))) {
            if (Utils.isEmpty((CharSequence)value)) {
                throw new HopException("Variable name nor value was specified on line #" + (i + 1));
            }
            throw new HopException("There was no variable name specified for value [" + value + "]");
        }
        this.setVariable(varname, value);
        IPipelineEngine pipeline = this.getPipeline();
        pipeline.setVariable(varname, value);
        while (pipeline.getParentPipeline() != null) {
            pipeline = pipeline.getParentPipeline();
            pipeline.setVariable(varname, value);
        }
        switch (vars.get(i).getVariableType()) {
            case "JVM": {
                IWorkflowEngine parentWorkflow;
                System.setProperty(varname, value);
                for (parentWorkflow = pipeline.getParentWorkflow(); parentWorkflow != null; parentWorkflow = parentWorkflow.getParentWorkflow()) {
                    parentWorkflow.setVariable(varname, value);
                }
                break;
            }
            case "ROOT_WORKFLOW": {
                IWorkflowEngine parentWorkflow;
                for (parentWorkflow = pipeline.getParentWorkflow(); parentWorkflow != null; parentWorkflow = parentWorkflow.getParentWorkflow()) {
                    parentWorkflow.setVariable(varname, value);
                }
                break;
            }
            case "GP_WORKFLOW": {
                IWorkflowEngine parentWorkflow = pipeline.getParentWorkflow();
                if (parentWorkflow != null) {
                    parentWorkflow.setVariable(varname, value);
                } else if (this.isBasic()) {
                    this.logBasic(CONST_WARNING_CAN_T_SET_VARIABLE + varname + "] on parent workflow: the parent workflow is not available");
                }
                IWorkflowEngine gpJob = pipeline.getParentWorkflow().getParentWorkflow();
                if (gpJob != null) {
                    gpJob.setVariable(varname, value);
                    break;
                }
                if (!this.isBasic()) break;
                this.logBasic(CONST_WARNING_CAN_T_SET_VARIABLE + varname + "] on grand parent workflow: the grand parent workflow is not available");
                break;
            }
            case "PARENT_WORKFLOW": {
                IWorkflowEngine parentWorkflow = pipeline.getParentWorkflow();
                if (parentWorkflow != null) {
                    parentWorkflow.setVariable(varname, value);
                    break;
                }
                if (!this.isBasic()) break;
                this.logBasic(CONST_WARNING_CAN_T_SET_VARIABLE + varname + "] on parent workflow: the parent workflow is not available");
                break;
            }
        }
        if (this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"SetVariable.Log.SetVariableToValue", (String[])new String[]{vars.get(i).getVariableName(), value}));
        }
    }
}

