/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.files;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.util.JsonSerialization;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class AbstractManifestData<T extends AbstractManifestData>
implements Serializable,
IOStatisticsSource {
    public static String marshallPath(@Nullable Path path) {
        return path != null ? path.toUri().toString() : null;
    }

    public static Path unmarshallPath(String path) {
        try {
            return new Path(new URI(Objects.requireNonNull(path, "No path")));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to parse \"" + path + "\" : " + e, e);
        }
    }

    public abstract T validate() throws IOException;

    public abstract byte[] toBytes() throws IOException;

    public abstract void save(FileSystem var1, Path var2, boolean var3) throws IOException;

    public abstract JsonSerialization<T> createSerializer();

    void validateCollectionClass(Iterable it, Class classname) throws IOException {
        for (Object o : it) {
            AbstractManifestData.verify(o.getClass().equals(classname), "Collection element is not a %s: %s", classname, o.getClass());
        }
    }

    static void verify(boolean expression, String message, Object ... args) throws IOException {
        if (!expression) {
            throw new IOException(String.format(message, args));
        }
    }
}

