/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.logging;

import com.google.api.core.InternalApi;
import com.google.api.gax.logging.LogData;
import com.google.api.gax.logging.LoggerProvider;
import com.google.api.gax.logging.LoggingUtils;
import com.google.api.gax.logging.Slf4jUtils;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.event.Level;

@InternalApi
class Slf4jLoggingHelpers {
    static final Gson gson = new Gson();

    static Map<String, Object> messageToMapWithGson(Message message) throws InvalidProtocolBufferException {
        String json = JsonFormat.printer().print((MessageOrBuilder)message);
        return (Map)gson.fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
    }

    static void recordServiceRpcAndRequestHeaders(String serviceName, String rpcName, String endpoint, Map<String, String> requestHeaders, LogData.Builder logDataBuilder, LoggerProvider loggerProvider) {
        LoggingUtils.executeWithTryCatch(() -> {
            Logger logger = loggerProvider.getLogger();
            if (logger.isInfoEnabled()) {
                Slf4jLoggingHelpers.addIfNotEmpty(logDataBuilder::serviceName, serviceName);
                Slf4jLoggingHelpers.addIfNotEmpty(logDataBuilder::rpcName, rpcName);
                Slf4jLoggingHelpers.addIfNotEmpty(logDataBuilder::httpUrl, endpoint);
            }
            if (logger.isDebugEnabled()) {
                logDataBuilder.requestHeaders(requestHeaders);
            }
        });
    }

    private static void addIfNotEmpty(Consumer<String> setter, String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            setter.accept(value);
        }
    }

    static void recordResponseHeaders(Map<String, String> headers, LogData.Builder logDataBuilder, LoggerProvider loggerProvider) {
        LoggingUtils.executeWithTryCatch(() -> {
            Logger logger = loggerProvider.getLogger();
            if (logger.isDebugEnabled()) {
                logDataBuilder.responseHeaders(headers);
            }
        });
    }

    static <RespT> void recordResponsePayload(RespT message, LogData.Builder logDataBuilder, LoggerProvider loggerProvider) {
        LoggingUtils.executeWithTryCatch(() -> {
            Logger logger = loggerProvider.getLogger();
            if (logger.isDebugEnabled()) {
                if (!(message instanceof Message)) {
                    return;
                }
                Map<String, Object> messageToMapWithGson = Slf4jLoggingHelpers.messageToMapWithGson((Message)message);
                logDataBuilder.responsePayload(messageToMapWithGson);
            }
        });
    }

    static void logResponse(String status, LogData.Builder logDataBuilder, LoggerProvider loggerProvider) {
        LoggingUtils.executeWithTryCatch(() -> {
            Logger logger = loggerProvider.getLogger();
            if (logger.isInfoEnabled()) {
                logDataBuilder.responseStatus(status);
            }
            if (logger.isInfoEnabled() && !logger.isDebugEnabled()) {
                Map<String, Object> responseData = logDataBuilder.build().toMapResponse();
                Slf4jUtils.log(logger, Level.INFO, responseData, "Received response");
            }
            if (logger.isDebugEnabled()) {
                Map<String, Object> responsedDetailsMap = logDataBuilder.build().toMapResponse();
                Slf4jUtils.log(logger, Level.DEBUG, responsedDetailsMap, "Received response");
            }
        });
    }

    static <RespT> void logRequest(RespT message, LogData.Builder logDataBuilder, LoggerProvider loggerProvider) {
        LoggingUtils.executeWithTryCatch(() -> {
            Logger logger = loggerProvider.getLogger();
            if (logger.isInfoEnabled() && !logger.isDebugEnabled()) {
                Slf4jUtils.log(logger, Level.INFO, logDataBuilder.build().toMapRequest(), "Sending request");
            }
            if (logger.isDebugEnabled()) {
                if (!(message instanceof Message)) {
                    return;
                }
                Map<String, Object> messageToMapWithGson = Slf4jLoggingHelpers.messageToMapWithGson((Message)message);
                logDataBuilder.requestPayload(messageToMapWithGson);
                Map<String, Object> requestDetailsMap = logDataBuilder.build().toMapRequest();
                Slf4jUtils.log(logger, Level.DEBUG, requestDetailsMap, "Sending request");
            }
        });
    }

    private Slf4jLoggingHelpers() {
    }
}

