/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.calculator.calculations.date;

import java.util.Calendar;
import java.util.Date;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.calculator.CalculationInput;
import org.apache.hop.pipeline.transforms.calculator.CalculationOutput;
import org.apache.hop.pipeline.transforms.calculator.ICalculation;

public class LastDayOfMonth
implements ICalculation {
    private static final String description = BaseMessages.getString((Class)PKG, (String)"CalculatorMetaFunction.CalcFunctions.LastDayOfMonthDate", (String[])new String[0]);

    @Override
    public String getCode() {
        return "LAST_DAY_OF_MONTH";
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getDefaultResultType() {
        return 3;
    }

    @Override
    public CalculationOutput calculate(CalculationInput in) throws HopValueException {
        Date dateValue;
        Date value = null;
        if (!in.metaA.isNull(in.dataA) && (dateValue = in.metaA.getDate(in.dataA)) != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(dateValue);
            cal.set(5, cal.getActualMaximum(5));
            value = cal.getTime();
        }
        return new CalculationOutput(this.getDefaultResultType(), value);
    }
}

