/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Observer;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.internal.operators.NotificationLite;
import rx.internal.util.LinkedArrayList;
import rx.subscriptions.SerialSubscription;

public final class CachedObservable<T>
extends Observable<T> {
    private final CacheState<T> state;

    public static <T> CachedObservable<T> from(Observable<? extends T> source) {
        return CachedObservable.from(source, 16);
    }

    public static <T> CachedObservable<T> from(Observable<? extends T> source, int capacityHint) {
        if (capacityHint < 1) {
            throw new IllegalArgumentException("capacityHint > 0 required");
        }
        CacheState<? extends T> state = new CacheState<T>(source, capacityHint);
        CachedSubscribe<? extends T> onSubscribe = new CachedSubscribe<T>(state);
        return new CachedObservable<T>(onSubscribe, state);
    }

    private CachedObservable(Observable.OnSubscribe<T> onSubscribe, CacheState<T> state) {
        super(onSubscribe);
        this.state = state;
    }

    boolean isConnected() {
        return this.state.isConnected;
    }

    boolean hasObservers() {
        return this.state.producers.length != 0;
    }

    static final class ReplayProducer<T>
    extends AtomicLong
    implements Producer,
    Subscription {
        private static final long serialVersionUID = -2557562030197141021L;
        final Subscriber<? super T> child;
        final CacheState<T> state;
        Object[] currentBuffer;
        int currentIndexInBuffer;
        int index;
        boolean emitting;
        boolean missed;

        public ReplayProducer(Subscriber<? super T> child, CacheState<T> state) {
            this.child = child;
            this.state = state;
        }

        @Override
        public void request(long n) {
            long u;
            long r;
            do {
                if ((r = this.get()) < 0L) {
                    return;
                }
                u = r + n;
                if (u >= 0L) continue;
                u = Long.MAX_VALUE;
            } while (!this.compareAndSet(r, u));
            this.replay();
        }

        public long produced(long n) {
            return this.addAndGet(-n);
        }

        @Override
        public boolean isUnsubscribed() {
            return this.get() < 0L;
        }

        @Override
        public void unsubscribe() {
            long r = this.get();
            if (r >= 0L && (r = this.getAndSet(-1L)) >= 0L) {
                this.state.removeProducer(this);
            }
        }

        /*
         * Exception decompiling
         */
        public void replay() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [47[UNCONDITIONALDOLOOP]], but top level block is 25[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static final class CachedSubscribe<T>
    extends AtomicBoolean
    implements Observable.OnSubscribe<T> {
        private static final long serialVersionUID = -2817751667698696782L;
        final CacheState<T> state;

        public CachedSubscribe(CacheState<T> state) {
            this.state = state;
        }

        @Override
        public void call(Subscriber<? super T> t) {
            ReplayProducer<? super T> rp = new ReplayProducer<T>(t, this.state);
            this.state.addProducer(rp);
            t.add(rp);
            t.setProducer(rp);
            if (!this.get() && this.compareAndSet(false, true)) {
                this.state.connect();
            }
        }
    }

    static final class CacheState<T>
    extends LinkedArrayList
    implements Observer<T> {
        final Observable<? extends T> source;
        final SerialSubscription connection;
        volatile ReplayProducer<?>[] producers;
        static final ReplayProducer<?>[] EMPTY = new ReplayProducer[0];
        volatile boolean isConnected;
        boolean sourceDone;

        public CacheState(Observable<? extends T> source, int capacityHint) {
            super(capacityHint);
            this.source = source;
            this.producers = EMPTY;
            this.connection = new SerialSubscription();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProducer(ReplayProducer<T> p) {
            SerialSubscription serialSubscription = this.connection;
            synchronized (serialSubscription) {
                ReplayProducer<?>[] a = this.producers;
                int n = a.length;
                ReplayProducer[] b = new ReplayProducer[n + 1];
                System.arraycopy(a, 0, b, 0, n);
                b[n] = p;
                this.producers = b;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeProducer(ReplayProducer<T> p) {
            SerialSubscription serialSubscription = this.connection;
            synchronized (serialSubscription) {
                ReplayProducer<?>[] a = this.producers;
                int n = a.length;
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (!a[i].equals(p)) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    this.producers = EMPTY;
                    return;
                }
                ReplayProducer[] b = new ReplayProducer[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
                this.producers = b;
            }
        }

        public void connect() {
            Subscriber subscriber = new Subscriber<T>(){

                @Override
                public void onNext(T t) {
                    CacheState.this.onNext(t);
                }

                @Override
                public void onError(Throwable e) {
                    CacheState.this.onError(e);
                }

                @Override
                public void onCompleted() {
                    CacheState.this.onCompleted();
                }
            };
            this.connection.set(subscriber);
            this.source.unsafeSubscribe(subscriber);
            this.isConnected = true;
        }

        @Override
        public void onNext(T t) {
            if (!this.sourceDone) {
                Object o = NotificationLite.next(t);
                this.add(o);
                this.dispatch();
            }
        }

        @Override
        public void onError(Throwable e) {
            if (!this.sourceDone) {
                this.sourceDone = true;
                Object o = NotificationLite.error(e);
                this.add(o);
                this.connection.unsubscribe();
                this.dispatch();
            }
        }

        @Override
        public void onCompleted() {
            if (!this.sourceDone) {
                this.sourceDone = true;
                Object o = NotificationLite.completed();
                this.add(o);
                this.connection.unsubscribe();
                this.dispatch();
            }
        }

        void dispatch() {
            ReplayProducer<?>[] a;
            for (ReplayProducer<?> rp : a = this.producers) {
                rp.replay();
            }
        }
    }
}

