/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.storage;

import com.google.api.client.util.DateTime;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.extensions.gcp.storage.GcsCreateOptions;
import org.apache.beam.sdk.extensions.gcp.storage.GcsResourceId;
import org.apache.beam.sdk.extensions.gcp.util.GcsUtil;
import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.io.FileSystem;
import org.apache.beam.sdk.io.FileSystemUtils;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Lineage;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Stopwatch;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GcsFileSystem
extends FileSystem<GcsResourceId> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(GcsFileSystem.class);
    private final @UnknownKeyFor @NonNull @Initialized GcsOptions options;
    private @UnknownKeyFor @NonNull @Initialized Counter numCopies;
    private @UnknownKeyFor @NonNull @Initialized Counter numRenames;
    private @UnknownKeyFor @NonNull @Initialized Counter copyTimeMsec;
    private @UnknownKeyFor @NonNull @Initialized Counter renameTimeMsec;

    GcsFileSystem(@UnknownKeyFor @NonNull @Initialized GcsOptions options) {
        this.options = (GcsOptions)Preconditions.checkNotNull((Object)options, (Object)"options");
        if (options.getGcsPerformanceMetrics().booleanValue()) {
            this.numCopies = Metrics.counter(GcsFileSystem.class, (String)"num_copies");
            this.copyTimeMsec = Metrics.counter(GcsFileSystem.class, (String)"copy_time_msec");
            this.numRenames = Metrics.counter(GcsFileSystem.class, (String)"num_renames");
            this.renameTimeMsec = Metrics.counter(GcsFileSystem.class, (String)"rename_time_msec");
        }
    }

    protected @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MatchResult> match(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> specs) throws @UnknownKeyFor @NonNull @Initialized IOException {
        List<GcsPath> gcsPaths = this.toGcsPaths(specs);
        ArrayList globs = Lists.newArrayList();
        ArrayList nonGlobs = Lists.newArrayList();
        ArrayList isGlobBooleans = Lists.newArrayList();
        for (GcsPath path : gcsPaths) {
            if (GcsUtil.isWildcard(path)) {
                globs.add(path);
                isGlobBooleans.add(true);
                continue;
            }
            nonGlobs.add(path);
            isGlobBooleans.add(false);
        }
        Iterator<MatchResult> globsMatchResults = this.matchGlobs(globs).iterator();
        Iterator<MatchResult> nonGlobsMatchResults = this.matchNonGlobs(nonGlobs).iterator();
        ImmutableList.Builder ret = ImmutableList.builder();
        for (Boolean isGlob : isGlobBooleans) {
            if (isGlob.booleanValue()) {
                Preconditions.checkState((boolean)globsMatchResults.hasNext(), (String)"Expect globsMatchResults has next: %s", (Object)globs);
                ret.add((Object)globsMatchResults.next());
                continue;
            }
            Preconditions.checkState((boolean)nonGlobsMatchResults.hasNext(), (String)"Expect nonGlobsMatchResults has next: %s", (Object)nonGlobs);
            ret.add((Object)nonGlobsMatchResults.next());
        }
        Preconditions.checkState((!globsMatchResults.hasNext() ? 1 : 0) != 0, (Object)"Internal error encountered in GcsFilesystem: expected no more elements in globsMatchResults.");
        Preconditions.checkState((!nonGlobsMatchResults.hasNext() ? 1 : 0) != 0, (Object)"Internal error encountered in GcsFilesystem: expected no more elements in globsMatchResults.");
        return ret.build();
    }

    protected @UnknownKeyFor @NonNull @Initialized WritableByteChannel create(@UnknownKeyFor @NonNull @Initialized GcsResourceId resourceId, @UnknownKeyFor @NonNull @Initialized CreateOptions createOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        GcsUtil.CreateOptions.Builder builder = GcsUtil.CreateOptions.builder().setContentType(createOptions.mimeType()).setExpectFileToNotExist(createOptions.expectFileToNotExist());
        if (createOptions instanceof GcsCreateOptions) {
            builder = builder.setUploadBufferSizeBytes(((GcsCreateOptions)createOptions).gcsUploadBufferSizeBytes());
        }
        return this.options.getGcsUtil().create(resourceId.getGcsPath(), builder.build());
    }

    protected @UnknownKeyFor @NonNull @Initialized ReadableByteChannel open(@UnknownKeyFor @NonNull @Initialized GcsResourceId resourceId) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.options.getGcsUtil().open(resourceId.getGcsPath());
    }

    protected void rename(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized GcsResourceId> srcResourceIds, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized GcsResourceId> destResourceIds, MoveOptions ... moveOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.options.getGcsUtil().rename(this.toFilenames(srcResourceIds), this.toFilenames(destResourceIds), moveOptions);
        stopwatch.stop();
        if (this.options.getGcsPerformanceMetrics().booleanValue()) {
            this.numRenames.inc((long)srcResourceIds.size());
            this.renameTimeMsec.inc(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    protected void delete(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized GcsResourceId> resourceIds) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.options.getGcsUtil().remove(this.toFilenames(resourceIds));
    }

    protected @UnknownKeyFor @NonNull @Initialized GcsResourceId matchNewResource(@UnknownKeyFor @NonNull @Initialized String singleResourceSpec, @UnknownKeyFor @NonNull @Initialized boolean isDirectory) {
        if (isDirectory) {
            if (!singleResourceSpec.endsWith("/")) {
                singleResourceSpec = singleResourceSpec + "/";
            }
        } else {
            Preconditions.checkArgument((!singleResourceSpec.endsWith("/") ? 1 : 0) != 0, (String)"Expected a file path, but [%s], ends with '/'. This is unsupported in GcsFileSystem.", (Object)singleResourceSpec);
        }
        GcsPath path = GcsPath.fromUri(singleResourceSpec);
        return GcsResourceId.fromGcsPath(path);
    }

    protected void copy(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized GcsResourceId> srcResourceIds, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized GcsResourceId> destResourceIds) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.options.getGcsUtil().copy(this.toFilenames(srcResourceIds), this.toFilenames(destResourceIds));
        stopwatch.stop();
        if (this.options.getGcsPerformanceMetrics().booleanValue()) {
            this.numCopies.inc((long)srcResourceIds.size());
            this.copyTimeMsec.inc(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    protected @UnknownKeyFor @NonNull @Initialized String getScheme() {
        return "gs";
    }

    protected void reportLineage(@UnknownKeyFor @NonNull @Initialized GcsResourceId resourceId, @UnknownKeyFor @NonNull @Initialized Lineage lineage) {
        this.reportLineage(resourceId, lineage, FileSystem.LineageLevel.FILE);
    }

    protected void reportLineage(@UnknownKeyFor @NonNull @Initialized GcsResourceId resourceId, @UnknownKeyFor @NonNull @Initialized Lineage lineage, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized FileSystem.LineageLevel level) {
        GcsPath path = resourceId.getGcsPath();
        if (!path.getBucket().isEmpty()) {
            ImmutableList.Builder segments = ImmutableList.builder().add((Object)path.getBucket());
            if (level != FileSystem.LineageLevel.TOP_LEVEL && !path.getObject().isEmpty()) {
                segments.add((Object)path.getObject());
            }
            lineage.add("gcs", (Iterable)segments.build(), "/");
        } else {
            LOG.warn("Report Lineage on relative path {} is unsupported", (Object)path.getObject());
        }
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MatchResult> matchGlobs(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized GcsPath> globs) {
        return FluentIterable.from(globs).transform(gcsPath -> {
            try {
                return this.expand((GcsPath)gcsPath);
            }
            catch (IOException e) {
                return MatchResult.create((MatchResult.Status)MatchResult.Status.ERROR, (IOException)e);
            }
        }).toList();
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized MatchResult expand(@UnknownKeyFor @NonNull @Initialized GcsPath gcsPattern) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Objects objects;
        String prefix = GcsUtil.getNonWildcardPrefix(gcsPattern.getObject());
        Pattern p = Pattern.compile(FileSystemUtils.wildcardToRegexp((String)gcsPattern.getObject()));
        LOG.debug("matching files in bucket {}, prefix {} against pattern {}", new Object[]{gcsPattern.getBucket(), prefix, p.toString()});
        String pageToken = null;
        ArrayList<MatchResult.Metadata> results = new ArrayList<MatchResult.Metadata>();
        while ((objects = this.options.getGcsUtil().listObjects(gcsPattern.getBucket(), prefix, pageToken)).getItems() != null) {
            for (StorageObject o : objects.getItems()) {
                String name = o.getName();
                if (!p.matcher(name).matches() || name.endsWith("/")) continue;
                LOG.debug("Matched object: {}", (Object)name);
                results.add(this.toMetadata(o));
            }
            pageToken = objects.getNextPageToken();
            if (pageToken != null) continue;
        }
        return MatchResult.create((MatchResult.Status)MatchResult.Status.OK, results);
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MatchResult> matchNonGlobs(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized GcsPath> gcsPaths) throws @UnknownKeyFor @NonNull @Initialized IOException {
        List<GcsUtil.StorageObjectOrIOException> results = this.options.getGcsUtil().getObjects(gcsPaths);
        ImmutableList.Builder ret = ImmutableList.builder();
        for (GcsUtil.StorageObjectOrIOException result : results) {
            ret.add((Object)this.toMatchResult(result));
        }
        return ret.build();
    }

    private @UnknownKeyFor @NonNull @Initialized MatchResult toMatchResult(@UnknownKeyFor @NonNull @Initialized GcsUtil.StorageObjectOrIOException objectOrException) {
        @Nullable IOException exception = objectOrException.ioException();
        if (exception instanceof FileNotFoundException) {
            return MatchResult.create((MatchResult.Status)MatchResult.Status.NOT_FOUND, (IOException)exception);
        }
        if (exception != null) {
            return MatchResult.create((MatchResult.Status)MatchResult.Status.ERROR, (IOException)exception);
        }
        StorageObject object = objectOrException.storageObject();
        assert (object != null);
        return MatchResult.create((MatchResult.Status)MatchResult.Status.OK, (List)ImmutableList.of((Object)this.toMetadata(object)));
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata toMetadata(@UnknownKeyFor @NonNull @Initialized StorageObject storageObject) {
        MatchResult.Metadata.Builder ret = MatchResult.Metadata.builder().setIsReadSeekEfficient(true).setResourceId((ResourceId)GcsResourceId.fromGcsPath(GcsPath.fromObject(storageObject)));
        if (storageObject.getMd5Hash() != null) {
            ret.setChecksum(storageObject.getMd5Hash());
        }
        BigInteger size = (BigInteger)MoreObjects.firstNonNull((Object)storageObject.getSize(), (Object)BigInteger.ZERO);
        ret.setSizeBytes(size.longValue());
        DateTime lastModified = (DateTime)MoreObjects.firstNonNull((Object)storageObject.getUpdated(), (Object)new DateTime(0L));
        ret.setLastModifiedMillis(lastModified.getValue());
        return ret.build();
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> toFilenames(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized GcsResourceId> resources) {
        return FluentIterable.from(resources).transform(resource -> resource.getGcsPath().toString()).toList();
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized GcsPath> toGcsPaths(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> specs) {
        return FluentIterable.from(specs).transform(GcsPath::fromUri).toList();
    }
}

