/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.InMemoryStateInternals;
import org.apache.beam.runners.core.InMemoryTimerInternals;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.spark.metrics.MetricsContainerStepMapAccumulator;
import org.apache.beam.runners.spark.translation.DoFnRunnerWithMetrics;
import org.apache.beam.runners.spark.translation.SparkInputDataProcessor;
import org.apache.beam.runners.spark.translation.SparkProcessContext;
import org.apache.beam.runners.spark.util.SideInputBroadcast;
import org.apache.beam.runners.spark.util.SideInputReaderFactory;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.WindowedValueMultiReceiver;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterators;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import scala.Tuple2;

public class MultiDoFnFunction<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
implements PairFlatMapFunction<Iterator<WindowedValue<InputT>>, TupleTag<?>, WindowedValue<?>> {
    private final @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMapAccumulator metricsAccum;
    private final @UnknownKeyFor @NonNull @Initialized String stepName;
    private final @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn;
    private final @UnknownKeyFor @NonNull @Initialized boolean useStreamingSideInput;
    private transient @UnknownKeyFor @NonNull @Initialized boolean wasSetupCalled;
    private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions options;
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> additionalOutputTags;
    private final @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized SideInputBroadcast<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> sideInputs;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy;
    private final @UnknownKeyFor @NonNull @Initialized boolean stateful;
    private final @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping;
    private final @UnknownKeyFor @NonNull @Initialized boolean useBoundedConcurrentOutput;

    public MultiDoFnFunction(@UnknownKeyFor @NonNull @Initialized MetricsContainerStepMapAccumulator metricsAccum, @UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn, @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions options, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> additionalOutputTags, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized SideInputBroadcast<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> sideInputs, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized boolean stateful, @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping, @UnknownKeyFor @NonNull @Initialized boolean useBoundedConcurrentOutput, @UnknownKeyFor @NonNull @Initialized boolean useStreamingSideInput) {
        this.metricsAccum = metricsAccum;
        this.stepName = stepName;
        this.doFn = (DoFn)SerializableUtils.clone(doFn);
        this.options = options;
        this.mainOutputTag = mainOutputTag;
        this.additionalOutputTags = additionalOutputTags;
        this.inputCoder = inputCoder;
        this.outputCoders = outputCoders;
        this.sideInputs = sideInputs;
        this.windowingStrategy = windowingStrategy;
        this.stateful = stateful;
        this.doFnSchemaInformation = doFnSchemaInformation;
        this.sideInputMapping = sideInputMapping;
        this.useBoundedConcurrentOutput = useBoundedConcurrentOutput;
        this.useStreamingSideInput = useStreamingSideInput;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> call(@UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> iter) throws @UnknownKeyFor @NonNull @Initialized Exception {
        SparkNoOpStepContext context;
        InMemoryTimerInternals timerInternals;
        if (iter.hasNext()) {
            if (!this.wasSetupCalled) {
                DoFnInvokers.tryInvokeSetupFor(this.doFn, (PipelineOptions)this.options.get());
                this.wasSetupCalled = true;
            }
        } else {
            return Collections.emptyIterator();
        }
        SparkInputDataProcessor<Object, Object, Tuple2<TupleTag<?>, WindowedValue<?>>> processor = this.useBoundedConcurrentOutput ? SparkInputDataProcessor.createBounded() : SparkInputDataProcessor.createUnbounded();
        Object key = null;
        if (this.stateful) {
            if (iter.hasNext()) {
                WindowedValue<InputT> currentValue = iter.next();
                key = ((KV)currentValue.getValue()).getKey();
                iter = Iterators.concat((Iterator)Iterators.singletonIterator(currentValue), iter);
            }
            final InMemoryStateInternals stateInternals = InMemoryStateInternals.forKey(key);
            timerInternals = new InMemoryTimerInternals();
            context = new StepContext(){

                public @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals() {
                    return stateInternals;
                }

                public @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals() {
                    return timerInternals;
                }
            };
        } else {
            timerInternals = null;
            context = new SparkNoOpStepContext();
        }
        DoFnRunner doFnRunner = DoFnRunners.simpleRunner((PipelineOptions)this.options.get(), this.doFn, (SideInputReader)SideInputReaderFactory.create(this.useStreamingSideInput, this.sideInputs), (WindowedValueMultiReceiver)processor.getOutputManager(), this.mainOutputTag, this.additionalOutputTags, (StepContext)context, this.inputCoder, this.outputCoders, this.windowingStrategy, (DoFnSchemaInformation)this.doFnSchemaInformation, this.sideInputMapping);
        DoFnRunnerWithMetrics doFnRunnerWithMetrics = new DoFnRunnerWithMetrics(this.stepName, doFnRunner, this.metricsAccum);
        SparkProcessContext<Object, InputT, OutputT> ctx = new SparkProcessContext<Object, InputT, OutputT>(this.stepName, this.doFn, doFnRunnerWithMetrics, key, this.stateful ? new TimerDataIterator(timerInternals) : Collections.emptyIterator());
        return processor.createOutputIterator(iter, ctx);
    }

    private static class SparkNoOpStepContext
    implements StepContext {
        private SparkNoOpStepContext() {
        }

        public @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals() {
            throw new UnsupportedOperationException("stateInternals not supported");
        }

        public @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals() {
            throw new UnsupportedOperationException("timerInternals not supported");
        }
    }

    private static class TimerDataIterator
    implements Iterator<TimerInternals.TimerData> {
        private final @UnknownKeyFor @NonNull @Initialized InMemoryTimerInternals timerInternals;
        private @UnknownKeyFor @NonNull @Initialized boolean hasAdvance;
        private // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timerData;

        TimerDataIterator(@UnknownKeyFor @NonNull @Initialized InMemoryTimerInternals timerInternals) {
            this.timerInternals = timerInternals;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean hasNext() {
            if (!this.hasAdvance) {
                try {
                    this.timerInternals.advanceInputWatermark(BoundedWindow.TIMESTAMP_MAX_VALUE);
                    this.timerInternals.advanceProcessingTime(BoundedWindow.TIMESTAMP_MAX_VALUE);
                    this.timerInternals.advanceSynchronizedProcessingTime(BoundedWindow.TIMESTAMP_MAX_VALUE);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.hasAdvance = true;
            }
            return (this.timerData = this.timerInternals.removeNextEventTimer()) != null || (this.timerData = this.timerInternals.removeNextProcessingTimer()) != null || (this.timerData = this.timerInternals.removeNextSynchronizedProcessingTimer()) != null;
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData next() {
            if (this.timerData == null) {
                throw new NoSuchElementException();
            }
            return this.timerData;
        }

        @Override
        public void remove() {
            throw new RuntimeException("TimerDataIterator not support remove!");
        }
    }
}

