/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.xp;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.config.IPipelineEngineRunConfiguration;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engines.local.LocalPipelineRunConfiguration;

@ExtensionPoint(extensionPointId="HopGuiPipelineBeforeStart", id="HopGuiFlagPipelineForUnitTestExtensionPoint", description="Change the pipeline variables prior to execution but only in HopGui")
public class HopGuiFlagPipelineForUnitTestExtensionPoint
implements IExtensionPoint<IPipelineEngine> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, IPipelineEngine pipeline) throws HopException {
        IPipelineEngineRunConfiguration runConfig = pipeline.getPipelineRunConfiguration().getEngineRunConfiguration();
        if (!(runConfig instanceof LocalPipelineRunConfiguration)) {
            pipeline.setVariable("__UnitTest_Run__", "N");
            return;
        }
        String runUnitTest = variables.getVariable("__UnitTest_Run__");
        String unitTestName = variables.getVariable("__UnitTest_Name__");
        if ("Y".equalsIgnoreCase(runUnitTest) && !StringUtil.isEmpty((String)unitTestName)) {
            pipeline.setVariable("__UnitTest_Run__", runUnitTest);
            pipeline.setVariable("__UnitTest_Name__", unitTestName);
        }
    }
}

