/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.googledrive.util;

import com.google.api.client.util.IOUtils;
import com.google.api.client.util.Lists;
import com.google.api.client.util.Maps;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.store.AbstractDataStore;
import com.google.api.client.util.store.AbstractDataStoreFactory;
import com.google.api.client.util.store.DataStore;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.client.util.store.FileDataStoreFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CustomDataStoreFactory
extends AbstractDataStoreFactory {
    private final File dataDirectory;

    public CustomDataStoreFactory(File dataDirectory) throws IOException {
        this.dataDirectory = dataDirectory = dataDirectory.getCanonicalFile();
        if (IOUtils.isSymbolicLink((File)dataDirectory)) {
            throw new IOException("unable to use a symbolic link: " + String.valueOf(dataDirectory));
        }
        if (!dataDirectory.exists() && !dataDirectory.mkdirs()) {
            throw new IOException("unable to create directory: " + String.valueOf(dataDirectory));
        }
    }

    protected <V extends Serializable> DataStore<V> createDataStore(String id) throws IOException {
        return new CustomDataStore(this, this.dataDirectory, id);
    }

    static class CustomDataStore<V extends Serializable>
    extends AbstractDataStore<V> {
        private File dataFile = null;
        private File dataDirectory = null;
        private HashMap keyValueMap = Maps.newHashMap();
        private final Lock lock = new ReentrantLock();

        CustomDataStore(CustomDataStoreFactory dataStore, File dataDirectory, String id) throws IOException {
            super((DataStoreFactory)dataStore, id);
            this.dataDirectory = dataDirectory;
            this.dataFile = new File(this.dataDirectory, this.getId());
            if (IOUtils.isSymbolicLink((File)this.dataFile)) {
                throw new IOException("unable to use a symbolic link: " + String.valueOf(this.dataFile));
            }
            this.keyValueMap = Maps.newHashMap();
            if (this.dataFile.exists()) {
                this.keyValueMap = (HashMap)IOUtils.deserialize((InputStream)new FileInputStream(this.dataFile));
            }
        }

        void save() throws IOException {
            this.dataFile.createNewFile();
            IOUtils.serialize((Object)this.keyValueMap, (OutputStream)new FileOutputStream(this.dataFile));
        }

        public final Set<String> keySet() throws IOException {
            Set<String> var1;
            this.lock.lock();
            try {
                var1 = Collections.unmodifiableSet(this.keyValueMap.keySet());
            }
            finally {
                this.lock.unlock();
            }
            return var1;
        }

        public FileDataStoreFactory getDataStoreFactory() {
            return (FileDataStoreFactory)super.getDataStoreFactory();
        }

        public final DataStore<V> clear() throws IOException {
            this.lock.lock();
            try {
                this.keyValueMap.clear();
                this.save();
            }
            finally {
                this.lock.unlock();
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Collection<V> values() throws IOException {
            this.lock.lock();
            try {
                ArrayList result = Lists.newArrayList();
                for (byte[] bytes : this.keyValueMap.values()) {
                    result.add(IOUtils.deserialize((byte[])bytes));
                }
                List list = Collections.unmodifiableList(result);
                return list;
            }
            finally {
                this.lock.unlock();
            }
        }

        public final V get(String key) throws IOException {
            Serializable var2;
            if (key == null) {
                return null;
            }
            this.lock.lock();
            try {
                var2 = IOUtils.deserialize((byte[])((byte[])this.keyValueMap.get(key)));
            }
            finally {
                this.lock.unlock();
            }
            return (V)var2;
        }

        public final DataStore<V> set(String key, V value) throws IOException {
            Preconditions.checkNotNull((Object)key);
            Preconditions.checkNotNull(value);
            this.lock.lock();
            try {
                this.keyValueMap.put(key, IOUtils.serialize(value));
                this.save();
            }
            finally {
                this.lock.unlock();
            }
            return this;
        }

        public DataStore<V> delete(String key) throws IOException {
            if (key == null) {
                return this;
            }
            this.lock.lock();
            try {
                this.keyValueMap.remove(key);
                this.save();
            }
            finally {
                this.lock.unlock();
            }
            return this;
        }
    }
}

