/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.bigtable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.commons.lang3.StringUtils;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.transforms.bigtable.BigtableColumn;
import org.apache.hop.beam.transforms.bigtable.HopToBigtableFn;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dummy.Dummy;
import org.apache.hop.pipeline.transforms.dummy.DummyData;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Transform(id="BeamBigtableOutput", name="i18n::BeamBigtableOutput.Name", description="i18n::BeamBigtableOutput.Description", image="beam-gcp-bigtable-output.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.BigData", keywords={"i18n::BeamBigtableOutputMeta.keyword"}, documentationUrl="/pipeline/transforms/beambigtableoutput.html")
public class BeamBigtableOutputMeta
extends BaseTransformMeta<Dummy, DummyData>
implements IBeamPipelineTransformHandler {
    @HopMetadataProperty(key="project_id")
    private String projectId;
    @HopMetadataProperty(key="instance_id")
    private String instanceId;
    @HopMetadataProperty(key="table_id")
    private String tableId;
    @HopMetadataProperty(key="key_field")
    private String keyField;
    @HopMetadataProperty(groupKey="columns", key="column")
    private List<BigtableColumn> columns = new ArrayList<BigtableColumn>();

    public BeamBigtableOutputMeta() {
    }

    public BeamBigtableOutputMeta(BeamBigtableOutputMeta m) {
        this();
        this.projectId = m.projectId;
        this.instanceId = m.instanceId;
        this.tableId = m.tableId;
        this.keyField = m.keyField;
        for (BigtableColumn column : this.columns) {
            this.columns.add(new BigtableColumn(column));
        }
    }

    public BeamBigtableOutputMeta clone() {
        return new BeamBigtableOutputMeta(this);
    }

    public boolean isInput() {
        return false;
    }

    public boolean isOutput() {
        return true;
    }

    public void handleTransform(ILogChannel log, IVariables variables, String runConfigurationName, IBeamPipelineEngineRunConfiguration runConfiguration, String dataSamplersJson, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input, String parentLogChannelId) throws HopException {
        if (previousTransforms.size() > 1) {
            throw new HopException("Combining data from multiple transforms is not supported yet!");
        }
        TransformMeta previousTransform = previousTransforms.get(0);
        for (BigtableColumn column : this.columns) {
            if (StringUtils.isEmpty((CharSequence)column.getName())) {
                throw new HopException("Every column needs to have a name");
            }
            if (StringUtils.isEmpty((CharSequence)column.getFamily())) {
                throw new HopException("Every column needs to have a family value: " + column.getName());
            }
            if (!StringUtils.isEmpty((CharSequence)column.getSourceField())) continue;
            throw new HopException("Every column needs to have a source field: " + column.getName());
        }
        BigtableIO.Write write = BigtableIO.write().withProjectId(variables.resolve(this.projectId)).withInstanceId(variables.resolve(this.instanceId)).withTableId(variables.resolve(this.tableId));
        String realKeyField = variables.resolve(this.keyField);
        int keyIndex = rowMeta.indexOfValue(realKeyField);
        if (keyIndex < 0) {
            throw new HopException("Key field " + realKeyField + " could not be found in the input");
        }
        JSONArray j = new JSONArray();
        for (BigtableColumn column : this.columns) {
            JSONObject jc = new JSONObject();
            jc.put((Object)"qualifier", (Object)variables.resolve(column.getName()));
            jc.put((Object)"family", (Object)variables.resolve(column.getFamily()));
            jc.put((Object)"field", (Object)variables.resolve(column.getSourceField()));
            j.add((Object)jc);
        }
        HopToBigtableFn function = new HopToBigtableFn(keyIndex, j.toJSONString(), transformMeta.getName(), JsonRowMeta.toJson((IRowMeta)rowMeta));
        PCollection bigtableInput = (PCollection)input.apply(transformMeta.getName(), (PTransform)ParDo.of((DoFn)function));
        write.expand(bigtableInput);
        log.logBasic("Handled transform (Bigtable OUTPUT) : " + transformMeta.getName() + ", gets data from " + previousTransform.getName());
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public List<BigtableColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<BigtableColumn> columns) {
        this.columns = columns;
    }
}

