/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction.graph;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.util.construction.ModelCoders;
import org.apache.beam.sdk.util.construction.ParDoTranslation;
import org.apache.beam.sdk.util.construction.graph.AutoValue_SplittableParDoExpander_SizedReplacement;
import org.apache.beam.sdk.util.construction.graph.ProtoOverrides;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SplittableParDoExpander {
    public static @UnknownKeyFor @NonNull @Initialized ProtoOverrides.TransformReplacement createSizedReplacement() {
        return SizedReplacement.builder().setDrain(false).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized ProtoOverrides.TransformReplacement createTruncateReplacement() {
        return SizedReplacement.builder().setDrain(true).build();
    }

    private static @UnknownKeyFor @NonNull @Initialized String getOrAddDoubleCoder(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ComponentsOrBuilder existingComponents, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.MessageWithComponents.Builder out) {
        for (Map.Entry coder : existingComponents.getCodersMap().entrySet()) {
            if (!ModelCoders.DOUBLE_CODER_URN.equals(((RunnerApi.Coder)coder.getValue()).getSpec().getUrn())) continue;
            return (String)coder.getKey();
        }
        String doubleCoderId = SplittableParDoExpander.generateUniqueId("DoubleCoder", arg_0 -> ((RunnerApi.ComponentsOrBuilder)existingComponents).containsCoders(arg_0));
        out.getComponentsBuilder().putCoders(doubleCoderId, RunnerApi.Coder.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(ModelCoders.DOUBLE_CODER_URN)).build());
        return doubleCoderId;
    }

    private static @UnknownKeyFor @NonNull @Initialized String generateUniquePCollectonName(@UnknownKeyFor @NonNull @Initialized String prefix, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.ComponentsOrBuilder existingComponents) {
        return SplittableParDoExpander.generateUniqueId(prefix, input -> {
            for (RunnerApi.PCollection pc : existingComponents.getPcollectionsMap().values()) {
                if (!input.equals(pc.getUniqueName())) continue;
                return true;
            }
            return false;
        });
    }

    private static @UnknownKeyFor @NonNull @Initialized String generateUniqueId(@UnknownKeyFor @NonNull @Initialized String prefix, @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized String> isExistingId) {
        int i = 0;
        while (isExistingId.test(prefix + i)) {
            ++i;
        }
        return prefix + i;
    }

    @AutoValue
    static abstract class SizedReplacement
    implements ProtoOverrides.TransformReplacement {
        SizedReplacement() {
        }

        static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_SplittableParDoExpander_SizedReplacement.Builder();
        }

        abstract @UnknownKeyFor @NonNull @Initialized boolean isDrain();

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.MessageWithComponents getReplacement(@UnknownKeyFor @NonNull @Initialized String transformId, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.ComponentsOrBuilder existingComponents) {
            try {
                RunnerApi.MessageWithComponents.Builder rval = RunnerApi.MessageWithComponents.newBuilder();
                RunnerApi.PTransform splittableParDo = existingComponents.getTransformsOrThrow(transformId);
                RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom((ByteString)splittableParDo.getSpec().getPayload());
                if (payload.getRestrictionCoderId() == null || payload.getRestrictionCoderId().isEmpty()) {
                    return null;
                }
                String mainInputName = ParDoTranslation.getMainInputName((RunnerApi.PTransformOrBuilder)splittableParDo);
                String mainInputPCollectionId = splittableParDo.getInputsOrThrow(mainInputName);
                RunnerApi.PCollection mainInputPCollection = existingComponents.getPcollectionsOrThrow(mainInputPCollectionId);
                Map sideInputs = Maps.filterKeys((Map)splittableParDo.getInputsMap(), input -> payload.containsSideInputs(input));
                String pairWithRestrictionOutCoderId = SplittableParDoExpander.generateUniqueId(mainInputPCollection.getCoderId() + "/PairWithRestriction", arg_0 -> ((RunnerApi.ComponentsOrBuilder)existingComponents).containsCoders(arg_0));
                rval.getComponentsBuilder().putCoders(pairWithRestrictionOutCoderId, ModelCoders.kvCoder(mainInputPCollection.getCoderId(), payload.getRestrictionCoderId()));
                String pairWithRestrictionOutId = SplittableParDoExpander.generateUniqueId(mainInputPCollectionId + "/PairWithRestriction", arg_0 -> ((RunnerApi.ComponentsOrBuilder)existingComponents).containsPcollections(arg_0));
                rval.getComponentsBuilder().putPcollections(pairWithRestrictionOutId, RunnerApi.PCollection.newBuilder().setCoderId(pairWithRestrictionOutCoderId).setIsBounded(mainInputPCollection.getIsBounded()).setWindowingStrategyId(mainInputPCollection.getWindowingStrategyId()).setUniqueName(SplittableParDoExpander.generateUniquePCollectonName(mainInputPCollection.getUniqueName() + "/PairWithRestriction", existingComponents)).build());
                String splitAndSizeOutCoderId = SplittableParDoExpander.generateUniqueId(mainInputPCollection.getCoderId() + "/SplitAndSize", arg_0 -> ((RunnerApi.ComponentsOrBuilder)existingComponents).containsCoders(arg_0));
                rval.getComponentsBuilder().putCoders(splitAndSizeOutCoderId, ModelCoders.kvCoder(pairWithRestrictionOutCoderId, SplittableParDoExpander.getOrAddDoubleCoder(existingComponents, rval)));
                String splitAndSizeOutId = SplittableParDoExpander.generateUniqueId(mainInputPCollectionId + "/SplitAndSize", arg_0 -> ((RunnerApi.ComponentsOrBuilder)existingComponents).containsPcollections(arg_0));
                rval.getComponentsBuilder().putPcollections(splitAndSizeOutId, RunnerApi.PCollection.newBuilder().setCoderId(splitAndSizeOutCoderId).setIsBounded(mainInputPCollection.getIsBounded()).setWindowingStrategyId(mainInputPCollection.getWindowingStrategyId()).setUniqueName(SplittableParDoExpander.generateUniquePCollectonName(mainInputPCollection.getUniqueName() + "/SplitAndSize", existingComponents)).build());
                String pairWithRestrictionId = SplittableParDoExpander.generateUniqueId(transformId + "/PairWithRestriction", arg_0 -> ((RunnerApi.ComponentsOrBuilder)existingComponents).containsTransforms(arg_0));
                RunnerApi.PTransform.Builder pairWithRestriction = RunnerApi.PTransform.newBuilder();
                pairWithRestriction.putAllInputs(splittableParDo.getInputsMap());
                pairWithRestriction.putOutputs("out", pairWithRestrictionOutId);
                pairWithRestriction.setUniqueName(SplittableParDoExpander.generateUniquePCollectonName(splittableParDo.getUniqueName() + "/PairWithRestriction", existingComponents));
                pairWithRestriction.setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn("beam:transform:sdf_pair_with_restriction:v1").setPayload(splittableParDo.getSpec().getPayload()));
                pairWithRestriction.setEnvironmentId(splittableParDo.getEnvironmentId());
                rval.getComponentsBuilder().putTransforms(pairWithRestrictionId, pairWithRestriction.build());
                String splitAndSizeId = SplittableParDoExpander.generateUniqueId(transformId + "/SplitAndSize", arg_0 -> ((RunnerApi.ComponentsOrBuilder)existingComponents).containsTransforms(arg_0));
                RunnerApi.PTransform.Builder splitAndSize = RunnerApi.PTransform.newBuilder();
                splitAndSize.putInputs(mainInputName, pairWithRestrictionOutId);
                splitAndSize.putAllInputs(sideInputs);
                splitAndSize.putOutputs("out", splitAndSizeOutId);
                splitAndSize.setUniqueName(SplittableParDoExpander.generateUniquePCollectonName(splittableParDo.getUniqueName() + "/SplitAndSize", existingComponents));
                splitAndSize.setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn("beam:transform:sdf_split_and_size_restrictions:v1").setPayload(splittableParDo.getSpec().getPayload()));
                splitAndSize.setEnvironmentId(splittableParDo.getEnvironmentId());
                rval.getComponentsBuilder().putTransforms(splitAndSizeId, splitAndSize.build());
                RunnerApi.PTransform.Builder newCompositeRoot = splittableParDo.toBuilder().clearSpec().addAllSubtransforms(Arrays.asList(pairWithRestrictionId, splitAndSizeId));
                String processSizedElementsAndRestrictionsId = SplittableParDoExpander.generateUniqueId(transformId + "/ProcessSizedElementsAndRestrictions", arg_0 -> ((RunnerApi.ComponentsOrBuilder)existingComponents).containsTransforms(arg_0));
                String processSizedElementsInputPCollectionId = splitAndSizeOutId;
                if (this.isDrain()) {
                    String truncateAndSizeCoderId = SplittableParDoExpander.generateUniqueId(mainInputPCollection.getCoderId() + "/TruncateAndSize", arg_0 -> ((RunnerApi.ComponentsOrBuilder)existingComponents).containsCoders(arg_0));
                    rval.getComponentsBuilder().putCoders(truncateAndSizeCoderId, ModelCoders.kvCoder(splitAndSizeOutCoderId, SplittableParDoExpander.getOrAddDoubleCoder(existingComponents, rval)));
                    String truncateAndSizeOutId = SplittableParDoExpander.generateUniqueId(mainInputPCollectionId + "/TruncateAndSize", arg_0 -> ((RunnerApi.ComponentsOrBuilder)existingComponents).containsPcollections(arg_0));
                    rval.getComponentsBuilder().putPcollections(truncateAndSizeOutId, RunnerApi.PCollection.newBuilder().setCoderId(truncateAndSizeCoderId).setIsBounded(mainInputPCollection.getIsBounded()).setWindowingStrategyId(mainInputPCollection.getWindowingStrategyId()).setUniqueName(SplittableParDoExpander.generateUniquePCollectonName(mainInputPCollection.getUniqueName() + "/TruncateAndSize", existingComponents)).build());
                    String truncateAndSizeId = SplittableParDoExpander.generateUniqueId(transformId + "/TruncateAndSize", arg_0 -> ((RunnerApi.ComponentsOrBuilder)existingComponents).containsTransforms(arg_0));
                    RunnerApi.PTransform.Builder truncateAndSize = RunnerApi.PTransform.newBuilder();
                    truncateAndSize.putInputs(mainInputName, splitAndSizeOutId);
                    truncateAndSize.putAllInputs(sideInputs);
                    truncateAndSize.putOutputs("out", truncateAndSizeOutId);
                    truncateAndSize.setUniqueName(SplittableParDoExpander.generateUniquePCollectonName(splittableParDo.getUniqueName() + "/TruncateAndSize", existingComponents));
                    truncateAndSize.setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn("beam:transform:sdf_truncate_sized_restrictions:v1").setPayload(splittableParDo.getSpec().getPayload()));
                    truncateAndSize.setEnvironmentId(splittableParDo.getEnvironmentId());
                    rval.getComponentsBuilder().putTransforms(truncateAndSizeId, truncateAndSize.build());
                    newCompositeRoot.addSubtransforms(truncateAndSizeId);
                    processSizedElementsInputPCollectionId = truncateAndSizeOutId;
                }
                RunnerApi.PTransform.Builder processSizedElementsAndRestrictions = RunnerApi.PTransform.newBuilder();
                processSizedElementsAndRestrictions.putInputs(mainInputName, processSizedElementsInputPCollectionId);
                processSizedElementsAndRestrictions.putAllInputs(sideInputs);
                processSizedElementsAndRestrictions.putAllOutputs(splittableParDo.getOutputsMap());
                processSizedElementsAndRestrictions.setUniqueName(SplittableParDoExpander.generateUniquePCollectonName(splittableParDo.getUniqueName() + "/ProcessSizedElementsAndRestrictions", existingComponents));
                processSizedElementsAndRestrictions.setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn("beam:transform:sdf_process_sized_element_and_restrictions:v1").setPayload(splittableParDo.getSpec().getPayload()));
                processSizedElementsAndRestrictions.setEnvironmentId(splittableParDo.getEnvironmentId());
                rval.getComponentsBuilder().putTransforms(processSizedElementsAndRestrictionsId, processSizedElementsAndRestrictions.build());
                newCompositeRoot.addSubtransforms(processSizedElementsAndRestrictionsId);
                rval.setPtransform(newCompositeRoot);
                return rval.build();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to perform expansion for transform " + transformId, e);
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setDrain(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized SizedReplacement build();
        }
    }
}

