/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.FileSystem;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.OffsetBasedSource;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Verify;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileBasedSource<@UnknownKeyFor T>
extends OffsetBasedSource<T> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FileBasedSource.class);
    private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fileOrPatternSpec;
    private final @UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment emptyMatchTreatment;
    private @Nullable @UnknownKeyFor @Initialized MatchResult.Metadata singleFileMetadata;
    private final @UnknownKeyFor @NonNull @Initialized Mode mode;
    private final @UnknownKeyFor @NonNull @Initialized AtomicReference<@Nullable @UnknownKeyFor @Initialized Long> filesSizeBytes;

    protected FileBasedSource(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fileOrPatternSpec, @UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment emptyMatchTreatment, @UnknownKeyFor @NonNull @Initialized long minBundleSize) {
        super(0L, Long.MAX_VALUE, minBundleSize);
        this.mode = Mode.FILEPATTERN;
        this.emptyMatchTreatment = emptyMatchTreatment;
        this.fileOrPatternSpec = fileOrPatternSpec;
        this.filesSizeBytes = new AtomicReference();
    }

    protected FileBasedSource(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fileOrPatternSpec, @UnknownKeyFor @NonNull @Initialized long minBundleSize) {
        this(fileOrPatternSpec, EmptyMatchTreatment.DISALLOW, minBundleSize);
    }

    protected FileBasedSource(@UnknownKeyFor @NonNull @Initialized MatchResult.Metadata fileMetadata, @UnknownKeyFor @NonNull @Initialized long minBundleSize, @UnknownKeyFor @NonNull @Initialized long startOffset, @UnknownKeyFor @NonNull @Initialized long endOffset) {
        super(startOffset, endOffset, minBundleSize);
        this.mode = Mode.SINGLE_FILE_OR_SUBRANGE;
        this.singleFileMetadata = (MatchResult.Metadata)Preconditions.checkNotNull((Object)fileMetadata, (Object)"fileMetadata");
        this.fileOrPatternSpec = ValueProvider.StaticValueProvider.of(fileMetadata.resourceId().toString());
        this.filesSizeBytes = new AtomicReference();
        this.emptyMatchTreatment = EmptyMatchTreatment.DISALLOW;
    }

    public final @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata getSingleFileMetadata() {
        Preconditions.checkArgument((this.mode == Mode.SINGLE_FILE_OR_SUBRANGE ? 1 : 0) != 0, (String)"This function should only be called for a single file, not %s", (Object)this);
        Preconditions.checkState((this.singleFileMetadata != null ? 1 : 0) != 0, (String)"It should not be possible to construct a %s in mode %s with null metadata: %s", FileBasedSource.class, (Object)((Object)this.mode), (Object)this);
        return this.singleFileMetadata;
    }

    public final @UnknownKeyFor @NonNull @Initialized String getFileOrPatternSpec() {
        return this.fileOrPatternSpec.get();
    }

    public final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getFileOrPatternSpecProvider() {
        return this.fileOrPatternSpec;
    }

    public final @UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment getEmptyMatchTreatment() {
        return this.emptyMatchTreatment;
    }

    public final @UnknownKeyFor @NonNull @Initialized Mode getMode() {
        return this.mode;
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized FileBasedSource<T> createSourceForSubrange(@UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end) {
        Preconditions.checkArgument((this.mode != Mode.FILEPATTERN ? 1 : 0) != 0, (Object)"Cannot split a file pattern based source based on positions");
        Preconditions.checkArgument((start >= this.getStartOffset() ? 1 : 0) != 0, (String)"Start offset value %s of the subrange cannot be smaller than the start offset value %s of the parent source", (long)start, (long)this.getStartOffset());
        Preconditions.checkArgument((end <= this.getEndOffset() ? 1 : 0) != 0, (String)"End offset value %s of the subrange cannot be larger than the end offset value %s", (long)end, (long)this.getEndOffset());
        Preconditions.checkState((this.singleFileMetadata != null ? 1 : 0) != 0, (String)"A single file source should not have null metadata: %s", (Object)this);
        FileBasedSource<T> source = this.createForSubrangeOfFile(this.singleFileMetadata, start, end);
        if (start > 0L || end != Long.MAX_VALUE) {
            Preconditions.checkArgument((source.getMode() == Mode.SINGLE_FILE_OR_SUBRANGE ? 1 : 0) != 0, (String)"Source created for the range [%s,%s) must be a subrange source", (long)start, (long)end);
        }
        return source;
    }

    protected abstract @UnknownKeyFor @NonNull @Initialized FileBasedSource<T> createForSubrangeOfFile(@UnknownKeyFor @NonNull @Initialized MatchResult.Metadata var1, @UnknownKeyFor @NonNull @Initialized long var2, @UnknownKeyFor @NonNull @Initialized long var4);

    protected abstract @UnknownKeyFor @NonNull @Initialized FileBasedReader<T> createSingleFileReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions var1);

    @Override
    public final @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String fileOrPattern = this.fileOrPatternSpec.get();
        if (this.mode == Mode.FILEPATTERN) {
            Long maybeNumBytes = this.filesSizeBytes.get();
            if (maybeNumBytes != null) {
                return maybeNumBytes;
            }
            long totalSize = 0L;
            List<MatchResult.Metadata> allMatches = FileSystems.match(fileOrPattern, this.emptyMatchTreatment).metadata();
            for (MatchResult.Metadata metadata : allMatches) {
                totalSize += metadata.sizeBytes();
            }
            LOG.info("Filepattern {} matched {} files with total size {}", new Object[]{fileOrPattern, allMatches.size(), totalSize});
            this.filesSizeBytes.compareAndSet(null, totalSize);
            return totalSize;
        }
        long start = this.getStartOffset();
        long end = Math.min(this.getEndOffset(), this.getMaxEndOffset(options));
        return end - start;
    }

    @Override
    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        if (this.mode == Mode.FILEPATTERN) {
            builder.add(DisplayData.item("filePattern", this.getFileOrPatternSpecProvider()).withLabel("File Pattern"));
        }
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized FileBasedSource<T>> split(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        String fileOrPattern = this.fileOrPatternSpec.get();
        if (this.mode == Mode.FILEPATTERN) {
            long startTime = System.currentTimeMillis();
            List<MatchResult.Metadata> expandedFiles = FileSystems.match(fileOrPattern, this.emptyMatchTreatment).metadata();
            ArrayList<FileBasedSource<T>> splitResults = new ArrayList<FileBasedSource<T>>(expandedFiles.size());
            for (MatchResult.Metadata metadata : expandedFiles) {
                FileBasedSource<T> split = this.createForSubrangeOfFile(metadata, 0L, metadata.sizeBytes());
                Verify.verify((split.getMode() == Mode.SINGLE_FILE_OR_SUBRANGE ? 1 : 0) != 0, (String)"%s.createForSubrangeOfFile must return a source in mode %s", split, (Object)((Object)Mode.SINGLE_FILE_OR_SUBRANGE));
                splitResults.addAll(split.split(desiredBundleSizeBytes, options));
            }
            LOG.info("Splitting filepattern {} into bundles of size {} took {} ms and produced {} files and {} bundles", new Object[]{fileOrPattern, desiredBundleSizeBytes, System.currentTimeMillis() - startTime, expandedFiles.size(), splitResults.size()});
            FileBasedSource.reportSourceLineage(expandedFiles);
            return splitResults;
        }
        if (this.isSplittable()) {
            List splits = super.split(desiredBundleSizeBytes, options);
            return splits;
        }
        LOG.debug("The source for file {} is not split into sub-range based sources since the file is not seekable", (Object)fileOrPattern);
        return ImmutableList.of((Object)this);
    }

    private static void reportSourceLineage(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MatchResult.Metadata> expandedFiles) {
        if (expandedFiles.size() <= 100) {
            for (MatchResult.Metadata metadata : expandedFiles) {
                FileSystems.reportSourceLineage(metadata.resourceId());
            }
        } else {
            HashSet<ResourceId> uniqueDirs = new HashSet<ResourceId>();
            for (MatchResult.Metadata metadata : expandedFiles) {
                ResourceId dir = metadata.resourceId().getCurrentDirectory();
                uniqueDirs.add(dir);
                if (uniqueDirs.size() <= 100) continue;
                FileSystems.reportSourceLineage(dir, FileSystem.LineageLevel.TOP_LEVEL);
                return;
            }
            for (ResourceId uniqueDir : uniqueDirs) {
                FileSystems.reportSourceLineage(uniqueDir);
            }
        }
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean isSplittable() throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.mode == Mode.FILEPATTERN) {
            return true;
        }
        return this.getSingleFileMetadata().isReadSeekEfficient();
    }

    @Override
    public final  @UnknownKeyFor @NonNull @Initialized BoundedSource.BoundedReader<T> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.validate();
        String fileOrPattern = this.fileOrPatternSpec.get();
        if (this.mode == Mode.FILEPATTERN) {
            long startTime = System.currentTimeMillis();
            List<MatchResult.Metadata> fileMetadata = FileSystems.match(fileOrPattern, this.emptyMatchTreatment).metadata();
            LOG.info("Matched {} files for pattern {}", (Object)fileMetadata.size(), (Object)fileOrPattern);
            ArrayList fileReaders = new ArrayList();
            for (MatchResult.Metadata metadata : fileMetadata) {
                long endOffset = metadata.sizeBytes();
                fileReaders.add(this.createForSubrangeOfFile(metadata, 0L, endOffset).createSingleFileReader(options));
            }
            LOG.debug("Creating a reader for file pattern {} took {} ms", (Object)fileOrPattern, (Object)(System.currentTimeMillis() - startTime));
            if (fileReaders.size() == 1) {
                return (BoundedSource.BoundedReader)fileReaders.get(0);
            }
            return new FilePatternReader(this, fileReaders);
        }
        return this.createSingleFileReader(options);
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        switch (this.mode) {
            case FILEPATTERN: {
                return this.fileOrPatternSpec.toString();
            }
            case SINGLE_FILE_OR_SUBRANGE: {
                return this.fileOrPatternSpec + " range " + super.toString();
            }
        }
        throw new IllegalStateException("Unexpected mode: " + (Object)((Object)this.mode));
    }

    @Override
    public void validate() {
        super.validate();
        switch (this.mode) {
            case FILEPATTERN: {
                Preconditions.checkArgument((this.getStartOffset() == 0L ? 1 : 0) != 0, (String)"FileBasedSource is based on a file pattern or a full single file but the starting offset proposed %s is not zero", (long)this.getStartOffset());
                Preconditions.checkArgument((this.getEndOffset() == Long.MAX_VALUE ? 1 : 0) != 0, (String)"FileBasedSource is based on a file pattern or a full single file but the ending offset proposed %s is not Long.MAX_VALUE", (long)this.getEndOffset());
                break;
            }
            case SINGLE_FILE_OR_SUBRANGE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown mode: " + (Object)((Object)this.mode));
            }
        }
    }

    @Override
    public final @UnknownKeyFor @NonNull @Initialized long getMaxEndOffset(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkArgument((this.mode != Mode.FILEPATTERN ? 1 : 0) != 0, (Object)"Cannot determine the exact end offset of a file pattern");
        MatchResult.Metadata metadata = this.getSingleFileMetadata();
        return metadata.sizeBytes();
    }

    private class FilePatternReader
    extends BoundedSource.BoundedReader<T> {
        private final @UnknownKeyFor @NonNull @Initialized FileBasedSource<T> source;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FileBasedReader<T>> fileReaders;
        final @UnknownKeyFor @NonNull @Initialized ListIterator<@UnknownKeyFor @NonNull @Initialized FileBasedReader<T>> fileReadersIterator;
        @Nullable @UnknownKeyFor @Initialized FileBasedReader<T> currentReader = null;

        public FilePatternReader(@UnknownKeyFor @NonNull @Initialized FileBasedSource<@UnknownKeyFor @NonNull @Initialized T> source, List<FileBasedReader<T>> fileReaders) {
            this.source = source;
            this.fileReaders = fileReaders;
            this.fileReadersIterator = fileReaders.listIterator();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
            return this.startNextNonemptyReader();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
            Preconditions.checkState((this.currentReader != null ? 1 : 0) != 0, (Object)"Call start() before advance()");
            if (this.currentReader.advance()) {
                return true;
            }
            return this.startNextNonemptyReader();
        }

        private @UnknownKeyFor @NonNull @Initialized boolean startNextNonemptyReader() throws @UnknownKeyFor @NonNull @Initialized IOException {
            while (this.fileReadersIterator.hasNext()) {
                this.currentReader = this.fileReadersIterator.next();
                if (this.currentReader.start()) {
                    return true;
                }
                this.currentReader.close();
            }
            return false;
        }

        @Override
        public T getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            return this.currentReader.getCurrent();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            return this.currentReader.getCurrentTimestamp();
        }

        @Override
        public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.currentReader != null) {
                this.currentReader.close();
            }
            while (this.fileReadersIterator.hasNext()) {
                this.fileReadersIterator.next().close();
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized FileBasedSource<T> getCurrentSource() {
            return this.source;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized FileBasedSource<T> splitAtFraction(@UnknownKeyFor @NonNull @Initialized double fraction) {
            LOG.debug("Dynamic splitting of FilePatternReader is unsupported.");
            return null;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Double getFractionConsumed() {
            int numReaders;
            if (this.currentReader == null) {
                return 0.0;
            }
            if (this.fileReaders.isEmpty()) {
                return 1.0;
            }
            int index = this.fileReadersIterator.previousIndex();
            if (index == (numReaders = this.fileReaders.size())) {
                return 1.0;
            }
            double before = 1.0 * (double)index / (double)numReaders;
            double after = 1.0 * (double)(index + 1) / (double)numReaders;
            Double fractionOfCurrentReader = this.currentReader.getFractionConsumed();
            if (fractionOfCurrentReader == null) {
                return before;
            }
            return before + fractionOfCurrentReader * (after - before);
        }
    }

    public static abstract class FileBasedReader<@UnknownKeyFor T>
    extends OffsetBasedSource.OffsetBasedReader<T> {
        private @Nullable @UnknownKeyFor @Initialized ReadableByteChannel channel = null;

        public FileBasedReader(@UnknownKeyFor @NonNull @Initialized FileBasedSource<T> source) {
            super(source);
            Preconditions.checkArgument((source.getMode() != Mode.FILEPATTERN ? 1 : 0) != 0, (Object)"FileBasedReader does not support reading file patterns");
        }

        @Override
        public synchronized @UnknownKeyFor @NonNull @Initialized FileBasedSource<T> getCurrentSource() {
            return (FileBasedSource)super.getCurrentSource();
        }

        @Override
        protected final @UnknownKeyFor @NonNull @Initialized boolean startImpl() throws @UnknownKeyFor @NonNull @Initialized IOException {
            OffsetBasedSource source = this.getCurrentSource();
            ResourceId resourceId = ((FileBasedSource)source).getSingleFileMetadata().resourceId();
            try {
                this.channel = FileSystems.open(resourceId);
                if (this.channel instanceof SeekableByteChannel) {
                    SeekableByteChannel seekChannel = (SeekableByteChannel)this.channel;
                    seekChannel.position(source.getStartOffset());
                } else {
                    Preconditions.checkArgument((((FileBasedSource)source).mode != Mode.SINGLE_FILE_OR_SUBRANGE ? 1 : 0) != 0, (Object)"Subrange-based sources must only be defined for file types that support seekable  read channels");
                    Preconditions.checkArgument((source.getStartOffset() == 0L ? 1 : 0) != 0, (String)"Start offset %s is not zero but channel for reading the file is not seekable.", (long)source.getStartOffset());
                }
                this.startReading(this.channel);
            }
            catch (IOException e) {
                LOG.error("Failed to process {}, which could be corrupted or have a wrong format.", (Object)resourceId);
                throw new IOException(e);
            }
            return this.advanceImpl();
        }

        @Override
        protected final @UnknownKeyFor @NonNull @Initialized boolean advanceImpl() throws @UnknownKeyFor @NonNull @Initialized IOException {
            return this.readNextRecord();
        }

        @Override
        public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
            if (this.channel != null) {
                this.channel.close();
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean allowsDynamicSplitting() {
            try {
                return ((FileBasedSource)this.getCurrentSource()).isSplittable();
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Error determining if %s allows dynamic splitting", this), e);
            }
        }

        protected abstract void startReading(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel var1) throws @UnknownKeyFor @NonNull @Initialized IOException;

        protected abstract @UnknownKeyFor @NonNull @Initialized boolean readNextRecord() throws @UnknownKeyFor @NonNull @Initialized IOException;
    }

    public static enum Mode {
        FILEPATTERN,
        SINGLE_FILE_OR_SUBRANGE;

    }
}

