/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import java.util.HashMap;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;

public class TypeHierarchy
implements Serializable {
    private HashMap map = new HashMap(100);
    public static final int SAME_TYPE = 0;
    public static final int SUBSUMES = 1;
    public static final int SUBSUMED_BY = 2;
    public static final int OVERLAPS = 3;
    public static final int DISJOINT = 4;

    public boolean isSubType(ItemType itemType, ItemType itemType2) {
        int n = this.relationship(itemType, itemType2);
        return n == 0 || n == 2;
    }

    public int relationship(ItemType itemType, ItemType itemType2) {
        Integer n;
        if (itemType == null) {
            throw new NullPointerException();
        }
        if (itemType.equals(itemType2)) {
            return 0;
        }
        HashMap<ItemType, Integer> hashMap = (HashMap<ItemType, Integer>)this.map.get(itemType);
        if (hashMap == null) {
            hashMap = new HashMap<ItemType, Integer>(5);
            this.map.put(itemType, hashMap);
        }
        if ((n = (Integer)hashMap.get(itemType2)) == null) {
            int n2 = this.computeRelationship(itemType, itemType2);
            hashMap.put(itemType2, new Integer(n2));
            return n2;
        }
        return n;
    }

    private int computeRelationship(ItemType itemType, ItemType itemType2) {
        int n;
        int n2;
        if (itemType == itemType2) {
            return 0;
        }
        if (itemType instanceof AnyItemType) {
            if (itemType2 instanceof AnyItemType) {
                return 0;
            }
            return 1;
        }
        if (itemType2 instanceof AnyItemType) {
            return 2;
        }
        if (itemType instanceof AtomicType) {
            if (itemType2 instanceof NodeTest) {
                return 4;
            }
            if (((AtomicType)itemType).getFingerprint() == ((AtomicType)itemType2).getFingerprint()) {
                return 0;
            }
            ItemType itemType3 = itemType2;
            while (itemType3 instanceof AtomicType) {
                if (((AtomicType)itemType).getFingerprint() == ((AtomicType)itemType3).getFingerprint()) {
                    return 1;
                }
                itemType3 = itemType3.getSuperType(this);
            }
            itemType3 = itemType;
            while (itemType3 instanceof AtomicType) {
                if (((AtomicType)itemType3).getFingerprint() == ((AtomicType)itemType2).getFingerprint()) {
                    return 2;
                }
                itemType3 = itemType3.getSuperType(this);
            }
            return 4;
        }
        if (itemType2 instanceof AtomicType) {
            return 4;
        }
        if (itemType instanceof AnyNodeTest) {
            if (itemType2 instanceof AnyNodeTest) {
                return 0;
            }
            return 1;
        }
        if (itemType2 instanceof AnyNodeTest) {
            return 2;
        }
        if (itemType instanceof NoNodeTest) {
            return 4;
        }
        if (itemType2 instanceof NoNodeTest) {
            return 4;
        }
        int n3 = ((NodeTest)itemType).getNodeKindMask();
        if ((n3 & (n2 = ((NodeTest)itemType2).getNodeKindMask())) == 0) {
            return 4;
        }
        int n4 = n3 == n2 ? 0 : ((n3 & n2) == n3 ? 2 : ((n3 & n2) == n2 ? 1 : 3));
        IntHashSet intHashSet = ((NodeTest)itemType).getRequiredNodeNames();
        IntHashSet intHashSet2 = ((NodeTest)itemType2).getRequiredNodeNames();
        int n5 = intHashSet == null ? (intHashSet2 == null ? 0 : 1) : (intHashSet2 == null ? 2 : (intHashSet.containsAll(intHashSet2) ? (intHashSet.size() == intHashSet2.size() ? 0 : 1) : (intHashSet2.containsAll(intHashSet) ? 2 : (intHashSet.containsSome(intHashSet2) ? 3 : 4))));
        if (itemType instanceof DocumentNodeTest) {
            n = itemType2 instanceof DocumentNodeTest ? this.relationship(((DocumentNodeTest)itemType).getElementTest(), ((DocumentNodeTest)itemType2).getElementTest()) : 2;
        } else if (itemType2 instanceof DocumentNodeTest) {
            n = 1;
        } else {
            SchemaType schemaType = ((NodeTest)itemType).getContentType();
            SchemaType schemaType2 = ((NodeTest)itemType2).getContentType();
            n = Type.schemaTypeRelationship(schemaType, schemaType2);
        }
        if (n4 == 0 && n5 == 0 && n == 0) {
            return 0;
        }
        if (!(n4 != 0 && n4 != 1 || n5 != 0 && n5 != 1 || n != 0 && n != 1)) {
            return 1;
        }
        if (!(n4 != 0 && n4 != 2 || n5 != 0 && n5 != 2 || n != 0 && n != 2)) {
            return 2;
        }
        if (n4 == 4 || n5 == 4 || n == 4) {
            return 4;
        }
        return 3;
    }
}

