/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.cypherbuilder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.neo4j.core.data.GraphPropertyDataType;
import org.apache.hop.neo4j.model.GraphPropertyType;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.neo4j.shared.NeoHopData;
import org.apache.hop.neo4j.transforms.cypherbuilder.CypherBuilderData;
import org.apache.hop.neo4j.transforms.cypherbuilder.CypherBuilderMeta;
import org.apache.hop.neo4j.transforms.cypherbuilder.Parameter;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.TransactionCallback;
import org.neo4j.driver.TransactionContext;
import org.neo4j.driver.Value;

public class CypherBuilder
extends BaseTransform<CypherBuilderMeta, CypherBuilderData> {
    public CypherBuilder(TransformMeta transformMeta, CypherBuilderMeta meta, CypherBuilderData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        String connectionName = this.resolve(((CypherBuilderMeta)this.meta).getConnectionName());
        try {
            ((CypherBuilderData)this.data).connection = (NeoConnection)this.metadataProvider.getSerializer(NeoConnection.class).load(connectionName);
            ((CypherBuilderData)this.data).driver = ((CypherBuilderData)this.data).connection.getDriver(this.getLogChannel(), (IVariables)this);
            ((CypherBuilderData)this.data).driver.verifyConnectivity();
            ((CypherBuilderData)this.data).session = ((CypherBuilderData)this.data).connection.getSession(this.getLogChannel(), ((CypherBuilderData)this.data).driver, (IVariables)this);
        }
        catch (Exception e) {
            this.setErrors(1L);
            this.logError("Error connecting to Neo4j", e);
            return false;
        }
        return super.init();
    }

    public void dispose() {
        try {
            if (((CypherBuilderData)this.data).session != null) {
                ((CypherBuilderData)this.data).session.close();
            }
            if (((CypherBuilderData)this.data).driver != null) {
                ((CypherBuilderData)this.data).driver.close();
            }
        }
        catch (Exception e) {
            this.logError("Error closing Neo4j connection", e);
        }
        super.dispose();
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            this.emptyRowParametersList();
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.prepareOnFirstRow(row);
        }
        ((CypherBuilderData)this.data).inputRowsList.add(row);
        HashMap<String, Object> rowParameters = new HashMap<String, Object>();
        for (int i = 0; i < ((CypherBuilderMeta)this.meta).getParameters().size(); ++i) {
            Parameter parameter = ((CypherBuilderMeta)this.meta).getParameters().get(i);
            int index = ((CypherBuilderData)this.data).parameterIndexes.get(i);
            IValueMeta valueMeta = this.getInputRowMeta().getValueMeta(index);
            Object valueData = row[index];
            GraphPropertyType propertyType = ((CypherBuilderData)this.data).parameterTypes.get(i);
            Object neoData = propertyType.convertFromHop(valueMeta, valueData);
            rowParameters.put(parameter.getName(), neoData);
        }
        ((CypherBuilderData)this.data).rowParametersList.add(rowParameters);
        if (((CypherBuilderData)this.data).rowParametersList.size() >= ((CypherBuilderData)this.data).batchSize) {
            this.emptyRowParametersList();
        }
        return true;
    }

    private void prepareOnFirstRow(Object[] row) throws HopException {
        ((CypherBuilderData)this.data).rowParametersList = new ArrayList<Map<String, Object>>();
        ((CypherBuilderData)this.data).inputRowsList = new ArrayList<Object[]>();
        ((CypherBuilderData)this.data).outputRowMeta = this.getInputRowMeta().clone();
        ((CypherBuilderMeta)this.meta).getFields(((CypherBuilderData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        ((CypherBuilderData)this.data).parameterIndexes = new ArrayList<Integer>();
        ((CypherBuilderData)this.data).parameterTypes = new ArrayList();
        for (Parameter parameter : ((CypherBuilderMeta)this.meta).getParameters()) {
            int index = this.getInputRowMeta().indexOfValue(parameter.getInputFieldName());
            if (index < 0) {
                throw new HopException("Input field of parameter " + parameter.getName() + " could not be found");
            }
            ((CypherBuilderData)this.data).parameterIndexes.add(index);
            GraphPropertyType propertyType = GraphPropertyType.parseCode(Const.NVL((String)parameter.getNeoType(), (String)""));
            if (propertyType == null) {
                throw new HopException("Unable to convert to unknown property type for parameter '" + parameter.getName() + "', input field: " + parameter.getInputFieldName());
            }
            ((CypherBuilderData)this.data).parameterTypes.add(propertyType);
        }
        ((CypherBuilderData)this.data).unwindAlias = this.resolve(((CypherBuilderMeta)this.meta).getUnwindAlias());
        ((CypherBuilderData)this.data).outputValues = new ArrayList<IValueMeta>();
        ((CypherBuilderData)this.data).outputIndexes = new ArrayList<Integer>();
        ((CypherBuilderData)this.data).neoTypes = new ArrayList<GraphPropertyDataType>();
        int startIndex = StringUtils.isEmpty((String)((CypherBuilderData)this.data).unwindAlias) ? this.getInputRowMeta().size() : 0;
        for (int index = startIndex; index < ((CypherBuilderData)this.data).outputRowMeta.size(); ++index) {
            ((CypherBuilderData)this.data).outputIndexes.add(index);
            IValueMeta valueMeta = ((CypherBuilderData)this.data).outputRowMeta.getValueMeta(index);
            ((CypherBuilderData)this.data).outputValues.add(valueMeta);
            GraphPropertyDataType neoType = GraphPropertyDataType.parseCode(valueMeta.getComments());
            ((CypherBuilderData)this.data).neoTypes.add(neoType);
        }
        ((CypherBuilderData)this.data).batchSize = Const.toInt((String)this.resolve(((CypherBuilderMeta)this.meta).getBatchSize()), (int)1);
        ((CypherBuilderData)this.data).cypher = ((CypherBuilderMeta)this.meta).getCypher((IVariables)this);
        ((CypherBuilderData)this.data).needsWriteTransaction = ((CypherBuilderMeta)this.meta).needsWriteTransaction();
        int retries = Const.toInt((String)this.resolve(((CypherBuilderMeta)this.meta).getRetries()), (int)0);
        if (retries < 0) {
            throw new HopException("The number of retries on an error should be larger than or equal to 0, not " + retries);
        }
        ((CypherBuilderData)this.data).attempts = 1 + retries;
    }

    private void emptyRowParametersList() throws HopException {
        if (((CypherBuilderData)this.data).rowParametersList.isEmpty()) {
            return;
        }
        try {
            for (int attempt = 0; attempt < ((CypherBuilderData)this.data).attempts; ++attempt) {
                try {
                    if (StringUtils.isEmpty((String)((CypherBuilderData)this.data).unwindAlias)) {
                        HopException hopException = ((CypherBuilderData)this.data).needsWriteTransaction ? (HopException)((Object)((CypherBuilderData)this.data).session.executeWrite((TransactionCallback)new RowsTransaction())) : (HopException)((Object)((CypherBuilderData)this.data).session.executeRead((TransactionCallback)new RowsTransaction()));
                        if (hopException != null) {
                            throw hopException;
                        }
                    } else {
                        Result result = ((CypherBuilderData)this.data).session.run(((CypherBuilderData)this.data).cypher, Map.of("rows", ((CypherBuilderData)this.data).rowParametersList));
                        this.putResultRows(new Object[0], result);
                    }
                    break;
                }
                catch (Exception e) {
                    if (attempt + 1 >= ((CypherBuilderData)this.data).attempts) {
                        throw new HopException("Failed transaction after " + ((CypherBuilderData)this.data).attempts + " attempts", (Throwable)e);
                    }
                    this.logDetailed("Retrying unwind after error: " + e.getMessage());
                    continue;
                }
            }
        }
        catch (Exception e) {
            throw new HopException("Error writing batch of rows to Neo4j", (Throwable)e);
        }
        finally {
            ((CypherBuilderData)this.data).rowParametersList.clear();
        }
    }

    private void putResultRows(Object[] inputRowData, Result result) throws HopException {
        while (result.hasNext()) {
            Record record = result.next();
            Object[] outputRow = RowDataUtil.createResizedCopy((Object[])inputRowData, (int)((CypherBuilderData)this.data).outputRowMeta.size());
            for (int i = 0; i < ((CypherBuilderData)this.data).outputIndexes.size(); ++i) {
                int index = ((CypherBuilderData)this.data).outputIndexes.get(i);
                IValueMeta valueMeta = ((CypherBuilderData)this.data).outputValues.get(i);
                GraphPropertyDataType neoType = ((CypherBuilderData)this.data).neoTypes.get(i);
                Value value = record.get(valueMeta.getName());
                outputRow[index] = NeoHopData.convertNeoToHopValue(valueMeta.getName(), value, neoType, valueMeta);
            }
            this.putRow(((CypherBuilderData)this.data).outputRowMeta, outputRow);
        }
    }

    public void batchComplete() throws HopException {
        if (!((CypherBuilderData)this.data).isBeamContext()) {
            this.emptyRowParametersList();
        }
    }

    public void finishBundle() throws HopException {
        this.emptyRowParametersList();
    }

    private final class RowsTransaction
    implements TransactionCallback<HopException> {
        public HopException execute(TransactionContext tx) {
            try {
                for (int i = 0; i < ((CypherBuilderData)((CypherBuilder)CypherBuilder.this).data).inputRowsList.size(); ++i) {
                    Object[] inputRow = ((CypherBuilderData)((CypherBuilder)CypherBuilder.this).data).inputRowsList.get(i);
                    Map<String, Object> rowParameters = ((CypherBuilderData)((CypherBuilder)CypherBuilder.this).data).rowParametersList.get(i);
                    Result result = tx.run(((CypherBuilderData)((CypherBuilder)CypherBuilder.this).data).cypher, rowParameters);
                    CypherBuilder.this.putResultRows(inputRow, result);
                }
                return null;
            }
            catch (Exception e) {
                return new HopException("Error writing to Neo4j", (Throwable)e);
            }
        }
    }
}

