/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClientConfig;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.BearerAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.CachedOauthTokenRetriever;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth.OauthTokenCache;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenValidator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpAccessTokenRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.LoginAccessTokenValidator;

public class OauthCredentialProvider
implements BearerAuthCredentialProvider {
    private CachedOauthTokenRetriever tokenRetriever;
    private String targetSchemaRegistry;
    private String targetIdentityPoolId;

    @Override
    public String alias() {
        return "OAUTHBEARER";
    }

    @Override
    public String getBearerToken(URL url) {
        return this.tokenRetriever.getToken();
    }

    @Override
    public String getTargetSchemaRegistry() {
        return this.targetSchemaRegistry;
    }

    @Override
    public String getTargetIdentityPoolId() {
        return this.targetIdentityPoolId;
    }

    public void configure(Map<String, ?> map) {
        ConfigurationUtils cu = new ConfigurationUtils(map);
        this.targetSchemaRegistry = cu.validateString("bearer.auth.logical.cluster", false);
        this.targetIdentityPoolId = cu.validateString("bearer.auth.identity.pool.id", false);
        this.tokenRetriever = new CachedOauthTokenRetriever();
        this.tokenRetriever.configure(this.getTokenRetriever(cu), this.getTokenValidator(map), this.getOauthTokenCache(map));
    }

    private OauthTokenCache getOauthTokenCache(Map<String, ?> map) {
        short cacheExpiryBufferSeconds = SchemaRegistryClientConfig.getBearerAuthCacheExpiryBufferSeconds(map);
        return new OauthTokenCache(cacheExpiryBufferSeconds);
    }

    private AccessTokenRetriever getTokenRetriever(ConfigurationUtils cu) {
        String clientId = cu.validateString("bearer.auth.client.id");
        String clientSecret = cu.validateString("bearer.auth.client.secret");
        String scope = cu.validateString("bearer.auth.scope", false);
        Long retryBackoffMs = 100L;
        Long retryBackoffMaxMs = 10000L;
        Integer loginConnectTimeoutMs = null;
        Integer loginReadTimeoutMs = null;
        JaasOptionsUtils jou = new JaasOptionsUtils(Collections.EMPTY_MAP);
        SSLSocketFactory sslSocketFactory = null;
        URL url = cu.validateUrl("bearer.auth.issuer.endpoint.url");
        if (jou.shouldCreateSSLSocketFactory(url)) {
            sslSocketFactory = jou.createSSLSocketFactory();
        }
        return new HttpAccessTokenRetriever(clientId, clientSecret, scope, sslSocketFactory, url.toString(), retryBackoffMs.longValue(), retryBackoffMaxMs.longValue(), loginConnectTimeoutMs, loginReadTimeoutMs);
    }

    private AccessTokenValidator getTokenValidator(Map<String, ?> configs) {
        String scopeClaimName = SchemaRegistryClientConfig.getBearerAuthScopeClaimName(configs);
        String subClaimName = SchemaRegistryClientConfig.getBearerAuthSubClaimName(configs);
        return new LoginAccessTokenValidator(scopeClaimName, subClaimName);
    }
}

