/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.Collection;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.failure.FailureEnricher;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.dispatcher.DispatcherOperationCaches;
import org.apache.flink.runtime.dispatcher.ExecutionGraphInfoStore;
import org.apache.flink.runtime.dispatcher.HistoryServerArchivist;
import org.apache.flink.runtime.dispatcher.JobManagerRunnerFactory;
import org.apache.flink.runtime.dispatcher.PartialDispatcherServicesWithJobPersistenceComponents;
import org.apache.flink.runtime.dispatcher.cleanup.CleanupRunnerFactory;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.jobmanager.JobGraphWriter;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.Preconditions;

public class DispatcherServices {
    private final Configuration configuration;
    private final HighAvailabilityServices highAvailabilityServices;
    private final GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever;
    private final BlobServer blobServer;
    private final HeartbeatServices heartbeatServices;
    private final JobManagerMetricGroup jobManagerMetricGroup;
    private final ExecutionGraphInfoStore executionGraphInfoStore;
    private final FatalErrorHandler fatalErrorHandler;
    private final HistoryServerArchivist historyServerArchivist;
    @Nullable
    private final String metricQueryServiceAddress;
    private final DispatcherOperationCaches operationCaches;
    private final JobGraphWriter jobGraphWriter;
    private final JobResultStore jobResultStore;
    private final JobManagerRunnerFactory jobManagerRunnerFactory;
    private final CleanupRunnerFactory cleanupRunnerFactory;
    private final Executor ioExecutor;
    private final Collection<FailureEnricher> failureEnrichers;

    DispatcherServices(Configuration configuration, HighAvailabilityServices highAvailabilityServices, GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever, BlobServer blobServer, HeartbeatServices heartbeatServices, ExecutionGraphInfoStore executionGraphInfoStore, FatalErrorHandler fatalErrorHandler, HistoryServerArchivist historyServerArchivist, @Nullable String metricQueryServiceAddress, DispatcherOperationCaches operationCaches, JobManagerMetricGroup jobManagerMetricGroup, JobGraphWriter jobGraphWriter, JobResultStore jobResultStore, JobManagerRunnerFactory jobManagerRunnerFactory, CleanupRunnerFactory cleanupRunnerFactory, Executor ioExecutor, Collection<FailureEnricher> failureEnrichers) {
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration, (String)"Configuration");
        this.highAvailabilityServices = (HighAvailabilityServices)Preconditions.checkNotNull((Object)highAvailabilityServices, (String)"HighAvailabilityServices");
        this.resourceManagerGatewayRetriever = (GatewayRetriever)Preconditions.checkNotNull(resourceManagerGatewayRetriever, (String)"ResourceManagerGatewayRetriever");
        this.blobServer = (BlobServer)Preconditions.checkNotNull((Object)blobServer, (String)"BlobServer");
        this.heartbeatServices = (HeartbeatServices)Preconditions.checkNotNull((Object)heartbeatServices, (String)"HeartBeatServices");
        this.executionGraphInfoStore = (ExecutionGraphInfoStore)Preconditions.checkNotNull((Object)executionGraphInfoStore, (String)"ExecutionGraphInfoStore");
        this.fatalErrorHandler = (FatalErrorHandler)Preconditions.checkNotNull((Object)fatalErrorHandler, (String)"FatalErrorHandler");
        this.historyServerArchivist = (HistoryServerArchivist)Preconditions.checkNotNull((Object)historyServerArchivist, (String)"HistoryServerArchivist");
        this.metricQueryServiceAddress = metricQueryServiceAddress;
        this.operationCaches = (DispatcherOperationCaches)Preconditions.checkNotNull((Object)operationCaches, (String)"OperationCaches");
        this.jobManagerMetricGroup = (JobManagerMetricGroup)Preconditions.checkNotNull((Object)jobManagerMetricGroup, (String)"JobManagerMetricGroup");
        this.jobGraphWriter = (JobGraphWriter)Preconditions.checkNotNull((Object)jobGraphWriter, (String)"JobGraphWriter");
        this.jobResultStore = (JobResultStore)Preconditions.checkNotNull((Object)jobResultStore, (String)"JobResultStore");
        this.jobManagerRunnerFactory = (JobManagerRunnerFactory)Preconditions.checkNotNull((Object)jobManagerRunnerFactory, (String)"JobManagerRunnerFactory");
        this.cleanupRunnerFactory = (CleanupRunnerFactory)Preconditions.checkNotNull((Object)cleanupRunnerFactory, (String)"CleanupRunnerFactory");
        this.ioExecutor = (Executor)Preconditions.checkNotNull((Object)ioExecutor, (String)"IOExecutor");
        this.failureEnrichers = (Collection)Preconditions.checkNotNull(failureEnrichers, (String)"FailureEnrichers");
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public HighAvailabilityServices getHighAvailabilityServices() {
        return this.highAvailabilityServices;
    }

    public GatewayRetriever<ResourceManagerGateway> getResourceManagerGatewayRetriever() {
        return this.resourceManagerGatewayRetriever;
    }

    public BlobServer getBlobServer() {
        return this.blobServer;
    }

    public HeartbeatServices getHeartbeatServices() {
        return this.heartbeatServices;
    }

    public JobManagerMetricGroup getJobManagerMetricGroup() {
        return this.jobManagerMetricGroup;
    }

    public ExecutionGraphInfoStore getArchivedExecutionGraphStore() {
        return this.executionGraphInfoStore;
    }

    public FatalErrorHandler getFatalErrorHandler() {
        return this.fatalErrorHandler;
    }

    public HistoryServerArchivist getHistoryServerArchivist() {
        return this.historyServerArchivist;
    }

    @Nullable
    public String getMetricQueryServiceAddress() {
        return this.metricQueryServiceAddress;
    }

    public DispatcherOperationCaches getOperationCaches() {
        return this.operationCaches;
    }

    public JobGraphWriter getJobGraphWriter() {
        return this.jobGraphWriter;
    }

    public JobResultStore getJobResultStore() {
        return this.jobResultStore;
    }

    JobManagerRunnerFactory getJobManagerRunnerFactory() {
        return this.jobManagerRunnerFactory;
    }

    CleanupRunnerFactory getCleanupRunnerFactory() {
        return this.cleanupRunnerFactory;
    }

    public Executor getIoExecutor() {
        return this.ioExecutor;
    }

    public Collection<FailureEnricher> getFailureEnrichers() {
        return this.failureEnrichers;
    }

    public static DispatcherServices from(PartialDispatcherServicesWithJobPersistenceComponents partialDispatcherServicesWithJobPersistenceComponents, JobManagerRunnerFactory jobManagerRunnerFactory, CleanupRunnerFactory cleanupRunnerFactory) {
        return new DispatcherServices(partialDispatcherServicesWithJobPersistenceComponents.getConfiguration(), partialDispatcherServicesWithJobPersistenceComponents.getHighAvailabilityServices(), partialDispatcherServicesWithJobPersistenceComponents.getResourceManagerGatewayRetriever(), partialDispatcherServicesWithJobPersistenceComponents.getBlobServer(), partialDispatcherServicesWithJobPersistenceComponents.getHeartbeatServices(), partialDispatcherServicesWithJobPersistenceComponents.getArchivedExecutionGraphStore(), partialDispatcherServicesWithJobPersistenceComponents.getFatalErrorHandler(), partialDispatcherServicesWithJobPersistenceComponents.getHistoryServerArchivist(), partialDispatcherServicesWithJobPersistenceComponents.getMetricQueryServiceAddress(), partialDispatcherServicesWithJobPersistenceComponents.getOperationCaches(), partialDispatcherServicesWithJobPersistenceComponents.getJobManagerMetricGroupFactory().create(), partialDispatcherServicesWithJobPersistenceComponents.getJobGraphWriter(), partialDispatcherServicesWithJobPersistenceComponents.getJobResultStore(), jobManagerRunnerFactory, cleanupRunnerFactory, partialDispatcherServicesWithJobPersistenceComponents.getIoExecutor(), partialDispatcherServicesWithJobPersistenceComponents.getFailureEnrichers());
    }
}

