/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getfilenames;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.getfilenames.FileItem;
import org.apache.hop.pipeline.transforms.getfilenames.FilterItem;
import org.apache.hop.pipeline.transforms.getfilenames.GetFileNames;
import org.apache.hop.pipeline.transforms.getfilenames.GetFileNamesData;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;

@Transform(id="GetFileNames", image="getfilenames.svg", name="i18n::GetFileNames.Name", description="i18n::GetFileNames.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::GetFileNamesMeta.keyword"}, documentationUrl="/pipeline/transforms/getfilenames.html")
public class GetFileNamesMeta
extends BaseTransformMeta<GetFileNames, GetFileNamesData> {
    private static final Class<?> PKG = GetFileNamesMeta.class;
    private static final String YES = "Y";
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    private FileInputList.FileTypeFilter fileTypeFilter;
    @HopMetadataProperty(key="file", injectionKeyDescription="GetFileNames.Injection.File.Label", injectionGroupKey="FILE", injectionGroupDescription="GetFileNames.Injection.Group.FileTab.Label", inlineListTags={"name", "filemask", "exclude_filemask", "file_required", "include_subfolders"})
    private List<FileItem> filesList = new ArrayList<FileItem>();
    @HopMetadataProperty(key="filter", injectionKeyDescription="GetFileNames.Injection.FilterItemType.Label")
    private List<FilterItem> filterItemList = new ArrayList<FilterItem>();
    @HopMetadataProperty(key="rownum", injectionKeyDescription="GetFileNames.Injection.InclRownum.Label")
    private boolean includeRowNumber;
    @HopMetadataProperty(key="rownum_field", injectionKeyDescription="GetFileNames.Injection.InclRownumField.Label")
    private String rowNumberField;
    @HopMetadataProperty(key="filename_Field", injectionKeyDescription="GetFileNames.Injection.FilenameField.Label")
    private String dynamicFilenameField;
    @HopMetadataProperty(key="wildcard_Field", injectionKeyDescription="GetFileNames.Injection.WildcardField.Label")
    private String dynamicWildcardField;
    @HopMetadataProperty(key="exclude_wildcard_Field", injectionKeyDescription="GetFileNames.Injection.ExcludeWildcardField.Label")
    private String dynamicExcludeWildcardField;
    @HopMetadataProperty(key="filefield", injectionKeyDescription="GetFileNames.Injection.FilenameInField.Label")
    private boolean fileField;
    @HopMetadataProperty(key="dynamic_include_subfolders", injectionKeyDescription="GetFileNames.Injection.IncludeSubFolder.Label")
    private boolean dynamicIncludeSubFolders;
    @HopMetadataProperty(key="isaddresult", injectionKeyDescription="GetFileNames.Injection.AddResult.Label")
    private boolean addResultFile;
    @HopMetadataProperty(key="limit", injectionKeyDescription="GetFileNames.Injection.Limit.Label")
    private long rowLimit;
    @HopMetadataProperty(injectionKeyDescription="GetFileNames.Injection.DoNotFailIfNoFile.Label")
    private boolean doNotFailIfNoFile;
    @HopMetadataProperty(injectionKeyDescription="GetFileNames.Injection.RaiseAnExceptionIfNoFiles.Label")
    private boolean raiseAnExceptionIfNoFile;

    public String getRequiredFilesDesc(String tt) {
        if (tt == null) {
            return RequiredFilesDesc[0];
        }
        if (tt.equals(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public Object clone() {
        return (GetFileNamesMeta)((Object)super.clone());
    }

    public void setDefault() {
        this.doNotFailIfNoFile = false;
        this.filterItemList.add(new FilterItem(FileInputList.FileTypeFilter.FILES_AND_FOLDERS.toString()));
        this.addResultFile = true;
        this.fileField = false;
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.dynamicFilenameField = "";
        this.dynamicWildcardField = "";
        this.dynamicIncludeSubFolders = false;
        this.dynamicExcludeWildcardField = "";
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaString filename = new ValueMetaString("filename");
        filename.setLength(500);
        filename.setPrecision(-1);
        filename.setOrigin(name);
        row.addValueMeta((IValueMeta)filename);
        ValueMetaString shortFilename = new ValueMetaString("short_filename");
        shortFilename.setLength(500);
        shortFilename.setPrecision(-1);
        shortFilename.setOrigin(name);
        row.addValueMeta((IValueMeta)shortFilename);
        ValueMetaString path = new ValueMetaString("path");
        path.setLength(500);
        path.setPrecision(-1);
        path.setOrigin(name);
        row.addValueMeta((IValueMeta)path);
        ValueMetaString type = new ValueMetaString("type");
        type.setLength(500);
        type.setPrecision(-1);
        type.setOrigin(name);
        row.addValueMeta((IValueMeta)type);
        ValueMetaBoolean exists = new ValueMetaBoolean("exists");
        exists.setOrigin(name);
        row.addValueMeta((IValueMeta)exists);
        ValueMetaBoolean ishidden = new ValueMetaBoolean("ishidden");
        ishidden.setOrigin(name);
        row.addValueMeta((IValueMeta)ishidden);
        ValueMetaBoolean isreadable = new ValueMetaBoolean("isreadable");
        isreadable.setOrigin(name);
        row.addValueMeta((IValueMeta)isreadable);
        ValueMetaBoolean iswriteable = new ValueMetaBoolean("iswriteable");
        iswriteable.setOrigin(name);
        row.addValueMeta((IValueMeta)iswriteable);
        ValueMetaDate lastmodifiedtime = new ValueMetaDate("lastmodifiedtime");
        lastmodifiedtime.setOrigin(name);
        row.addValueMeta((IValueMeta)lastmodifiedtime);
        ValueMetaInteger size = new ValueMetaInteger("size");
        size.setOrigin(name);
        row.addValueMeta((IValueMeta)size);
        ValueMetaString extension = new ValueMetaString("extension");
        extension.setOrigin(name);
        row.addValueMeta((IValueMeta)extension);
        ValueMetaString uri = new ValueMetaString("uri");
        uri.setOrigin(name);
        row.addValueMeta((IValueMeta)uri);
        ValueMetaString rooturi = new ValueMetaString("rooturi");
        rooturi.setOrigin(name);
        row.addValueMeta((IValueMeta)rooturi);
        if (this.includeRowNumber) {
            ValueMetaInteger v = new ValueMetaInteger(variables.resolve(this.rowNumberField));
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    private FileInputList.FileTypeFilter[] buildFileTypeFiltersArray() {
        FileInputList.FileTypeFilter[] filters = new FileInputList.FileTypeFilter[this.filesList.size()];
        FileInputList.FileTypeFilter elementTypeToGet = FileInputList.FileTypeFilter.getByName((String)this.getFilterItemList().get(0).getFileTypeFilterSelection());
        for (int i = 0; i < this.filesList.size(); ++i) {
            filters[i] = elementTypeToGet;
        }
        return filters;
    }

    public String[] getFilePaths(IVariables variables) {
        return FileInputList.createFilePathList((IVariables)variables, (String[])this.buildFilenamesArray(), (String[])this.buildMasksArray(), (String[])this.buildExcludeMasksArray(), (String[])this.buildFileRequiredArray(), (boolean[])this.includeSubFolderBoolean(), (FileInputList.FileTypeFilter[])this.buildFileTypeFiltersArray());
    }

    public FileInputList getFileList(IVariables variables) {
        return FileInputList.createFileList((IVariables)variables, (String[])this.buildFilenamesArray(), (String[])this.buildMasksArray(), (String[])this.buildExcludeMasksArray(), (String[])this.buildFileRequiredArray(), (boolean[])this.includeSubFolderBoolean(), (FileInputList.FileTypeFilter[])this.buildFileTypeFiltersArray());
    }

    public FileInputList getDynamicFileList(IVariables variables, String[] filename, String[] fileMask, String[] excludeFilemask, String[] fileRequired, boolean[] includeSubFolders) {
        return FileInputList.createFileList((IVariables)variables, (String[])filename, (String[])fileMask, (String[])excludeFilemask, (String[])fileRequired, (boolean[])includeSubFolders, (FileInputList.FileTypeFilter[])this.buildFileTypeFiltersArray());
    }

    protected String[] buildFilenamesArray() {
        String[] fileNames = new String[this.filesList.size()];
        for (int i = 0; i < this.filesList.size(); ++i) {
            fileNames[i] = this.filesList.get(i).getFileName();
        }
        return fileNames;
    }

    protected String[] buildMasksArray() {
        String[] fileMasks = new String[this.filesList.size()];
        for (int i = 0; i < this.filesList.size(); ++i) {
            fileMasks[i] = this.filesList.get(i).getFileMask();
        }
        return fileMasks;
    }

    protected String[] buildExcludeMasksArray() {
        String[] excludeMasks = new String[this.filesList.size()];
        for (int i = 0; i < this.filesList.size(); ++i) {
            excludeMasks[i] = this.filesList.get(i).getExcludeFileMask();
        }
        return excludeMasks;
    }

    protected String[] buildFileRequiredArray() {
        String[] required = new String[this.filesList.size()];
        for (int i = 0; i < this.filesList.size(); ++i) {
            required[i] = this.filesList.get(i).getFileRequired();
        }
        return required;
    }

    private boolean[] includeSubFolderBoolean() {
        boolean[] includeSubFolderBoolean = new boolean[this.filesList.size()];
        for (int i = 0; i < this.filesList.size(); ++i) {
            includeSubFolderBoolean[i] = YES.equalsIgnoreCase(this.filesList.get(i).getIncludeSubFolders());
        }
        return includeSubFolderBoolean;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (this.fileField) {
            CheckResult cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.InputOk", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.InputErrorKo", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            cr = Utils.isEmpty((CharSequence)this.dynamicFilenameField) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.FolderFieldnameMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.FolderFieldnameOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.NoInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            FileInputList fileList = this.getFileList(variables);
            cr = fileList.nrOfFiles() == 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.ExpectedFilesError", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFileNamesMeta.CheckResult.ExpectedFilesOk", (String[])new String[]{"" + fileList.nrOfFiles()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, TransformMeta transformMeta) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        ResourceReference reference = new ResourceReference((IResourceHolder)transformMeta);
        references.add(reference);
        String[] files = this.getFilePaths(variables);
        if (files != null) {
            for (String file : files) {
                reference.getEntries().add(new ResourceEntry(file, ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            if (!this.fileField) {
                for (FileItem fi : this.filesList) {
                    FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(fi.getFileName()));
                    fi.setFileName(iResourceNaming.nameResource(fileObject, variables, Utils.isEmpty((CharSequence)fi.getFileMask())));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    @Generated
    public FileInputList.FileTypeFilter getFileTypeFilter() {
        return this.fileTypeFilter;
    }

    @Generated
    public List<FileItem> getFilesList() {
        return this.filesList;
    }

    @Generated
    public List<FilterItem> getFilterItemList() {
        return this.filterItemList;
    }

    @Generated
    public boolean isIncludeRowNumber() {
        return this.includeRowNumber;
    }

    @Generated
    public String getRowNumberField() {
        return this.rowNumberField;
    }

    @Generated
    public String getDynamicFilenameField() {
        return this.dynamicFilenameField;
    }

    @Generated
    public String getDynamicWildcardField() {
        return this.dynamicWildcardField;
    }

    @Generated
    public String getDynamicExcludeWildcardField() {
        return this.dynamicExcludeWildcardField;
    }

    @Generated
    public boolean isFileField() {
        return this.fileField;
    }

    @Generated
    public boolean isDynamicIncludeSubFolders() {
        return this.dynamicIncludeSubFolders;
    }

    @Generated
    public boolean isAddResultFile() {
        return this.addResultFile;
    }

    @Generated
    public long getRowLimit() {
        return this.rowLimit;
    }

    @Generated
    public boolean isDoNotFailIfNoFile() {
        return this.doNotFailIfNoFile;
    }

    @Generated
    public boolean isRaiseAnExceptionIfNoFile() {
        return this.raiseAnExceptionIfNoFile;
    }

    @Generated
    public void setFileTypeFilter(FileInputList.FileTypeFilter fileTypeFilter) {
        this.fileTypeFilter = fileTypeFilter;
    }

    @Generated
    public void setFilesList(List<FileItem> filesList) {
        this.filesList = filesList;
    }

    @Generated
    public void setFilterItemList(List<FilterItem> filterItemList) {
        this.filterItemList = filterItemList;
    }

    @Generated
    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    @Generated
    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    @Generated
    public void setDynamicFilenameField(String dynamicFilenameField) {
        this.dynamicFilenameField = dynamicFilenameField;
    }

    @Generated
    public void setDynamicWildcardField(String dynamicWildcardField) {
        this.dynamicWildcardField = dynamicWildcardField;
    }

    @Generated
    public void setDynamicExcludeWildcardField(String dynamicExcludeWildcardField) {
        this.dynamicExcludeWildcardField = dynamicExcludeWildcardField;
    }

    @Generated
    public void setFileField(boolean fileField) {
        this.fileField = fileField;
    }

    @Generated
    public void setDynamicIncludeSubFolders(boolean dynamicIncludeSubFolders) {
        this.dynamicIncludeSubFolders = dynamicIncludeSubFolders;
    }

    @Generated
    public void setAddResultFile(boolean addResultFile) {
        this.addResultFile = addResultFile;
    }

    @Generated
    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    @Generated
    public void setDoNotFailIfNoFile(boolean doNotFailIfNoFile) {
        this.doNotFailIfNoFile = doNotFailIfNoFile;
    }

    @Generated
    public void setRaiseAnExceptionIfNoFile(boolean raiseAnExceptionIfNoFile) {
        this.raiseAnExceptionIfNoFile = raiseAnExceptionIfNoFile;
    }
}

