/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.zipfile;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.FileDoesNotExistValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.engine.IWorkflowEngine;

@Action(id="ZIP_FILE", name="i18n::ActionZipFile.Name", description="i18n::ActionZipFile.Description", image="Zip.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionZipFile.keyword"}, documentationUrl="/workflow/actions/zipfile.html")
public class ActionZipFile
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionZipFile.class;
    @HopMetadataProperty(key="zipfilename")
    private String zipFilename = null;
    @HopMetadataProperty(key="compressionrate")
    private int compressionRate = 1;
    @HopMetadataProperty(key="ifzipfileexists")
    private int ifZipFileExists = 2;
    @HopMetadataProperty(key="afterzip")
    private int afterZip = 0;
    @HopMetadataProperty(key="wildcard")
    private String wildCard = null;
    @HopMetadataProperty(key="wildcardexclude")
    private String excludeWildCard = null;
    @HopMetadataProperty(key="sourcedirectory")
    private String sourceDirectory = null;
    @HopMetadataProperty(key="movetodirectory")
    private String moveToDirectory = null;
    @HopMetadataProperty(key="addfiletoresult")
    private boolean addFileToResult = false;
    @HopMetadataProperty(key="isfromprevious")
    private boolean fromPrevious = false;
    @HopMetadataProperty(key="createparentfolder")
    private boolean createParentFolder = false;
    @HopMetadataProperty(key="adddate")
    private boolean addDate = false;
    @HopMetadataProperty(key="addtime")
    private boolean addTime = false;
    @HopMetadataProperty(key="SpecifyFormat")
    private boolean specifyFormat = false;
    @HopMetadataProperty(key="date_time_format")
    private String dateTimeFormat = null;
    @HopMetadataProperty(key="createMoveToDirectory")
    private boolean createMoveToDirectory = false;
    @HopMetadataProperty(key="include_subfolders")
    private boolean includingSubFolders = true;
    @HopMetadataProperty(key="stored_source_path_depth")
    private String storedSourcePathDepth = "1";

    public ActionZipFile(String n) {
        super(n, "");
    }

    public ActionZipFile() {
        this("");
    }

    public Object clone() {
        ActionZipFile je = (ActionZipFile)super.clone();
        return je;
    }

    public boolean isEvaluation() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createParentFolder(String filename) {
        FileObject parentfolder = null;
        boolean result = false;
        try {
            parentfolder = HopVfs.getFileObject((String)filename, (IVariables)this.getVariables()).getParent();
            if (!parentfolder.exists()) {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionZipFile.CanNotFindFolder", (String[])new String[]{String.valueOf(parentfolder.getName())}));
                }
                parentfolder.createFolder();
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionZipFile.FolderCreated", (String[])new String[]{String.valueOf(parentfolder.getName())}));
                }
            } else if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionZipFile.FolderExists", (String[])new String[]{String.valueOf(parentfolder.getName())}));
            }
            result = true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.CanNotCreateFolder", (String[])new String[]{String.valueOf(parentfolder.getName())}), e);
        }
        finally {
            if (parentfolder != null) {
                try {
                    parentfolder.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public boolean processRowFile(IWorkflowEngine<WorkflowMeta> parentWorkflow, Result result, String realZipFilename, String realWildCard, String realExcludeWildcard, String realSourceDirectoryOrFile, String realMoveToDirectory, boolean createParentFolder) throws HopException {
        boolean successResult;
        block84: {
            boolean orginExist;
            String localSourceFilename;
            boolean fileExists = false;
            File tempFile = null;
            successResult = true;
            boolean renameOk = false;
            try (FileObject originFile = HopVfs.getFileObject((String)realSourceDirectoryOrFile, (IVariables)this.getVariables());){
                localSourceFilename = HopVfs.getFilename((FileObject)originFile);
                orginExist = originFile.exists();
            }
            catch (Exception e) {
                throw new HopException("Error finding source file or directory: " + realSourceDirectoryOrFile, (Throwable)e);
            }
            Object localrealZipfilename = realZipFilename;
            if (realZipFilename != null && orginExist) {
                try (FileObject fileObject = HopVfs.getFileObject((String)localrealZipfilename, (IVariables)this.getVariables());){
                    FileObject[] fileList;
                    Pattern excludePattern;
                    Pattern pattern;
                    localrealZipfilename = HopVfs.getFilename((FileObject)fileObject);
                    if (fileObject.exists()) {
                        fileExists = true;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionZipFile.Zip_FileExists1.Label", (String[])new String[0]) + (String)localrealZipfilename + BaseMessages.getString(PKG, (String)"ActionZipFile.Zip_FileExists2.Label", (String[])new String[0]));
                        }
                    }
                    if (createParentFolder) {
                        this.createParentFolder((String)localrealZipfilename);
                    }
                    if (this.ifZipFileExists == 3 && fileExists) {
                        successResult = false;
                        break block84;
                    }
                    if (this.ifZipFileExists == 2 && fileExists) {
                        if (this.addFileToResult) {
                            ResultFile resultFile = new ResultFile(0, fileObject, parentWorkflow.getWorkflowName(), this.toString());
                            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                        }
                        break block84;
                    }
                    if (this.afterZip == 2 && realMoveToDirectory == null) {
                        successResult = false;
                        this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.AfterZip_No_DestinationFolder_Defined.Label", (String[])new String[0]));
                        break block84;
                    }
                    FileObject sourceFileOrFolder = HopVfs.getFileObject((String)localSourceFilename, (IVariables)this.getVariables());
                    boolean isSourceDirectory = sourceFileOrFolder.getType().equals((Object)FileType.FOLDER);
                    if (isSourceDirectory) {
                        pattern = !Utils.isEmpty((CharSequence)realWildCard) ? Pattern.compile(realWildCard) : null;
                        excludePattern = !Utils.isEmpty((CharSequence)realExcludeWildcard) ? Pattern.compile(realExcludeWildcard) : null;
                        fileList = this.includingSubFolders ? sourceFileOrFolder.findFiles((FileSelector)new ZipJobEntryPatternFileSelector(pattern, excludePattern)) : sourceFileOrFolder.getChildren();
                    } else {
                        pattern = null;
                        excludePattern = null;
                        fileList = new FileObject[]{sourceFileOrFolder};
                    }
                    if (fileList.length == 0) {
                        successResult = false;
                        this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.Log.FolderIsEmpty", (String[])new String[]{localSourceFilename}));
                        break block84;
                    }
                    if (!this.checkContainsFile(localSourceFilename, fileList, isSourceDirectory)) {
                        successResult = false;
                        this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.Log.NoFilesInFolder", (String[])new String[]{localSourceFilename}));
                        break block84;
                    }
                    if (this.ifZipFileExists == 0 && fileExists) {
                        if (((String)localrealZipfilename).toLowerCase().endsWith(".zip")) {
                            localrealZipfilename = ((String)localrealZipfilename).substring(0, ((String)localrealZipfilename).length() - 4);
                        }
                        localrealZipfilename = (String)localrealZipfilename + "_" + StringUtil.getFormattedDateTimeNow((boolean)true) + ".zip";
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionZipFile.Zip_FileNameChange1.Label", (String[])new String[0]) + (String)localrealZipfilename + BaseMessages.getString(PKG, (String)"ActionZipFile.Zip_FileNameChange1.Label", (String[])new String[0]));
                        }
                    } else if (this.ifZipFileExists == 1 && fileExists) {
                        File fileZip = this.getFile((String)localrealZipfilename);
                        tempFile = File.createTempFile(fileZip.getName(), null);
                        if (!tempFile.delete()) {
                            throw new HopException("Unable to delete temporary file " + String.valueOf(tempFile));
                        }
                        renameOk = fileZip.renameTo(tempFile);
                        if (!renameOk) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.Cant_Rename_Temp1.Label", (String[])new String[0]) + fileZip.getAbsolutePath() + BaseMessages.getString(PKG, (String)"ActionZipFile.Cant_Rename_Temp2.Label", (String[])new String[0]) + tempFile.getAbsolutePath() + BaseMessages.getString(PKG, (String)"ActionZipFile.Cant_Rename_Temp3.Label", (String[])new String[0]));
                        }
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionZipFile.Zip_FileAppend1.Label", (String[])new String[0]) + (String)localrealZipfilename + BaseMessages.getString(PKG, (String)"ActionZipFile.Zip_FileAppend2.Label", (String[])new String[0]));
                        }
                    }
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionZipFile.Files_Found1.Label", (String[])new String[0]) + fileList.length + BaseMessages.getString(PKG, (String)"ActionZipFile.Files_Found2.Label", (String[])new String[0]) + localSourceFilename + BaseMessages.getString(PKG, (String)"ActionZipFile.Files_Found3.Label", (String[])new String[0]));
                    }
                    ArrayList<FileObject> zippedFiles = new ArrayList<FileObject>();
                    try (OutputStream dest = HopVfs.getOutputStream((String)localrealZipfilename, (boolean)false, (IVariables)this.getVariables());
                         BufferedOutputStream buff = new BufferedOutputStream(dest);
                         ZipOutputStream out = new ZipOutputStream(buff);){
                        HashSet<String> fileSet = new HashSet<String>();
                        if (renameOk) {
                            ActionZipFile.moveRenameZipArchive(tempFile, fileSet, out);
                        }
                        out.setMethod(8);
                        if (this.compressionRate == 0) {
                            out.setLevel(0);
                        } else if (this.compressionRate == 1) {
                            out.setLevel(-1);
                        }
                        if (this.compressionRate == 2) {
                            out.setLevel(9);
                        }
                        if (this.compressionRate == 3) {
                            out.setLevel(1);
                        }
                        int fileNum = 0;
                        for (int i = 0; i < fileList.length && !parentWorkflow.isStopped(); ++i) {
                            boolean getIt = true;
                            boolean getItexclude = false;
                            if (isSourceDirectory) {
                                String filename = this.includingSubFolders ? fileList[i].getName().getPath() : fileList[i].getName().getBaseName();
                                if (pattern != null) {
                                    Matcher matcher = pattern.matcher(filename);
                                    getIt = matcher.matches();
                                }
                                if (excludePattern != null) {
                                    Matcher excludeMatcher = excludePattern.matcher(filename);
                                    getItexclude = excludeMatcher.matches();
                                }
                            }
                            String targetFilename = HopVfs.getFilename((FileObject)fileList[i]);
                            if (sourceFileOrFolder.getType().equals((Object)FileType.FILE)) {
                                targetFilename = localSourceFilename;
                            }
                            try (FileObject file = HopVfs.getFileObject((String)targetFilename, (IVariables)this.getVariables());){
                                boolean isTargetDirectory;
                                boolean bl = isTargetDirectory = file.exists() && file.getType().equals((Object)FileType.FOLDER);
                                if (!getIt || getItexclude || isTargetDirectory || fileSet.contains(targetFilename)) continue;
                                if (this.isDebug()) {
                                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionZipFile.Add_FilesToZip1.Label", (String[])new String[0]) + String.valueOf(fileList[i]) + BaseMessages.getString(PKG, (String)"ActionZipFile.Add_FilesToZip2.Label", (String[])new String[0]) + localSourceFilename + BaseMessages.getString(PKG, (String)"ActionZipFile.Add_FilesToZip3.Label", (String[])new String[0]));
                                }
                                this.addFileToZip(file, fileList, i, sourceFileOrFolder, isSourceDirectory, out);
                                zippedFiles.add(fileList[i]);
                                ++fileNum;
                                continue;
                            }
                        }
                    }
                    if (this.isBasic()) {
                        this.logBasic(BaseMessages.getString(PKG, (String)"ActionZipFile.Log.TotalZippedFiles", (String[])new String[]{"" + zippedFiles.size()}));
                    }
                    if (tempFile != null && !tempFile.delete()) {
                        throw new HopException("Unable to delete temporary file " + String.valueOf(tempFile));
                    }
                    if (this.afterZip == 1 || this.afterZip == 2) {
                        for (FileObject fileObjectd : zippedFiles) {
                            if (!isSourceDirectory) {
                                fileObjectd = HopVfs.getFileObject((String)localSourceFilename, (IVariables)this.getVariables());
                            }
                            if (this.afterZip == 1) {
                                successResult = this.deleteFile(successResult, fileObjectd, localSourceFilename);
                            } else if (this.afterZip == 2) {
                                successResult = this.moveFile(successResult, fileObjectd, realMoveToDirectory);
                            }
                            fileObjectd.close();
                        }
                    }
                    if (this.addFileToResult) {
                        ResultFile resultFile = new ResultFile(0, fileObject, parentWorkflow.getWorkflowName(), this.toString());
                        result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                    }
                    successResult = true;
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.Cant_CreateZipFile1.Label", (String[])new String[0]) + (String)localrealZipfilename + BaseMessages.getString(PKG, (String)"ActionZipFile.Cant_CreateZipFile2.Label", (String[])new String[0]), e);
                    successResult = false;
                }
            } else {
                successResult = false;
                if (localrealZipfilename == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.No_ZipFile_Defined.Label", (String[])new String[0]));
                }
                if (!orginExist) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.No_FolderCible_Defined.Label", (String[])new String[]{localSourceFilename}));
                }
            }
        }
        return successResult;
    }

    private static void moveRenameZipArchive(File tempFile, HashSet<String> fileSet, ZipOutputStream out) throws IOException {
        try (ZipInputStream zin = new ZipInputStream(new FileInputStream(tempFile));){
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (!fileSet.contains(name)) {
                    int len;
                    out.putNextEntry(new ZipEntry(name));
                    byte[] buffer = new byte[18024];
                    while ((len = zin.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    fileSet.add(name);
                }
                entry = zin.getNextEntry();
            }
        }
    }

    private void addFileToZip(FileObject file, FileObject[] fileList, int i, FileObject sourceFileOrFolder, boolean isSourceDirectory, ZipOutputStream out) throws IOException, HopException {
        try (InputStream in = HopVfs.getInputStream((FileObject)file);){
            int len;
            String relativeName;
            String fullName = fileList[i].getName().getPath();
            String basePath = sourceFileOrFolder.getName().getPath();
            if (isSourceDirectory) {
                relativeName = fullName.startsWith(basePath) ? fullName.substring(basePath.length() + 1) : fullName;
            } else if (this.fromPrevious) {
                int depth = this.determineDepth(this.resolve(this.storedSourcePathDepth));
                relativeName = this.determineZipfilenameForDepth(fullName, depth);
            } else {
                relativeName = fileList[i].getName().getBaseName();
            }
            out.putNextEntry(new ZipEntry(relativeName));
            byte[] buffer = new byte[18024];
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            out.flush();
            out.closeEntry();
        }
    }

    private boolean moveFile(boolean successResult, FileObject fileObjectd, String realMoveToDirectory) {
        boolean success = successResult;
        try (FileObject fileObjectm = HopVfs.getFileObject((String)(realMoveToDirectory + Const.FILE_SEPARATOR + fileObjectd.getName().getBaseName()), (IVariables)this.getVariables());){
            fileObjectd.moveTo(fileObjectm);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.Cant_Move_File1.Label", (String[])new String[0]) + String.valueOf(fileObjectd) + BaseMessages.getString(PKG, (String)"ActionZipFile.Cant_Move_File2.Label", (String[])new String[0]) + e.getMessage());
            success = false;
        }
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"ActionZipFile.File_Moved1.Label", (String[])new String[0]) + String.valueOf(fileObjectd) + BaseMessages.getString(PKG, (String)"ActionZipFile.File_Moved2.Label", (String[])new String[0]));
        }
        return success;
    }

    private boolean deleteFile(boolean successResult, FileObject fileObjectd, String localSourceFilename) throws FileSystemException {
        boolean success = successResult;
        boolean deleted = fileObjectd.delete();
        if (!deleted) {
            success = false;
            this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.Cant_Delete_File1.Label", (String[])new String[0]) + localSourceFilename + Const.FILE_SEPARATOR + String.valueOf(fileObjectd) + BaseMessages.getString(PKG, (String)"ActionZipFile.Cant_Delete_File2.Label", (String[])new String[0]));
        }
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"ActionZipFile.File_Deleted1.Label", (String[])new String[0]) + localSourceFilename + Const.FILE_SEPARATOR + String.valueOf(fileObjectd) + BaseMessages.getString(PKG, (String)"ActionZipFile.File_Deleted2.Label", (String[])new String[0]));
        }
        return success;
    }

    private int determineDepth(String depthString) throws HopException {
        DecimalFormat df = new DecimalFormat("0");
        ParsePosition pp = new ParsePosition(0);
        df.setParseIntegerOnly(true);
        try {
            Number n = df.parse(depthString, pp);
            if (n == null) {
                return 1;
            }
            if (pp.getErrorIndex() == 0) {
                throw new HopException("Unable to convert stored depth '" + depthString + "' to depth at position " + pp.getErrorIndex());
            }
            return n.intValue();
        }
        catch (Exception e) {
            throw new HopException("Unable to convert stored depth '" + depthString + "' to depth", (Throwable)e);
        }
    }

    private String determineZipfilenameForDepth(String filename, int depth) throws HopException {
        try {
            if (Utils.isEmpty((CharSequence)filename)) {
                return null;
            }
            if (depth == 0) {
                return filename;
            }
            FileObject fileObject = HopVfs.getFileObject((String)filename, (IVariables)this.getVariables());
            FileObject folder = fileObject.getParent();
            String baseName = fileObject.getName().getBaseName();
            if (depth == 1) {
                return baseName;
            }
            StringBuilder path = new StringBuilder(baseName);
            for (int d = 1; d < depth && folder != null; folder = folder.getParent(), ++d) {
                path.insert(0, '/');
                path.insert(0, folder.getName().getBaseName());
            }
            return path.toString();
        }
        catch (Exception e) {
            throw new HopException("Unable to get zip filename '" + filename + "' to depth " + depth, (Throwable)e);
        }
    }

    private File getFile(String filename) {
        try {
            String uri = HopVfs.getFileObject((String)this.resolve(filename), (IVariables)this.getVariables()).getName().getPath();
            return new File(uri);
        }
        catch (HopFileException ex) {
            this.logError("Error in Fetching URI for File: " + filename, ex);
            return new File(filename);
        }
    }

    private boolean checkContainsFile(String realSourceDirectoryOrFile, FileObject[] filelist, boolean isDirectory) throws FileSystemException {
        boolean retval = false;
        for (FileObject file : filelist) {
            if (!file.exists() || !file.getType().equals((Object)FileType.FILE)) continue;
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        List rows = result.getRows();
        String realWildcard = null;
        String realWildcardExclude = null;
        String realMovetodirectory = this.resolve(this.moveToDirectory);
        boolean sanityControlOK = true;
        if (this.afterZip == 2) {
            if (Utils.isEmpty((CharSequence)realMovetodirectory)) {
                sanityControlOK = false;
                this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.AfterZip_No_DestinationFolder_Defined.Label", (String[])new String[0]));
            } else {
                FileObject moveToDirectory = null;
                try {
                    moveToDirectory = HopVfs.getFileObject((String)realMovetodirectory, (IVariables)this.getVariables());
                    if (moveToDirectory.exists()) {
                        if (moveToDirectory.getType() == FileType.FOLDER) {
                            if (this.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionZipFile.Log.MoveToFolderExist", (String[])new String[]{realMovetodirectory}));
                            }
                        } else {
                            sanityControlOK = false;
                            this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.Log.MoveToFolderNotFolder", (String[])new String[]{realMovetodirectory}));
                        }
                    } else {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionZipFile.Log.MoveToFolderNotNotExist", (String[])new String[]{realMovetodirectory}));
                        }
                        if (this.createMoveToDirectory) {
                            moveToDirectory.createFolder();
                            if (this.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionZipFile.Log.MoveToFolderCreaterd", (String[])new String[]{realMovetodirectory}));
                            }
                        } else {
                            sanityControlOK = false;
                            this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.Log.MoveToFolderNotNotExist", (String[])new String[]{realMovetodirectory}));
                        }
                    }
                }
                catch (Exception e) {
                    sanityControlOK = false;
                    this.logError(BaseMessages.getString(PKG, (String)"ActionZipFile.ErrorGettingMoveToFolder.Label", (String[])new String[]{realMovetodirectory}), e);
                }
                finally {
                    if (moveToDirectory != null) {
                        realMovetodirectory = HopVfs.getFilename((FileObject)moveToDirectory);
                        try {
                            moveToDirectory.close();
                        }
                        catch (Exception e) {
                            this.logError("Error moving to directory", e);
                            sanityControlOK = false;
                        }
                    }
                }
            }
        }
        if (!sanityControlOK) {
            return this.errorResult(result);
        }
        if (this.fromPrevious && this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionZipFile.ArgFromPrevious.Found", (String[])new String[]{"" + (rows != null ? rows.size() : 0)}));
        }
        if (this.fromPrevious && rows != null) {
            try {
                for (int iteration = 0; iteration < rows.size() && !this.parentWorkflow.isStopped(); ++iteration) {
                    RowMetaAndData resultRow = (RowMetaAndData)rows.get(iteration);
                    String realTargetdirectory = resultRow.getString(0, null);
                    if (!Utils.isEmpty((CharSequence)realTargetdirectory)) {
                        String realZipfilename;
                        if (!Utils.isEmpty((CharSequence)resultRow.getString(1, null))) {
                            realWildcard = resultRow.getString(1, null);
                        }
                        if (!Utils.isEmpty((CharSequence)resultRow.getString(2, null))) {
                            realWildcardExclude = resultRow.getString(2, null);
                        }
                        if (!Utils.isEmpty((CharSequence)(realZipfilename = resultRow.getString(3, null)))) {
                            if (this.processRowFile((IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, result, realZipfilename, realWildcard, realWildcardExclude, realTargetdirectory, realMovetodirectory, this.createParentFolder)) continue;
                            return this.errorResult(result);
                        }
                        this.logError("destination zip filename is empty! Ignoring row...");
                        continue;
                    }
                    this.logError("Target directory is empty! Ignoring row...");
                }
            }
            catch (Exception e) {
                this.logError("Error during process!", e);
                result.setResult(false);
                result.setNrErrors(1L);
            }
        } else if (!this.fromPrevious) {
            if (!Utils.isEmpty((CharSequence)this.sourceDirectory)) {
                boolean success;
                String realZipfilename = this.getFullFilename(this.resolve(this.zipFilename), this.addDate, this.addTime, this.specifyFormat, this.dateTimeFormat);
                realWildcard = this.resolve(this.wildCard);
                realWildcardExclude = this.resolve(this.excludeWildCard);
                String realTargetdirectory = this.resolve(this.sourceDirectory);
                try {
                    success = this.processRowFile((IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, result, realZipfilename, realWildcard, realWildcardExclude, realTargetdirectory, realMovetodirectory, this.createParentFolder);
                }
                catch (HopException e) {
                    this.logError("Error zipping data", e);
                    success = false;
                }
                if (success) {
                    result.setResult(true);
                } else {
                    this.errorResult(result);
                }
            } else {
                this.logError("Source folder/file is empty! Ignoring row...");
            }
        }
        return result;
    }

    private Result errorResult(Result result) {
        result.setNrErrors(1L);
        result.setResult(false);
        return result;
    }

    public String getFullFilename(String filename, boolean addDate, boolean addTime, boolean specifyFormat, String datetimeFolder) {
        if (Utils.isEmpty((CharSequence)filename)) {
            return null;
        }
        String realfilename = this.resolve(filename);
        int lenstring = realfilename.length();
        int lastindexOfDot = realfilename.lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        Object retval = realfilename.substring(0, lastindexOfDot);
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (specifyFormat && !Utils.isEmpty((CharSequence)datetimeFolder)) {
            daf.applyPattern(datetimeFolder);
            String dt = daf.format(now);
            retval = (String)retval + dt;
        } else {
            if (addDate) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                retval = (String)retval + "_" + d;
            }
            if (addTime) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                retval = (String)retval + "_" + t;
            }
        }
        retval = (String)retval + realfilename.substring(lastindexOfDot, lenstring);
        return retval;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx1 = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx1, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx1, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileDoesNotExistValidator()});
        if (3 == this.ifZipFileExists) {
            FileDoesNotExistValidator.putFailIfExists((ValidatorContext)ctx1, (boolean)true);
        }
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "zipFilename", remarks, ctx1);
        if (2 == this.afterZip) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "moveToDirectory", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        }
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "sourceDirectory", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }

    public String getZipFilename() {
        return this.zipFilename;
    }

    public void setZipFilename(String zipFilename) {
        this.zipFilename = zipFilename;
    }

    public int getCompressionRate() {
        return this.compressionRate;
    }

    public void setCompressionRate(int compressionRate) {
        this.compressionRate = compressionRate;
    }

    public int getIfZipFileExists() {
        return this.ifZipFileExists;
    }

    public void setIfZipFileExists(int ifZipFileExists) {
        this.ifZipFileExists = ifZipFileExists;
    }

    public int getAfterZip() {
        return this.afterZip;
    }

    public void setAfterZip(int afterZip) {
        this.afterZip = afterZip;
    }

    public String getWildCard() {
        return this.wildCard;
    }

    public void setWildCard(String wildCard) {
        this.wildCard = wildCard;
    }

    public String getExcludeWildCard() {
        return this.excludeWildCard;
    }

    public void setExcludeWildCard(String excludeWildCard) {
        this.excludeWildCard = excludeWildCard;
    }

    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(String sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public String getMoveToDirectory() {
        return this.moveToDirectory;
    }

    public void setMoveToDirectory(String moveToDirectory) {
        this.moveToDirectory = moveToDirectory;
    }

    public boolean isAddFileToResult() {
        return this.addFileToResult;
    }

    public void setAddFileToResult(boolean addFileToResult) {
        this.addFileToResult = addFileToResult;
    }

    public boolean isFromPrevious() {
        return this.fromPrevious;
    }

    public void setFromPrevious(boolean fromPrevious) {
        this.fromPrevious = fromPrevious;
    }

    public boolean isCreateParentFolder() {
        return this.createParentFolder;
    }

    public void setCreateParentFolder(boolean createParentFolder) {
        this.createParentFolder = createParentFolder;
    }

    public boolean isAddDate() {
        return this.addDate;
    }

    public void setAddDate(boolean addDate) {
        this.addDate = addDate;
    }

    public boolean isAddTime() {
        return this.addTime;
    }

    public void setAddTime(boolean addTime) {
        this.addTime = addTime;
    }

    public boolean isSpecifyFormat() {
        return this.specifyFormat;
    }

    public void setSpecifyFormat(boolean specifyFormat) {
        this.specifyFormat = specifyFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public boolean isCreateMoveToDirectory() {
        return this.createMoveToDirectory;
    }

    public void setCreateMoveToDirectory(boolean createMoveToDirectory) {
        this.createMoveToDirectory = createMoveToDirectory;
    }

    public boolean isIncludingSubFolders() {
        return this.includingSubFolders;
    }

    public void setIncludingSubFolders(boolean includingSubFolders) {
        this.includingSubFolders = includingSubFolders;
    }

    public String getStoredSourcePathDepth() {
        return this.storedSourcePathDepth;
    }

    public void setStoredSourcePathDepth(String storedSourcePathDepth) {
        this.storedSourcePathDepth = storedSourcePathDepth;
    }

    public static class ZipJobEntryPatternFileSelector
    implements FileSelector {
        private Pattern pattern;
        private Pattern patternExclude;

        public ZipJobEntryPatternFileSelector(Pattern pattern, Pattern patternExclude) {
            this.pattern = pattern;
            this.patternExclude = patternExclude;
        }

        public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
            return true;
        }

        public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
            boolean include;
            if (fileInfo.getFile().getType().equals((Object)FileType.FILE)) {
                String name;
                include = true;
                if (this.pattern != null) {
                    name = fileInfo.getFile().getName().getBaseName();
                    include = this.pattern.matcher(name).matches();
                }
                if (include && this.patternExclude != null) {
                    name = fileInfo.getFile().getName().getBaseName();
                    include = !this.patternExclude.matcher(name).matches();
                }
            } else {
                include = false;
            }
            return include;
        }
    }
}

