/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import com.google.common.base.Objects;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.selection.SelectionColumnMapping;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public class TermSelector
extends Selector {
    protected static final Selector.SelectorDeserializer deserializer = new Selector.SelectorDeserializer(){

        @Override
        protected Selector deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            AbstractType<?> type = this.readType(metadata, in);
            ByteBuffer value = ByteBufferUtil.readWithVIntLength(in);
            return new TermSelector(value, type);
        }
    };
    private final ByteBuffer value;
    private final AbstractType<?> type;

    public static Selector.Factory newFactory(final String name, final Term term, final AbstractType<?> type) {
        return new Selector.Factory(){

            @Override
            protected String getColumnName() {
                return name;
            }

            @Override
            protected AbstractType<?> getReturnType() {
                return type;
            }

            @Override
            protected void addColumnMapping(SelectionColumnMapping mapping, ColumnSpecification resultColumn) {
                mapping.addMapping(resultColumn, (ColumnMetadata)null);
            }

            @Override
            public Selector newInstance(QueryOptions options) {
                return new TermSelector(term.bindAndGet(options), type);
            }

            @Override
            public void addFetchedColumns(ColumnFilter.Builder builder) {
            }

            @Override
            public boolean areAllFetchedColumnsKnown() {
                return true;
            }
        };
    }

    TermSelector(ByteBuffer value, AbstractType<?> type) {
        super(Selector.Kind.TERM_SELECTOR);
        this.value = value;
        this.type = type;
    }

    @Override
    public void addFetchedColumns(ColumnFilter.Builder builder) {
    }

    @Override
    public void addInput(ProtocolVersion protocolVersion, Selector.InputRow input) {
    }

    @Override
    public ByteBuffer getOutput(ProtocolVersion protocolVersion) {
        return this.value;
    }

    @Override
    public AbstractType<?> getType() {
        return this.type;
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TermSelector)) {
            return false;
        }
        TermSelector s = (TermSelector)o;
        return Objects.equal((Object)this.value, (Object)s.value) && Objects.equal(this.type, s.type);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value, this.type});
    }

    @Override
    protected int serializedSize(int version) {
        return TermSelector.sizeOf(this.type) + ByteBufferUtil.serializedSizeWithVIntLength(this.value);
    }

    @Override
    protected void serialize(DataOutputPlus out, int version) throws IOException {
        TermSelector.writeType(out, this.type);
        ByteBufferUtil.writeWithVIntLength(this.value, out);
    }
}

