/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.html2text;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.html2text.Html2TextData;
import org.apache.hop.pipeline.transforms.html2text.Html2TextMeta;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Safelist;

public class Html2Text
extends BaseTransform<Html2TextMeta, Html2TextData> {
    public static final int OVER_ALLOCATE_SIZE = 10;
    private static final Class<?> PKG = Html2Text.class;
    private Html2TextMeta.SafelistType safelistType;
    private final int cores = Runtime.getRuntime().availableProcessors();
    private final int maxJobs = this.cores * 100;
    private final ExecutorService executor = ForkJoinPool.commonPool();
    private final AtomicInteger jobs = new AtomicInteger(0);
    private final Object lock = new Object();

    public Html2Text(TransformMeta transformMeta, Html2TextMeta meta, Html2TextData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish() {
        Object object = this.lock;
        synchronized (object) {
            while (this.jobs.get() > 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.setOutputDone();
    }

    public boolean processRow() throws HopException {
        block8: {
            Object[] r = this.getRow();
            if (r == null) {
                this.finish();
                return false;
            }
            if (this.first) {
                this.first = false;
                ((Html2TextData)this.data).previousRowMeta = this.getInputRowMeta().clone();
                ((Html2TextData)this.data).NrPrevFields = ((Html2TextData)this.data).previousRowMeta.size();
                ((Html2TextData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((Html2TextMeta)this.meta).getFields(((Html2TextData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                if (Utils.isEmpty((CharSequence)((Html2TextMeta)this.meta).getHtmlField())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"Html2Text.Error.HtmlFieldMissing", (String[])new String[0]));
                }
                if (Utils.isEmpty((CharSequence)((Html2TextMeta)this.meta).getOutputField())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"Html2Text.Error.OutputFieldMissing", (String[])new String[0]));
                }
                this.cacheIndexPositions();
                this.safelistType = Html2TextMeta.SafelistType.valueOf(((Html2TextMeta)this.meta).getSafelistType());
            }
            boolean sendToErrorRow = false;
            String errorMessage = null;
            this.process(r);
            try {
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"Html2Text.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (Exception e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"Html2Text.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block8;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, ((Html2TextMeta)this.meta).getHtmlField(), "Html2Text001");
            }
        }
        return true;
    }

    private void process(Object[] inputRow) throws HopTransformException {
        String html = StringUtils.trim((String)((String)inputRow[((Html2TextData)this.data).indexOfHtmlField]));
        if (StringUtils.isBlank((CharSequence)html)) {
            return;
        }
        if (((Html2TextMeta)this.meta).isParallelism()) {
            this.processAsync(html, inputRow);
        } else {
            this.processSync(html, inputRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAsync(String html, Object[] inputRow) {
        Object object = this.lock;
        synchronized (object) {
            while (this.jobs.get() > this.maxJobs) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.executor.submit(() -> {
            try {
                this.processSync(html, inputRow);
                this.jobs.decrementAndGet();
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
            catch (Exception e) {
                this.logError(e.getMessage(), e);
            }
        });
        this.jobs.incrementAndGet();
    }

    private void processSync(String html, Object[] inputRow) throws HopTransformException {
        Document document = Jsoup.parseBodyFragment((String)html);
        if (((Html2TextMeta)this.meta).isCleanOnly()) {
            this.processOutput(Jsoup.clean((String)document.html(), (Safelist)(switch (this.safelistType) {
                case Html2TextMeta.SafelistType.basic -> Safelist.basic();
                case Html2TextMeta.SafelistType.simpleText -> Safelist.simpleText();
                case Html2TextMeta.SafelistType.basicWithImages -> Safelist.basicWithImages();
                case Html2TextMeta.SafelistType.none -> Safelist.none();
                case Html2TextMeta.SafelistType.relaxed -> Safelist.relaxed();
                default -> Safelist.basic();
            })), inputRow);
        } else {
            String text = ((Html2TextMeta)this.meta).isNormalisedText() ? document.text() : document.wholeText();
            this.processOutput(text, inputRow);
        }
    }

    private void cacheIndexPositions() throws HopException {
        if (((Html2TextData)this.data).indexOfHtmlField < 0) {
            ((Html2TextData)this.data).indexOfHtmlField = ((Html2TextData)this.data).previousRowMeta.indexOfValue(((Html2TextMeta)this.meta).getHtmlField());
            if (((Html2TextData)this.data).indexOfHtmlField < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)"Html2Text.Exception.CouldnotFindField", (String[])new String[]{((Html2TextMeta)this.meta).getHtmlField()}));
            }
        }
        if (((Html2TextData)this.data).indexOfOutputField < 0) {
            ((Html2TextData)this.data).indexOfOutputField = ((Html2TextData)this.data).outputRowMeta.indexOfValue(((Html2TextMeta)this.meta).getOutputField());
            if (((Html2TextData)this.data).indexOfOutputField < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)"Html2Text.Exception.CouldnotFindField", (String[])new String[]{((Html2TextMeta)this.meta).getOutputField()}));
            }
        }
    }

    private void processOutput(String output, Object[] inputRow) throws HopTransformException {
        Object[] outputRow = new Object[inputRow.length + 1 + 10];
        System.arraycopy(inputRow, 0, outputRow, 0, inputRow.length);
        outputRow[((Html2TextData)this.data).indexOfOutputField] = output;
        this.putRow(((Html2TextData)this.data).outputRowMeta, outputRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRow(IRowMeta rowMeta, Object[] row) throws HopTransformException {
        Html2Text html2Text = this;
        synchronized (html2Text) {
            super.putRow(rowMeta, row);
        }
    }
}

