/*
 * Decompiled with CFR 0.152.
 */
package io.minio.messages;

import io.minio.Utils;
import java.util.List;
import javax.annotation.Nullable;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="CORSConfiguration", strict=false)
@Namespace(reference="http://s3.amazonaws.com/doc/2006-03-01/")
public class CORSConfiguration {
    @ElementList(name="CORSRule", inline=true, required=false)
    private List<CORSRule> rules;

    public CORSConfiguration(@Nullable @ElementList(name="CORSRule", required=false) List<CORSRule> rules) {
        this.rules = rules;
    }

    public List<CORSRule> rules() {
        return Utils.unmodifiableList(this.rules);
    }

    public static class CORSRule {
        @ElementList(entry="AllowedHeader", inline=true, required=false)
        private List<String> allowedHeaders;
        @ElementList(entry="AllowedMethod", inline=true, required=false)
        private List<String> allowedMethods;
        @ElementList(entry="AllowedOrigin", inline=true, required=false)
        private List<String> allowedOrigins;
        @ElementList(entry="ExposeHeader", inline=true, required=false)
        private List<String> exposeHeaders;
        @Element(name="ID", required=false)
        private String id;
        @Element(name="MaxAgeSeconds", required=false)
        private Integer maxAgeSeconds;

        public CORSRule(@Nullable @ElementList(entry="AllowedHeader", inline=true, required=false) List<String> allowedHeaders, @Nullable @ElementList(entry="AllowedMethod", inline=true, required=false) List<String> allowedMethods, @Nullable @ElementList(entry="AllowedOrigin", inline=true, required=false) List<String> allowedOrigins, @Nullable @ElementList(entry="ExposeHeader", inline=true, required=false) List<String> exposeHeaders, @Nullable @Element(name="ID", required=false) String id, @Nullable @Element(name="MaxAgeSeconds", required=false) Integer maxAgeSeconds) {
            this.allowedHeaders = allowedHeaders;
            this.allowedMethods = allowedMethods;
            this.allowedOrigins = allowedOrigins;
            this.exposeHeaders = exposeHeaders;
            this.id = id;
            this.maxAgeSeconds = maxAgeSeconds;
        }

        public List<String> allowedHeaders() {
            return Utils.unmodifiableList(this.allowedHeaders);
        }

        public List<String> allowedMethods() {
            return Utils.unmodifiableList(this.allowedMethods);
        }

        public List<String> allowedOrigins() {
            return Utils.unmodifiableList(this.allowedOrigins);
        }

        public List<String> exposeHeaders() {
            return Utils.unmodifiableList(this.exposeHeaders);
        }

        public String id() {
            return this.id;
        }

        public Integer maxAgeSeconds() {
            return this.maxAgeSeconds;
        }
    }
}

