/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop;

import com.google.auto.service.AutoService;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.coders.CoderProviderRegistrar;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class WritableCoder<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized Writable>
extends CustomCoder<T> {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 0L;
    private final @UnknownKeyFor @NonNull @Initialized Class<T> type;

    public static <T extends Writable> @UnknownKeyFor @NonNull @Initialized WritableCoder<T> of(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        return new WritableCoder<T>(clazz);
    }

    public WritableCoder(@UnknownKeyFor @NonNull @Initialized Class<T> type) {
        this.type = type;
    }

    public void encode(T value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        value.write((DataOutput)new DataOutputStream(outStream));
    }

    public T decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            if (this.type == NullWritable.class) {
                return (T)NullWritable.get();
            }
            Writable t = (Writable)this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            t.readFields((DataInput)new DataInputStream(inStream));
            return (T)t;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CoderException("unable to deserialize record", (Throwable)e);
        }
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
        return Collections.emptyList();
    }

    public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException((Coder)this, "Hadoop Writable may be non-deterministic.");
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof WritableCoder)) {
            return false;
        }
        WritableCoder that = (WritableCoder)((Object)other);
        return Objects.equals(this.type, that.type);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.type.hashCode();
    }

    public static @UnknownKeyFor @NonNull @Initialized CoderProvider getCoderProvider() {
        return new WritableCoderProvider();
    }

    private static class WritableCoderProvider
    extends CoderProvider {
        private static final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized Writable> WRITABLE_TYPE = new TypeDescriptor<Writable>(){};

        private WritableCoderProvider() {
        }

        public <T> @UnknownKeyFor @NonNull @Initialized Coder<T> coderFor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> componentCoders) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            if (!typeDescriptor.isSubtypeOf(WRITABLE_TYPE)) {
                throw new CannotProvideCoderException(String.format("Cannot provide %s because %s does not implement the interface %s", WritableCoder.class.getSimpleName(), typeDescriptor, Writable.class.getName()));
            }
            try {
                WritableCoder coder = WritableCoder.of(typeDescriptor.getRawType());
                return coder;
            }
            catch (IllegalArgumentException e) {
                throw new CannotProvideCoderException((Throwable)e);
            }
        }
    }

    @AutoService(value={CoderProviderRegistrar.class})
    public static class WritableCoderProviderRegistrar
    implements CoderProviderRegistrar {
        public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized CoderProvider> getCoderProviders() {
            return Collections.singletonList(WritableCoder.getCoderProvider());
        }
    }
}

