/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforce;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceConnection;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransformMeta;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class SalesforceTransformDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = SalesforceTransformMeta.class;
    protected static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'.000'Z";
    protected static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private final Class<? extends SalesforceTransformMeta> META_CLASS;

    public SalesforceTransformDialog(Shell parent, IVariables variables, SalesforceTransformMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.META_CLASS = ((Object)((Object)transformMeta)).getClass();
    }

    protected abstract void getInfo(SalesforceTransformMeta var1) throws HopException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void test() {
        boolean successConnection = true;
        String msgError = null;
        SalesforceConnection connection = null;
        String realUsername = null;
        boolean usingMetadataConnection = false;
        try {
            SalesforceTransformMeta meta = this.META_CLASS.newInstance();
            this.getInfo(meta);
            String connectionName = this.variables.resolve(meta.getSalesforceConnection());
            if (!Utils.isEmpty((CharSequence)connectionName)) {
                usingMetadataConnection = true;
                org.apache.hop.metadata.salesforce.SalesforceConnection connectionMeta = (org.apache.hop.metadata.salesforce.SalesforceConnection)this.metadataProvider.getSerializer(org.apache.hop.metadata.salesforce.SalesforceConnection.class).load(connectionName);
                if (connectionMeta == null) {
                    throw new HopException("Salesforce Connection '" + connectionName + "' not found in metadata");
                }
                connection = connectionMeta.createConnection(this.variables, (ILogChannel)this.log);
                realUsername = connectionName;
            } else {
                String realURL = this.variables.resolve(meta.getTargetUrl());
                realUsername = this.variables.resolve(meta.getUsername());
                String realPassword = Utils.resolvePassword((IVariables)this.variables, (String)meta.getPassword());
                connection = new SalesforceConnection((ILogChannel)this.log, realURL, realUsername, realPassword);
            }
            int realTimeOut = Const.toInt((String)this.variables.resolve(meta.getTimeout()), (int)0);
            connection.setTimeOut(realTimeOut);
            connection.connect();
        }
        catch (Exception e) {
            successConnection = false;
            msgError = e.getMessage();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {}
            }
        }
        if (successConnection) {
            MessageBox mb = new MessageBox(this.shell, 34);
            Object successMessage = usingMetadataConnection ? "Connected to Salesforce with connection [" + realUsername + "]" : BaseMessages.getString(PKG, (String)"SalesforceTransformDialog.Connected.OK", (String[])new String[]{realUsername});
            mb.setMessage((String)successMessage + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"SalesforceTransformDialog.Connected.Title.Ok", (String[])new String[0]));
            mb.open();
        } else {
            String errorMessage = usingMetadataConnection ? "Can not connect to Salesforce with connection [" + realUsername + "]!\nPlease check connection settings.\nException: " + msgError : BaseMessages.getString(PKG, (String)"SalesforceTransformDialog.Connected.NOK", (String[])new String[]{realUsername}) + msgError;
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SalesforceTransformDialog.Connected.Title.Error", (String[])new String[0]), errorMessage, new Exception(msgError));
        }
    }
}

