/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.MemberPermission;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class ParentFolderAccessInfo {
    @Nonnull
    protected final String folderName;
    @Nonnull
    protected final String sharedFolderId;
    @Nonnull
    protected final List<MemberPermission> permissions;
    @Nonnull
    protected final String path;

    public ParentFolderAccessInfo(@Nonnull String folderName, @Nonnull String sharedFolderId, @Nonnull List<MemberPermission> permissions, @Nonnull String path) {
        if (folderName == null) {
            throw new IllegalArgumentException("Required value for 'folderName' is null");
        }
        this.folderName = folderName;
        if (sharedFolderId == null) {
            throw new IllegalArgumentException("Required value for 'sharedFolderId' is null");
        }
        if (!Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
            throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
        }
        this.sharedFolderId = sharedFolderId;
        if (permissions == null) {
            throw new IllegalArgumentException("Required value for 'permissions' is null");
        }
        for (MemberPermission x : permissions) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'permissions' is null");
        }
        this.permissions = permissions;
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        this.path = path;
    }

    @Nonnull
    public String getFolderName() {
        return this.folderName;
    }

    @Nonnull
    public String getSharedFolderId() {
        return this.sharedFolderId;
    }

    @Nonnull
    public List<MemberPermission> getPermissions() {
        return this.permissions;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.folderName, this.sharedFolderId, this.permissions, this.path});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ParentFolderAccessInfo other = (ParentFolderAccessInfo)obj;
            return !(this.folderName != other.folderName && !this.folderName.equals(other.folderName) || this.sharedFolderId != other.sharedFolderId && !this.sharedFolderId.equals(other.sharedFolderId) || this.permissions != other.permissions && !this.permissions.equals(other.permissions) || this.path != other.path && !this.path.equals(other.path));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ParentFolderAccessInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ParentFolderAccessInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("folder_name");
            StoneSerializers.string().serialize(value.folderName, g);
            g.writeFieldName("shared_folder_id");
            StoneSerializers.string().serialize(value.sharedFolderId, g);
            g.writeFieldName("permissions");
            StoneSerializers.list(MemberPermission.Serializer.INSTANCE).serialize(value.permissions, g);
            g.writeFieldName("path");
            StoneSerializers.string().serialize(value.path, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public ParentFolderAccessInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_path;
            List<MemberPermission> f_permissions;
            String f_sharedFolderId;
            String f_folderName;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_folderName = null;
                f_sharedFolderId = null;
                f_permissions = null;
                f_path = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("folder_name".equals(field)) {
                        f_folderName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("shared_folder_id".equals(field)) {
                        f_sharedFolderId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("permissions".equals(field)) {
                        f_permissions = StoneSerializers.list(MemberPermission.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_folderName == null) {
                    throw new JsonParseException(p, "Required field \"folder_name\" missing.");
                }
                if (f_sharedFolderId == null) {
                    throw new JsonParseException(p, "Required field \"shared_folder_id\" missing.");
                }
                if (f_permissions == null) {
                    throw new JsonParseException(p, "Required field \"permissions\" missing.");
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ParentFolderAccessInfo value = new ParentFolderAccessInfo(f_folderName, f_sharedFolderId, f_permissions, f_path);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

