/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.util.MovingFunction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class MovingAverage {
    private final @UnknownKeyFor @NonNull @Initialized MovingFunction sum;
    private final @UnknownKeyFor @NonNull @Initialized MovingFunction count;

    public MovingAverage(@UnknownKeyFor @NonNull @Initialized long samplePeriodMs, @UnknownKeyFor @NonNull @Initialized long sampleUpdateMs, @UnknownKeyFor @NonNull @Initialized int numSignificantBuckets, @UnknownKeyFor @NonNull @Initialized int numSignificantSamples) {
        this.sum = new MovingFunction(samplePeriodMs, sampleUpdateMs, numSignificantBuckets, numSignificantSamples, Sum.ofLongs());
        this.count = new MovingFunction(samplePeriodMs, sampleUpdateMs, numSignificantBuckets, numSignificantSamples, Sum.ofLongs());
    }

    public void add(@UnknownKeyFor @NonNull @Initialized long nowMsSinceEpoch, @UnknownKeyFor @NonNull @Initialized long value) {
        this.sum.add(nowMsSinceEpoch, value);
        this.count.add(nowMsSinceEpoch, 1L);
    }

    public @UnknownKeyFor @NonNull @Initialized long get(@UnknownKeyFor @NonNull @Initialized long nowMsSinceEpoch) {
        return this.sum.get(nowMsSinceEpoch) / this.count.get(nowMsSinceEpoch);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasValue(@UnknownKeyFor @NonNull @Initialized long nowMsSinceEpoch) {
        return this.sum.isSignificant() && this.count.isSignificant() && this.count.get(nowMsSinceEpoch) > 0L;
    }
}

