/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.ReadableInstant;

public class StaticSchemaInference {
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class, @UnknownKeyFor @NonNull @Initialized Schema.FieldType> PRIMITIVE_TYPES = ImmutableMap.builder().put(Byte.class, (Object)Schema.FieldType.BYTE).put(Byte.TYPE, (Object)Schema.FieldType.BYTE).put(Short.class, (Object)Schema.FieldType.INT16).put(Short.TYPE, (Object)Schema.FieldType.INT16).put(Integer.class, (Object)Schema.FieldType.INT32).put(Integer.TYPE, (Object)Schema.FieldType.INT32).put(Long.class, (Object)Schema.FieldType.INT64).put(Long.TYPE, (Object)Schema.FieldType.INT64).put(Float.class, (Object)Schema.FieldType.FLOAT).put(Float.TYPE, (Object)Schema.FieldType.FLOAT).put(Double.class, (Object)Schema.FieldType.DOUBLE).put(Double.TYPE, (Object)Schema.FieldType.DOUBLE).put(Boolean.class, (Object)Schema.FieldType.BOOLEAN).put(Boolean.TYPE, (Object)Schema.FieldType.BOOLEAN).put(BigDecimal.class, (Object)Schema.FieldType.DECIMAL).build();

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> sortBySchema(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> types, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        Map typeMap = types.stream().collect(Collectors.toMap(FieldValueTypeInformation::getName, Function.identity()));
        return schema.getFields().stream().map(f -> (FieldValueTypeInformation)typeMap.get(f.getName())).collect(Collectors.toList());
    }

    public static @UnknownKeyFor @NonNull @Initialized Schema schemaFromClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor, @UnknownKeyFor @NonNull @Initialized FieldValueTypeSupplier fieldValueTypeSupplier) {
        return StaticSchemaInference.schemaFromClass(typeDescriptor, fieldValueTypeSupplier, new HashMap());
    }

    private static @UnknownKeyFor @NonNull @Initialized Schema schemaFromClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor, @UnknownKeyFor @NonNull @Initialized FieldValueTypeSupplier fieldValueTypeSupplier, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Schema> alreadyVisitedSchemas) {
        if (alreadyVisitedSchemas.containsKey(typeDescriptor)) {
            Schema existingSchema = alreadyVisitedSchemas.get(typeDescriptor);
            if (existingSchema == null) {
                throw new IllegalArgumentException("Cannot infer schema with a circular reference. Class: " + typeDescriptor.getRawType().getTypeName());
            }
            return existingSchema;
        }
        alreadyVisitedSchemas.put(typeDescriptor, null);
        Schema.Builder builder = Schema.builder();
        for (FieldValueTypeInformation type : fieldValueTypeSupplier.get(typeDescriptor)) {
            Schema.Field f;
            Schema.FieldType fieldType = StaticSchemaInference.fieldFromType(type.getType(), fieldValueTypeSupplier, alreadyVisitedSchemas);
            Schema.Field field = f = type.isNullable() ? Schema.Field.nullable(type.getName(), fieldType) : Schema.Field.of(type.getName(), fieldType);
            if (type.getDescription() != null) {
                f = f.withDescription(type.getDescription());
            }
            builder.addFields(f);
        }
        Schema generatedSchema = builder.build();
        alreadyVisitedSchemas.replace(typeDescriptor, generatedSchema);
        return generatedSchema;
    }

    public static @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldFromType(@UnknownKeyFor @NonNull @Initialized TypeDescriptor type, @UnknownKeyFor @NonNull @Initialized FieldValueTypeSupplier fieldValueTypeSupplier) {
        return StaticSchemaInference.fieldFromType(type, fieldValueTypeSupplier, new HashMap());
    }

    private static @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldFromType(@UnknownKeyFor @NonNull @Initialized TypeDescriptor type, @UnknownKeyFor @NonNull @Initialized FieldValueTypeSupplier fieldValueTypeSupplier, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Schema> alreadyVisitedSchemas) {
        Schema.FieldType primitiveType = PRIMITIVE_TYPES.get(type.getRawType());
        if (primitiveType != null) {
            return primitiveType;
        }
        if (type.getRawType().isEnum()) {
            Map<String, Integer> enumValues = Arrays.stream(type.getRawType().getEnumConstants()).map(Enum.class::cast).collect(Collectors.toMap(Enum::toString, Enum::ordinal));
            return Schema.FieldType.logicalType(EnumerationType.create(enumValues));
        }
        if (type.isArray()) {
            TypeDescriptor<?> component = type.getComponentType();
            if (component.getRawType().equals(Byte.TYPE)) {
                return Schema.FieldType.BYTES;
            }
            return Schema.FieldType.array(StaticSchemaInference.fieldFromType(component, fieldValueTypeSupplier, alreadyVisitedSchemas));
        }
        if (type.isSubtypeOf(TypeDescriptor.of(Map.class))) {
            TypeDescriptor<Map> map = type.getSupertype(Map.class);
            if (map.getType() instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)map.getType();
                Type[] params = ptype.getActualTypeArguments();
                Preconditions.checkArgument((params.length == 2 ? 1 : 0) != 0);
                Schema.FieldType keyType = StaticSchemaInference.fieldFromType(TypeDescriptor.of(params[0]), fieldValueTypeSupplier, alreadyVisitedSchemas);
                Schema.FieldType valueType = StaticSchemaInference.fieldFromType(TypeDescriptor.of(params[1]), fieldValueTypeSupplier, alreadyVisitedSchemas);
                Preconditions.checkArgument((boolean)keyType.getTypeName().isPrimitiveType(), (Object)("Only primitive types can be map keys. type: " + (Object)((Object)keyType.getTypeName())));
                return Schema.FieldType.map(keyType, valueType);
            }
            throw new RuntimeException("Cannot infer schema from unparameterized map.");
        }
        if (type.isSubtypeOf(TypeDescriptor.of(CharSequence.class))) {
            return Schema.FieldType.STRING;
        }
        if (type.isSubtypeOf(TypeDescriptor.of(ReadableInstant.class))) {
            return Schema.FieldType.DATETIME;
        }
        if (type.isSubtypeOf(TypeDescriptor.of(ByteBuffer.class))) {
            return Schema.FieldType.BYTES;
        }
        if (type.isSubtypeOf(TypeDescriptor.of(Iterable.class))) {
            TypeDescriptor<Iterable> iterable = type.getSupertype(Iterable.class);
            if (iterable.getType() instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)iterable.getType();
                Type[] params = ptype.getActualTypeArguments();
                Preconditions.checkArgument((params.length == 1 ? 1 : 0) != 0);
                if (type.isSubtypeOf(TypeDescriptor.of(Collection.class))) {
                    return Schema.FieldType.array(StaticSchemaInference.fieldFromType(TypeDescriptor.of(params[0]), fieldValueTypeSupplier, alreadyVisitedSchemas));
                }
                return Schema.FieldType.iterable(StaticSchemaInference.fieldFromType(TypeDescriptor.of(params[0]), fieldValueTypeSupplier, alreadyVisitedSchemas));
            }
            throw new RuntimeException("Cannot infer schema from unparameterized collection.");
        }
        return Schema.FieldType.row(StaticSchemaInference.schemaFromClass(type, fieldValueTypeSupplier, alreadyVisitedSchemas));
    }

    static enum MethodType {
        GETTER,
        SETTER;

    }
}

