/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.leases.impl;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.BillingMode;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.leases.exceptions.DependencyException;
import com.amazonaws.services.kinesis.leases.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.leases.exceptions.ProvisionedThroughputException;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLeaseSerializer;
import com.amazonaws.services.kinesis.leases.impl.LeaseManager;
import com.amazonaws.services.kinesis.leases.interfaces.IKinesisClientLeaseManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KinesisClientLeaseManager
extends LeaseManager<KinesisClientLease>
implements IKinesisClientLeaseManager {
    private static final Log LOG = LogFactory.getLog(KinesisClientLeaseManager.class);

    @Deprecated
    public KinesisClientLeaseManager(String table, AmazonDynamoDB dynamoDBClient) {
        this(table, dynamoDBClient, false, KinesisClientLibConfiguration.DEFAULT_DDB_BILLING_MODE);
    }

    public KinesisClientLeaseManager(String table, AmazonDynamoDB dynamoDBClient, BillingMode billingMode) {
        this(table, dynamoDBClient, false, billingMode);
    }

    @Deprecated
    public KinesisClientLeaseManager(String table, AmazonDynamoDB dynamoDBClient, boolean consistentReads) {
        super(table, dynamoDBClient, new KinesisClientLeaseSerializer(), consistentReads, KinesisClientLibConfiguration.DEFAULT_DDB_BILLING_MODE);
    }

    public KinesisClientLeaseManager(String table, AmazonDynamoDB dynamoDBClient, boolean consistentReads, BillingMode billingMode) {
        super(table, dynamoDBClient, new KinesisClientLeaseSerializer(), consistentReads, billingMode);
    }

    @Override
    public boolean takeLease(KinesisClientLease lease, String newOwner) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        String oldOwner = lease.getLeaseOwner();
        boolean result = super.takeLease(lease, newOwner);
        if (oldOwner != null && !oldOwner.equals(newOwner)) {
            lease.setOwnerSwitchesSinceCheckpoint(lease.getOwnerSwitchesSinceCheckpoint() + 1L);
        }
        return result;
    }

    @Override
    public ExtendedSequenceNumber getCheckpoint(String shardId) throws ProvisionedThroughputException, InvalidStateException, DependencyException {
        ExtendedSequenceNumber checkpoint = null;
        KinesisClientLease lease = (KinesisClientLease)this.getLease(shardId);
        if (lease != null) {
            checkpoint = lease.getCheckpoint();
        }
        return checkpoint;
    }
}

