/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.compress.zip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hop.core.compress.CompressionPlugin;
import org.apache.hop.core.compress.ICompressionProvider;
import org.apache.hop.core.compress.zip.ZipCompressionInputStream;
import org.apache.hop.core.compress.zip.ZipCompressionOutputStream;

@CompressionPlugin(id="Zip", name="Zip", description="ZIP compression")
public class ZipCompressionProvider
implements ICompressionProvider {
    @Override
    public ZipCompressionInputStream createInputStream(InputStream in) throws IOException {
        return new ZipCompressionInputStream(in, this);
    }

    @Override
    public boolean supportsInput() {
        return true;
    }

    @Override
    public ZipCompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return new ZipCompressionOutputStream(out, this);
    }

    @Override
    public boolean supportsOutput() {
        return true;
    }

    @Override
    public String getDescription() {
        return "ZIP compression";
    }

    @Override
    public String getName() {
        return "Zip";
    }

    @Override
    public String getDefaultExtension() {
        return "zip";
    }
}

