/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.janino.function;

import org.apache.hop.core.util.Utils;
import org.apache.hop.pipeline.transforms.janino.function.JaninoFunction;

public class HopFunctions {
    private HopFunctions() {
    }

    @JaninoFunction(name="nvl", category="General", description="Implements Oracle style NVL function.", syntax="HopFunctions.nvl(source, def)", returns="String", semantics="If source == null or length == 0 return def", examples="[\n  {\n    \"expression\": \"HopFunctions.nvl(\\\"\\\", \\\"bar\\\")\",\n    \"result\": \"bar\",\n    \"level\": \"1\",\n    \"comment\": \"Empty string returns bar.\"\n  },\n  {\n    \"expression\": \"HopFunctions.nvl(null, \\\"bar\\\")\",\n    \"result\": \"bar\",\n    \"level\": \"1\",\n    \"comment\": \"null string returns bar.\"\n  },\n  {\n    \"expression\": \"HopFunctions.nvl(\\\"foo\\\", \\\"bar\\\")\",\n    \"result\": \"foo\",\n    \"level\": \"1\",\n    \"comment\": \"foo string returns foo.\"\n  }\n]\n")
    public static String nvl(String source, String def) {
        if (Utils.isEmpty((CharSequence)source)) {
            return def;
        }
        return source;
    }
}

