/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.exception;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.PluginRegistry;

public class HopMissingPluginsException
extends HopException {
    private static final long serialVersionUID = -3008319146447259788L;
    private final List<PluginDetails> missingPluginDetailsList = new ArrayList<PluginDetails>();

    public HopMissingPluginsException(String message) {
        super(message);
    }

    public void addMissingPluginDetails(Class<? extends IPluginType> pluginTypeClass, String pluginId) {
        this.missingPluginDetailsList.add(new PluginDetails(pluginTypeClass, pluginId));
    }

    public List<PluginDetails> getMissingPluginDetailsList() {
        return this.missingPluginDetailsList;
    }

    @Override
    public String getMessage() {
        StringBuilder message = new StringBuilder(super.getMessage());
        message.append(this.getPluginsMessage());
        return message.toString();
    }

    public String getPluginsMessage() {
        StringBuilder message = new StringBuilder();
        for (PluginDetails details : this.missingPluginDetailsList) {
            message.append(Const.CR);
            try {
                IPluginType pluginType = PluginRegistry.getInstance().getPluginType(details.pluginTypeClass);
                message.append(pluginType.getName());
            }
            catch (Exception e) {
                message.append("UnknownPluginType-").append(details.getPluginTypeClass().getName());
            }
            message.append(" : ").append(details.getPluginId());
        }
        return message.toString();
    }

    public static class PluginDetails {
        private final Class<? extends IPluginType> pluginTypeClass;
        private final String pluginId;

        public PluginDetails(Class<? extends IPluginType> pluginTypeClass, String pluginId) {
            this.pluginTypeClass = pluginTypeClass;
            this.pluginId = pluginId;
        }

        public Class<? extends IPluginType> getPluginTypeClass() {
            return this.pluginTypeClass;
        }

        public String getPluginId() {
            return this.pluginId;
        }
    }
}

