/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.model.DynamicTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;

public final class DynamicType
extends FlexibleType
implements DynamicTypeMarker {
    @NotNull
    private final TypeAttributes attributes;

    public DynamicType(@NotNull KotlinBuiltIns builtIns2, @NotNull TypeAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)builtIns2, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        SimpleType simpleType2 = builtIns2.getNothingType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"getNothingType(...)");
        SimpleType simpleType3 = builtIns2.getNullableAnyType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"getNullableAnyType(...)");
        super(simpleType2, simpleType3);
        this.attributes = attributes;
    }

    @Override
    @NotNull
    public TypeAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    @NotNull
    public SimpleType getDelegate() {
        return this.getUpperBound();
    }

    @Override
    @NotNull
    public DynamicType makeNullableAsSpecified(boolean newNullability) {
        return this;
    }

    @Override
    public boolean isMarkedNullable() {
        return false;
    }

    @Override
    @NotNull
    public DynamicType replaceAttributes(@NotNull TypeAttributes newAttributes) {
        Intrinsics.checkNotNullParameter((Object)newAttributes, (String)"newAttributes");
        return new DynamicType(TypeUtilsKt.getBuiltIns(this.getDelegate()), newAttributes);
    }

    @Override
    @NotNull
    public String render(@NotNull DescriptorRenderer renderer, @NotNull DescriptorRendererOptions options) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return "dynamic";
    }

    @Override
    @NotNull
    public DynamicType refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        return this;
    }
}

