/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.Optional;
import org.apache.cassandra.auth.RoleOptions;

public class PasswordObfuscator {
    public static final String OBFUSCATION_TOKEN = "*******";
    public static final String PASSWORD_TOKEN = "password".toLowerCase();

    public static String obfuscate(String sourceString) {
        if (null == sourceString) {
            return null;
        }
        int passwordTokenStartIndex = sourceString.toLowerCase().indexOf(PASSWORD_TOKEN);
        if (passwordTokenStartIndex < 0) {
            return sourceString;
        }
        return sourceString.substring(0, passwordTokenStartIndex + PASSWORD_TOKEN.length()) + " " + OBFUSCATION_TOKEN;
    }

    public static String obfuscate(String query, RoleOptions opts) {
        if (opts == null || query == null || query.isEmpty()) {
            return query;
        }
        Optional<String> pass = opts.getPassword();
        if (!pass.isPresent() || pass.get().isEmpty()) {
            pass = opts.getHashedPassword();
        }
        if (!pass.isPresent() || pass.get().isEmpty()) {
            return query;
        }
        return query.replaceAll("((?si)" + PASSWORD_TOKEN + ".+?)\\Q" + pass.get() + "\\E", "$1*******");
    }
}

