/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AbstractProxyImpl;
import com.ibm.as400.access.JDConnectionProxy;
import com.ibm.as400.access.JDResultSetProxy;
import com.ibm.as400.access.ProxyClientConnection;
import com.ibm.as400.access.ProxyException;
import com.ibm.as400.access.ProxyReturnValue;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

class JDStatementProxy
extends AbstractProxyImpl
implements Statement {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    protected JDConnectionProxy jdConnection_;
    protected JDResultSetProxy cachedResultSet_;
    private static final String EXC_FUNCTION_NOT_SUPPORTED = "IM001";

    public JDStatementProxy(JDConnectionProxy jdConnection) {
        this.jdConnection_ = jdConnection;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.callMethod("addBatch", new Class[]{String.class}, new Object[]{sql});
    }

    protected void callMethod(String methodName) throws SQLException {
        try {
            this.connection_.callMethod(this.pxId_, methodName);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    protected void callMethod(String methodName, Class[] argClasses, Object[] argValues) throws SQLException {
        try {
            this.connection_.callMethod(this.pxId_, methodName, argClasses, argValues);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    protected boolean callMethodRtnBool(String methodName) throws SQLException {
        try {
            return this.connection_.callMethodReturnsBoolean(this.pxId_, methodName);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    protected int callMethodRtnInt(String methodName) throws SQLException {
        try {
            return this.connection_.callMethodReturnsInt(this.pxId_, methodName);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    protected long callMethodRtnLong(String methodName) throws SQLException {
        try {
            return this.connection_.callMethodReturnsLong(this.pxId_, methodName);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    protected Object callMethodRtnObj(String methodName) throws SQLException {
        try {
            return this.connection_.callMethodReturnsObject(this.pxId_, methodName);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    protected ProxyReturnValue callMethodRtnRaw(String methodName, Class[] argClasses, Object[] argValues) throws SQLException {
        try {
            return this.connection_.callMethod(this.pxId_, methodName, argClasses, argValues);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.cachedResultSet_ = null;
        this.callMethod("cancel");
    }

    @Override
    public void clearBatch() throws SQLException {
        this.callMethod("clearBatch");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.callMethod("clearWarnings");
    }

    @Override
    public void close() throws SQLException {
        block2: {
            this.cachedResultSet_ = null;
            try {
                this.callMethod("close");
            }
            catch (ProxyException pe) {
                String info = pe.toString();
                if (info.indexOf("dropped") >= 0) break block2;
                throw pe;
            }
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.cachedResultSet_ = null;
        return this.callMethodRtnRaw("execute", new Class[]{String.class}, new Object[]{sql}).getReturnValueBoolean();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.cachedResultSet_ = null;
        return this.callMethodRtnRaw("execute", new Class[]{String.class, Integer.TYPE}, new Object[]{sql, autoGeneratedKeys}).getReturnValueBoolean();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.cachedResultSet_ = null;
        throw new SQLException(AS400JDBCDriver.getResource("JDIM001", null), EXC_FUNCTION_NOT_SUPPORTED, -99999);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.cachedResultSet_ = null;
        throw new SQLException(AS400JDBCDriver.getResource("JDIM001", null), EXC_FUNCTION_NOT_SUPPORTED, -99999);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.cachedResultSet_ = null;
        return (int[])this.callMethodRtnObj("executeBatch");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.cachedResultSet_ = null;
        try {
            JDResultSetProxy newResultSet = new JDResultSetProxy(this.jdConnection_, this);
            this.cachedResultSet_ = (JDResultSetProxy)this.connection_.callFactoryMethod(this.pxId_, "executeQuery", new Class[]{String.class}, new Object[]{sql}, newResultSet);
            return this.cachedResultSet_;
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.cachedResultSet_ = null;
        return this.callMethodRtnRaw("executeUpdate", new Class[]{String.class}, new Object[]{sql}).getReturnValueInt();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.cachedResultSet_ = null;
        return this.callMethodRtnRaw("executeUpdate", new Class[]{String.class, Integer.TYPE}, new Object[]{sql, autoGeneratedKeys}).getReturnValueInt();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.cachedResultSet_ = null;
        throw new SQLException(AS400JDBCDriver.getResource("JDIM001", null), EXC_FUNCTION_NOT_SUPPORTED, -99999);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.cachedResultSet_ = null;
        throw new SQLException(AS400JDBCDriver.getResource("JDIM001", null), EXC_FUNCTION_NOT_SUPPORTED, -99999);
    }

    @Override
    public Connection getConnection() {
        return this.jdConnection_;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.callMethodRtnInt("getFetchDirection");
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.callMethodRtnInt("getFetchSize");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.cachedResultSet_ = null;
        try {
            JDResultSetProxy newResultSet = new JDResultSetProxy(this.jdConnection_, this);
            this.cachedResultSet_ = (JDResultSetProxy)this.connection_.callFactoryMethod(this.pxId_, "getGeneratedKeys", newResultSet);
            return this.cachedResultSet_;
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.callMethodRtnInt("getMaxFieldSize");
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.callMethodRtnInt("getMaxRows");
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.cachedResultSet_ = null;
        return this.callMethodRtnBool("getMoreResults");
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.cachedResultSet_ = null;
        throw new SQLException(AS400JDBCDriver.getResource("JDIM001", null), EXC_FUNCTION_NOT_SUPPORTED, -99999);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.callMethodRtnInt("getQueryTimeout");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.cachedResultSet_ == null) {
            try {
                JDResultSetProxy newResultSet = new JDResultSetProxy(this.jdConnection_, this);
                this.cachedResultSet_ = (JDResultSetProxy)this.connection_.callFactoryMethod(this.pxId_, "getResultSet", newResultSet);
            }
            catch (InvocationTargetException e) {
                throw JDConnectionProxy.rethrow1(e);
            }
        }
        return this.cachedResultSet_;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.callMethodRtnInt("getResultSetConcurrency");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.callMethodRtnInt("getResultSetHoldability");
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.callMethodRtnInt("getResultSetType");
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.callMethodRtnInt("getUpdateCount");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return (SQLWarning)this.callMethodRtnObj("getWarnings");
    }

    @Override
    public void setCursorName(String cursorName) throws SQLException {
        this.cachedResultSet_ = null;
        this.callMethod("setCursorName", new Class[]{String.class}, new Object[]{cursorName});
    }

    @Override
    public void setEscapeProcessing(boolean escapeProcessing) throws SQLException {
        this.callMethod("setEscapeProcessing", new Class[]{Boolean.TYPE}, new Object[]{escapeProcessing});
    }

    @Override
    public void setFetchDirection(int fetchDirection) throws SQLException {
        this.callMethod("setFetchDirection", new Class[]{Integer.TYPE}, new Object[]{fetchDirection});
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.callMethod("setFetchSize", new Class[]{Integer.TYPE}, new Object[]{fetchSize});
    }

    @Override
    public void setMaxFieldSize(int maxFieldSize) throws SQLException {
        this.callMethod("setMaxFieldSize", new Class[]{Integer.TYPE}, new Object[]{maxFieldSize});
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        this.callMethod("setMaxRows", new Class[]{Integer.TYPE}, new Object[]{maxRows});
    }

    @Override
    public void setQueryTimeout(int queryTimeout) throws SQLException {
        this.callMethod("setQueryTimeout", new Class[]{Integer.TYPE}, new Object[]{queryTimeout});
    }

    public String toString() {
        try {
            return (String)this.connection_.callMethodReturnsObject(this.pxId_, "toString");
        }
        catch (InvocationTargetException e) {
            throw ProxyClientConnection.rethrow(e);
        }
    }

    @Override
    protected String[] getValidWrappedList() {
        return new String[]{"java.sql.Statement"};
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.callMethodRtnBool("isClosed");
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.callMethod("setPoolable", new Class[]{Boolean.TYPE}, new Object[]{poolable});
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.callMethodRtnBool("isPoolable");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.callMethod("closeOnCompletion");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.callMethodRtnBool("isCloseOnCompletion");
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return this.callMethodRtnLong("getLargeUpdateCount");
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.callMethod("setLargeMaxRows", new Class[]{Long.TYPE}, new Object[]{max});
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return this.callMethodRtnLong("getLargeMaxRows");
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return (long[])this.callMethodRtnObj("executeLargeBatch");
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.cachedResultSet_ = null;
        return this.callMethodRtnRaw("executeLargeUpdate", new Class[]{String.class}, new Object[]{sql}).getReturnValueLong();
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.cachedResultSet_ = null;
        return this.callMethodRtnRaw("executeLargeUpdate", new Class[]{String.class, Integer.TYPE}, new Object[]{sql, autoGeneratedKeys}).getReturnValueLong();
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.cachedResultSet_ = null;
        throw new SQLException(AS400JDBCDriver.getResource("JDIM001", null), EXC_FUNCTION_NOT_SUPPORTED, -99999);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.cachedResultSet_ = null;
        throw new SQLException(AS400JDBCDriver.getResource("JDIM001", null), EXC_FUNCTION_NOT_SUPPORTED, -99999);
    }
}

