/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.IFSDataStreamReq;

class IFSExchangeAttrReq
extends IFSDataStreamReq {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final int POSIX_PATTERN_MATCH = 0;
    static final int POSIX_ALL_PATTERN_MATCH = 1;
    static final int PC_PATTERN_MATCH = 2;
    private static final int DATA_STREAM_LEVEL_OFFSET = 22;
    private static final int FLAGS_OFFSET = 24;
    private static final int MAX_DATA_BLOCK_OFFSET = 26;
    private static final int CCSID_LL_OFFSET = 30;
    private static final int CCSID_CP_OFFSET = 34;
    private static final int CCSID_OFFSET = 36;
    private static final int HEADER_LENGTH = 20;
    private static final int TEMPLATE_LENGTH = 10;
    private static final int LL_CP_LENGTH = 6;
    private static final int CCSID_LENGTH = 2;
    private static final boolean DEBUG = false;

    IFSExchangeAttrReq(boolean useGMT, boolean usePosixReturnCodes, int patternMatchStyle, int maxDataBlock, int dataStreamLevel, int[] preferredCCSIDs) {
        super(36 + 2 * preferredCCSIDs.length);
        this.setLength(this.data_.length);
        this.setTemplateLen(10);
        this.setReqRepID(22);
        this.set16bit(dataStreamLevel, 22);
        int flags = 0;
        if (useGMT) {
            flags |= 4;
        }
        if (usePosixReturnCodes) {
            flags |= 8;
        }
        this.set16bit(flags |= patternMatchStyle, 24);
        this.set32bit(maxDataBlock, 26);
        this.set32bit(6 + 2 * preferredCCSIDs.length, 30);
        this.set16bit(10, 34);
        int i = 0;
        int offset = 36;
        while (i < preferredCCSIDs.length) {
            this.set16bit(preferredCCSIDs[i], offset);
            ++i;
            offset += 2;
        }
    }
}

