/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.DynamicContainerTestDescriptor;
import org.junit.jupiter.engine.descriptor.DynamicDescendantFilter;
import org.junit.jupiter.engine.descriptor.DynamicTestTestDescriptor;
import org.junit.jupiter.engine.descriptor.Filterable;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.descriptor.MethodSourceSupport;
import org.junit.jupiter.engine.descriptor.TestMethodTestDescriptor;
import org.junit.jupiter.engine.execution.InterceptingExecutableInvoker;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.ClasspathResourceSource;
import org.junit.platform.engine.support.descriptor.UriSource;
import org.junit.platform.engine.support.hierarchical.Node;

@API(status=API.Status.INTERNAL, since="5.0")
public class TestFactoryTestDescriptor
extends TestMethodTestDescriptor
implements Filterable {
    public static final String SEGMENT_TYPE = "test-factory";
    public static final String DYNAMIC_CONTAINER_SEGMENT_TYPE = "dynamic-container";
    public static final String DYNAMIC_TEST_SEGMENT_TYPE = "dynamic-test";
    private static final InterceptingExecutableInvoker.ReflectiveInterceptorCall<Method, Object> interceptorCall = InvocationInterceptor::interceptTestFactoryMethod;
    private static final InterceptingExecutableInvoker executableInvoker = new InterceptingExecutableInvoker();
    private final DynamicDescendantFilter dynamicDescendantFilter;

    public TestFactoryTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method testMethod, Supplier<List<Class<?>>> enclosingInstanceTypes, JupiterConfiguration configuration) {
        super(uniqueId, testClass, testMethod, enclosingInstanceTypes, configuration);
        this.dynamicDescendantFilter = new DynamicDescendantFilter();
    }

    private TestFactoryTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Method testMethod, JupiterConfiguration configuration, DynamicDescendantFilter dynamicDescendantFilter) {
        super(uniqueId, displayName, testClass, testMethod, configuration);
        this.dynamicDescendantFilter = dynamicDescendantFilter;
    }

    @Override
    protected TestFactoryTestDescriptor withUniqueId(UnaryOperator<UniqueId> uniqueIdTransformer) {
        return new TestFactoryTestDescriptor((UniqueId)uniqueIdTransformer.apply(this.getUniqueId()), this.getDisplayName(), this.getTestClass(), this.getTestMethod(), this.configuration, this.dynamicDescendantFilter.copy(uniqueIdTransformer));
    }

    @Override
    public DynamicDescendantFilter getDynamicDescendantFilter() {
        return this.dynamicDescendantFilter;
    }

    @Override
    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public boolean mayRegisterTests() {
        return true;
    }

    @Override
    protected void invokeTestMethod(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) {
        ExtensionContext extensionContext = context.getExtensionContext();
        context.getThrowableCollector().execute(() -> {
            Object instance = extensionContext.getRequiredTestInstance();
            Object testFactoryMethodResult = executableInvoker.invoke(this.getTestMethod(), instance, extensionContext, (ExtensionRegistry)context.getExtensionRegistry(), interceptorCall);
            TestSource defaultTestSource = (TestSource)this.getSource().orElseThrow(() -> new JUnitException("Illegal state: TestSource must be present"));
            try (Stream<DynamicNode> dynamicNodeStream = this.toDynamicNodeStream(testFactoryMethodResult);){
                int index = 1;
                Iterator iterator = dynamicNodeStream.iterator();
                while (iterator.hasNext()) {
                    DynamicNode dynamicNode = (DynamicNode)iterator.next();
                    Optional<JupiterTestDescriptor> descriptor = TestFactoryTestDescriptor.createDynamicDescriptor(this, dynamicNode, index, defaultTestSource, this.getDynamicDescendantFilter(), this.configuration);
                    descriptor.ifPresent(arg_0 -> ((Node.DynamicTestExecutor)dynamicTestExecutor).execute(arg_0));
                    ++index;
                }
            }
            catch (ClassCastException ex) {
                throw this.invalidReturnTypeException(ex);
            }
            dynamicTestExecutor.awaitFinished();
        });
    }

    private Stream<DynamicNode> toDynamicNodeStream(Object testFactoryMethodResult) {
        if (testFactoryMethodResult instanceof DynamicNode) {
            return Stream.of((DynamicNode)testFactoryMethodResult);
        }
        return CollectionUtils.toStream((Object)testFactoryMethodResult);
    }

    private JUnitException invalidReturnTypeException(Throwable cause) {
        String message = String.format("Objects produced by @TestFactory method '%s' must be of type %s.", this.getTestMethod().toGenericString(), DynamicNode.class.getName());
        return new JUnitException(message, cause);
    }

    static Optional<JupiterTestDescriptor> createDynamicDescriptor(JupiterTestDescriptor parent, DynamicNode node, int index, TestSource defaultTestSource, DynamicDescendantFilter dynamicDescendantFilter, JupiterConfiguration configuration) {
        Supplier<JupiterTestDescriptor> descriptorCreator;
        UniqueId uniqueId;
        Optional<TestSource> customTestSource = node.getTestSourceUri().map(TestFactoryTestDescriptor::fromUri);
        TestSource source = customTestSource.orElse(defaultTestSource);
        if (node instanceof DynamicTest) {
            DynamicTest test = (DynamicTest)node;
            uniqueId = parent.getUniqueId().append(DYNAMIC_TEST_SEGMENT_TYPE, "#" + index);
            descriptorCreator = () -> new DynamicTestTestDescriptor(uniqueId, index, test, source, configuration);
        } else {
            DynamicContainer container = (DynamicContainer)node;
            uniqueId = parent.getUniqueId().append(DYNAMIC_CONTAINER_SEGMENT_TYPE, "#" + index);
            descriptorCreator = () -> new DynamicContainerTestDescriptor(uniqueId, index, container, source, dynamicDescendantFilter.withoutIndexFiltering(), configuration);
        }
        if (dynamicDescendantFilter.test(uniqueId, index - 1)) {
            JupiterTestDescriptor descriptor = descriptorCreator.get();
            descriptor.setParent((TestDescriptor)parent);
            return Optional.of(descriptor);
        }
        return Optional.empty();
    }

    static TestSource fromUri(URI uri) {
        Preconditions.notNull((Object)uri, (String)"URI must not be null");
        if ("classpath".equals(uri.getScheme())) {
            return ClasspathResourceSource.from((URI)uri);
        }
        if ("class".equals(uri.getScheme())) {
            return ClassSource.from((URI)uri);
        }
        if ("method".equals(uri.getScheme())) {
            return MethodSourceSupport.from(uri);
        }
        return UriSource.from((URI)uri);
    }

    @Override
    public void nodeSkipped(JupiterEngineExecutionContext context, TestDescriptor descriptor, Node.SkipResult result) {
    }

    @Override
    public void nodeFinished(JupiterEngineExecutionContext context, TestDescriptor descriptor, TestExecutionResult result) {
    }
}

