/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.codec;

public final class Hex {
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    private Hex() {
    }

    public static char[] encode(byte[] bytes) {
        int nBytes = bytes.length;
        char[] result = new char[2 * nBytes];
        int j = 0;
        for (byte aByte : bytes) {
            result[j++] = HEX[(0xF0 & aByte) >>> 4];
            result[j++] = HEX[0xF & aByte];
        }
        return result;
    }

    public static byte[] decode(CharSequence s) {
        int nChars = s.length();
        if (nChars % 2 != 0) {
            throw new IllegalArgumentException("Hex-encoded string must have an even number of characters");
        }
        byte[] result = new byte[nChars / 2];
        for (int i2 = 0; i2 < nChars; i2 += 2) {
            int msb = Character.digit(s.charAt(i2), 16);
            int lsb = Character.digit(s.charAt(i2 + 1), 16);
            if (msb < 0 || lsb < 0) {
                throw new IllegalArgumentException("Detected a Non-hex character at " + (i2 + 1) + " or " + (i2 + 2) + " position");
            }
            result[i2 / 2] = (byte)(msb << 4 | lsb);
        }
        return result;
    }
}

