/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.ValueCodeGenerator;
import org.springframework.aot.generate.ValueCodeGeneratorDelegates;
import org.springframework.beans.factory.config.AutowiredPropertyMarker;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.javapoet.AnnotationSpec;
import org.springframework.javapoet.CodeBlock;
import org.springframework.lang.Nullable;

abstract class BeanDefinitionPropertyValueCodeGeneratorDelegates {
    public static final List<ValueCodeGenerator.Delegate> INSTANCES = List.of(new ManagedListDelegate(), new ManagedSetDelegate(), new ManagedMapDelegate(), new LinkedHashMapDelegate(), new BeanReferenceDelegate(), new TypedStringValueDelegate(), new AutowiredPropertyMarkerDelegate());

    BeanDefinitionPropertyValueCodeGeneratorDelegates() {
    }

    private static class ManagedListDelegate
    extends ValueCodeGeneratorDelegates.CollectionDelegate<ManagedList<?>> {
        public ManagedListDelegate() {
            super(ManagedList.class, CodeBlock.of("new $T()", ManagedList.class));
        }
    }

    private static class ManagedSetDelegate
    extends ValueCodeGeneratorDelegates.CollectionDelegate<ManagedSet<?>> {
        public ManagedSetDelegate() {
            super(ManagedSet.class, CodeBlock.of("new $T()", ManagedSet.class));
        }
    }

    private static class ManagedMapDelegate
    implements ValueCodeGenerator.Delegate {
        private static final CodeBlock EMPTY_RESULT = CodeBlock.of("$T.ofEntries()", ManagedMap.class);

        private ManagedMapDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(ValueCodeGenerator valueCodeGenerator, Object value) {
            if (value instanceof ManagedMap) {
                ManagedMap managedMap = (ManagedMap)value;
                return this.generateManagedMapCode(valueCodeGenerator, managedMap);
            }
            return null;
        }

        private <K, V> CodeBlock generateManagedMapCode(ValueCodeGenerator valueCodeGenerator, ManagedMap<K, V> managedMap) {
            if (managedMap.isEmpty()) {
                return EMPTY_RESULT;
            }
            CodeBlock.Builder code = CodeBlock.builder();
            code.add("$T.ofEntries(", ManagedMap.class);
            Iterator iterator = managedMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                code.add("$T.entry($L,$L)", Map.class, valueCodeGenerator.generateCode(entry.getKey()), valueCodeGenerator.generateCode(entry.getValue()));
                if (!iterator.hasNext()) continue;
                code.add(", ", new Object[0]);
            }
            code.add(")", new Object[0]);
            return code.build();
        }
    }

    private static class LinkedHashMapDelegate
    extends ValueCodeGeneratorDelegates.MapDelegate {
        private LinkedHashMapDelegate() {
        }

        @Override
        @Nullable
        protected CodeBlock generateMapCode(ValueCodeGenerator valueCodeGenerator, Map<?, ?> map) {
            GeneratedMethods generatedMethods = valueCodeGenerator.getGeneratedMethods();
            if (map instanceof LinkedHashMap && generatedMethods != null) {
                return this.generateLinkedHashMapCode(valueCodeGenerator, generatedMethods, map);
            }
            return super.generateMapCode(valueCodeGenerator, map);
        }

        private CodeBlock generateLinkedHashMapCode(ValueCodeGenerator valueCodeGenerator, GeneratedMethods generatedMethods, Map<?, ?> map) {
            GeneratedMethod generatedMethod = generatedMethods.add("getMap", method -> {
                method.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "{\"rawtypes\", \"unchecked\"}", new Object[0]).build());
                method.addModifiers(Modifier.PRIVATE, Modifier.STATIC);
                method.returns((Type)((Object)Map.class));
                method.addStatement("$T map = new $T($L)", Map.class, LinkedHashMap.class, map.size());
                map.forEach((key, value) -> method.addStatement("map.put($L, $L)", valueCodeGenerator.generateCode(key), valueCodeGenerator.generateCode(value)));
                method.addStatement("return map", new Object[0]);
            });
            return CodeBlock.of("$L()", generatedMethod.getName());
        }
    }

    private static class BeanReferenceDelegate
    implements ValueCodeGenerator.Delegate {
        private BeanReferenceDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(ValueCodeGenerator valueCodeGenerator, Object value) {
            RuntimeBeanReference runtimeBeanReference;
            if (value instanceof RuntimeBeanReference && (runtimeBeanReference = (RuntimeBeanReference)value).getBeanType() != null) {
                return CodeBlock.of("new $T($T.class)", RuntimeBeanReference.class, runtimeBeanReference.getBeanType());
            }
            if (value instanceof BeanReference) {
                BeanReference beanReference = (BeanReference)value;
                return CodeBlock.of("new $T($S)", RuntimeBeanReference.class, beanReference.getBeanName());
            }
            return null;
        }
    }

    private static class TypedStringValueDelegate
    implements ValueCodeGenerator.Delegate {
        private TypedStringValueDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(ValueCodeGenerator valueCodeGenerator, Object value) {
            if (value instanceof TypedStringValue) {
                TypedStringValue typedStringValue = (TypedStringValue)value;
                return this.generateTypeStringValueCode(valueCodeGenerator, typedStringValue);
            }
            return null;
        }

        private CodeBlock generateTypeStringValueCode(ValueCodeGenerator valueCodeGenerator, TypedStringValue typedStringValue) {
            String value = typedStringValue.getValue();
            if (typedStringValue.hasTargetType()) {
                return CodeBlock.of("new $T($S, $L)", TypedStringValue.class, value, valueCodeGenerator.generateCode(typedStringValue.getTargetType()));
            }
            return valueCodeGenerator.generateCode(value);
        }
    }

    private static class AutowiredPropertyMarkerDelegate
    implements ValueCodeGenerator.Delegate {
        private AutowiredPropertyMarkerDelegate() {
        }

        @Override
        @Nullable
        public CodeBlock generateCode(ValueCodeGenerator valueCodeGenerator, Object value) {
            if (value instanceof AutowiredPropertyMarker) {
                return CodeBlock.of("$T.INSTANCE", AutowiredPropertyMarker.class);
            }
            return null;
        }
    }
}

