/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker;

public class RenderingException
extends RuntimeException {
    private final int sourceLine;
    private final int sourcePosInLine;
    private final String templateName;
    private final String templatePath;

    public RenderingException(String message) {
        this(-1, -1, message, null);
    }

    public RenderingException(String message, Throwable cause) {
        this(-1, -1, message, cause);
    }

    public RenderingException(int sourceLine, int sourcePosInLine, String message, Throwable cause) {
        this(sourceLine, sourcePosInLine, null, null, message, cause);
    }

    public RenderingException(int sourceLine, int sourcePosInLine, String templateName, String templatePath, String message, Throwable cause) {
        super(RenderingException.buildMessage(sourceLine, sourcePosInLine, templateName, templatePath, message, cause), cause);
        this.sourceLine = sourceLine;
        this.sourcePosInLine = sourcePosInLine;
        this.templateName = templateName;
        this.templatePath = templatePath;
    }

    private static String buildMessage(int sourceLine, int sourcePosInLine, String templateName, String templatePath, String message, Throwable cause) {
        StringBuilder s = new StringBuilder();
        if (templatePath != null) {
            s.append(templatePath);
            s.append("/");
        }
        if (templateName != null) {
            s.append(templateName);
        }
        if (sourceLine >= 0) {
            s.append(" [line ");
            s.append(sourceLine);
            s.append(":");
            s.append(sourcePosInLine);
            s.append("]");
        }
        if (templateName != null) {
            s.append(": ");
        }
        if (message != null) {
            s.append(message);
        } else if (cause != null) {
            s.append(cause.getClass().getSimpleName());
            s.append(" in render");
        }
        return s.toString();
    }

    public int getSourceLine() {
        return this.sourceLine;
    }

    public int getSourcePosInLine() {
        return this.sourcePosInLine;
    }

    public boolean hasSourceInfo() {
        return this.sourceLine >= 0;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }
}

