/*
 * Decompiled with CFR 0.152.
 */
package org.grails.spring.context.support;

import grails.config.Config;
import grails.core.support.GrailsConfigurationAware;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionVisitor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.util.StringValueResolver;

public class GrailsPlaceholderConfigurer
extends PropertySourcesPlaceholderConfigurer
implements GrailsConfigurationAware {
    private Properties properties;
    private String beanName;
    private BeanFactory beanFactory;
    private Config config;

    public GrailsPlaceholderConfigurer(String placeHolderPrefix, Properties properties) {
        this.properties = properties;
        this.setPlaceholderPrefix(placeHolderPrefix);
        this.setIgnoreUnresolvablePlaceholders(true);
    }

    public GrailsPlaceholderConfigurer() {
        this.setIgnoreUnresolvablePlaceholders(true);
    }

    @Override
    protected void loadProperties(Properties props) throws IOException {
        if (this.config != null) {
            props.putAll((Map<?, ?>)this.config.toProperties());
        } else if (this.properties != null) {
            props.putAll((Map<?, ?>)this.properties);
        }
        this.properties = props;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setBeanName(String beanName) {
        super.setBeanName(beanName);
        this.beanName = beanName;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        this.beanFactory = beanFactory;
    }

    @Override
    protected void doProcessProperties(ConfigurableListableBeanFactory beanFactoryToProcess, StringValueResolver valueResolver) {
        String[] beanNames;
        BeanDefinitionVisitor visitor = new BeanDefinitionVisitor(valueResolver){

            @Override
            protected void visitMap(Map<?, ?> mapVal) {
                if (mapVal instanceof Config) {
                    return;
                }
                super.visitMap(mapVal);
            }
        };
        for (String curName : beanNames = beanFactoryToProcess.getBeanDefinitionNames()) {
            if (curName.equals(this.beanName) && beanFactoryToProcess.equals(this.beanFactory)) continue;
            BeanDefinition bd = beanFactoryToProcess.getBeanDefinition(curName);
            try {
                visitor.visitBeanDefinition(bd);
            }
            catch (Exception ex) {
                throw new BeanDefinitionStoreException(bd.getResourceDescription(), curName, ex.getMessage(), ex);
            }
        }
        beanFactoryToProcess.resolveAliases(valueResolver);
        beanFactoryToProcess.addEmbeddedValueResolver(valueResolver);
    }

    @Override
    public void setConfiguration(Config co) {
        this.config = co;
    }
}

