/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.transactions.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractAttributeStoringSession
implements Session {
    protected Map<Integer, Map<String, Object>> attributes = new ConcurrentHashMap<Integer, Map<String, Object>>();
    protected Map<String, Object> sessionPropertyMap = new ConcurrentHashMap<String, Object>();
    private boolean connected = true;

    @Override
    public void setAttribute(Object entity, String attributeName, Object value) {
        if (entity == null) {
            return;
        }
        int id = System.identityHashCode(entity);
        Map<String, Object> attrs = this.attributes.get(id);
        if (attrs == null) {
            attrs = new ConcurrentHashMap<String, Object>();
            this.attributes.put(id, attrs);
        }
        if (attributeName != null && value != null) {
            attrs.put(attributeName, value);
        }
        if (attributeName != null && value == null) {
            attrs.remove(attributeName);
        }
    }

    @Override
    public Object getAttribute(Object entity, String attributeName) {
        if (entity == null) {
            return null;
        }
        Map<String, Object> attrs = this.attributes.get(System.identityHashCode(entity));
        if (attrs == null || attributeName == null) {
            return null;
        }
        return attrs.get(attributeName);
    }

    protected void removeAttributesForEntity(Object entity) {
        if (entity == null) {
            return;
        }
        this.attributes.remove(System.identityHashCode(entity));
    }

    @Override
    public Object setSessionProperty(String property, Object value) {
        return this.sessionPropertyMap.put(property, value);
    }

    @Override
    public Object getSessionProperty(String property) {
        return this.sessionPropertyMap.get(property);
    }

    @Override
    public Object clearSessionProperty(String property) {
        return this.sessionPropertyMap.remove(property);
    }

    @Override
    public void disconnect() {
        this.connected = false;
        try {
            this.clear();
            this.attributes.clear();
        }
        finally {
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(this.getDatastore());
            if (sessionHolder != null) {
                sessionHolder.removeSession(this);
                if (sessionHolder.isEmpty()) {
                    try {
                        TransactionSynchronizationManager.unbindResource(this.getDatastore());
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }
}

