/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.context.env.DefaultPropertyPlaceholderResolver;
import io.micronaut.context.env.PropertyPlaceholderResolver;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.io.socket.SocketUtils;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.optim.StaticOptimizations;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.EnvironmentProperties;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.MapPropertyResolver;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.core.value.ValueException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

public class PropertySourcePropertyResolver
implements PropertyResolver,
AutoCloseable {
    private static final EnvironmentProperties CURRENT_ENV = StaticOptimizations.get(EnvironmentProperties.class).orElseGet(EnvironmentProperties::empty);
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    private static final String RANDOM_PREFIX = "\\s?random\\.(\\S+?)";
    private static final String RANDOM_UPPER_LIMIT = "(\\(-?\\d+(\\.\\d+)?\\))";
    private static final String RANDOM_RANGE = "(\\[-?\\d+(\\.\\d+)?,\\s?-?\\d+(\\.\\d+)?])";
    private static final Pattern RANDOM_PATTERN = Pattern.compile("\\$\\{\\s?random\\.(\\S+?)((\\(-?\\d+(\\.\\d+)?\\))|(\\[-?\\d+(\\.\\d+)?,\\s?-?\\d+(\\.\\d+)?]))?\\}");
    private static final Object NO_VALUE = new Object();
    private static final PropertyCatalog[] CONVENTIONS = new PropertyCatalog[]{PropertyCatalog.GENERATED, PropertyCatalog.RAW};
    protected final ConversionService<?> conversionService;
    protected final PropertyPlaceholderResolver propertyPlaceholderResolver;
    protected final Map<String, PropertySource> propertySources = new ConcurrentHashMap<String, PropertySource>(10);
    protected final Map<String, Object>[] catalog = new Map[58];
    protected final Map<String, Object>[] rawCatalog = new Map[58];
    protected final Map<String, Object>[] nonGenerated = new Map[58];
    protected Logger log;
    private final SecureRandom random = new SecureRandom();
    private final Map<String, Boolean> containsCache = new ConcurrentHashMap<String, Boolean>(20);
    private final Map<String, Object> resolvedValueCache = new ConcurrentHashMap<String, Object>(20);
    private final EnvironmentProperties environmentProperties = EnvironmentProperties.fork(CURRENT_ENV);

    public PropertySourcePropertyResolver(ConversionService<?> conversionService, boolean logEnabled) {
        this.log = logEnabled ? LoggerFactory.getLogger(this.getClass()) : NOPLogger.NOP_LOGGER;
        this.conversionService = conversionService;
        this.propertyPlaceholderResolver = new DefaultPropertyPlaceholderResolver(this, conversionService);
    }

    public PropertySourcePropertyResolver(ConversionService<?> conversionService) {
        this(conversionService, true);
    }

    public PropertySourcePropertyResolver() {
        this(ConversionService.SHARED);
    }

    public PropertySourcePropertyResolver(PropertySource ... propertySources) {
        this(ConversionService.SHARED);
        if (propertySources != null) {
            for (PropertySource propertySource : propertySources) {
                this.addPropertySource(propertySource);
            }
        }
    }

    public PropertySourcePropertyResolver addPropertySource(@Nullable PropertySource propertySource) {
        if (propertySource != null) {
            this.processPropertySource(propertySource, propertySource.getConvention());
        }
        return this;
    }

    public PropertySourcePropertyResolver addPropertySource(String name, @Nullable Map<String, ? super Object> values) {
        if (CollectionUtils.isNotEmpty(values)) {
            return this.addPropertySource(PropertySource.of(name, values));
        }
        return this;
    }

    @Override
    public boolean containsProperty(@Nullable String name) {
        if (StringUtils.isEmpty(name)) {
            return false;
        }
        Boolean result = this.containsCache.get(name);
        if (result == null) {
            for (PropertyCatalog convention : CONVENTIONS) {
                Map<String, Object> entries = this.resolveEntriesForKey(name, false, convention);
                if (entries == null || !entries.containsKey(name)) continue;
                result = true;
                break;
            }
            if (result == null) {
                result = false;
            }
            this.containsCache.put(name, result);
        }
        return result;
    }

    @Override
    public boolean containsProperties(@Nullable String name) {
        if (!StringUtils.isEmpty(name)) {
            for (PropertyCatalog propertyCatalog : CONVENTIONS) {
                Map<String, Object> entries = this.resolveEntriesForKey(name, false, propertyCatalog);
                if (entries == null) continue;
                if (entries.containsKey(name)) {
                    return true;
                }
                String finalName = name + ".";
                for (String key : entries.keySet()) {
                    if (!key.startsWith(finalName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    @NonNull
    public Collection<String> getPropertyEntries(@NonNull String name) {
        Map<String, Object> entries;
        if (!StringUtils.isEmpty(name) && (entries = this.resolveEntriesForKey(name, false, PropertyCatalog.NORMALIZED)) != null) {
            String prefix = name + '.';
            return entries.keySet().stream().filter(k -> k.startsWith(prefix)).map(k -> {
                String withoutPrefix = k.substring(prefix.length());
                int i2 = withoutPrefix.indexOf(46);
                if (i2 > -1) {
                    return withoutPrefix.substring(0, i2);
                }
                return withoutPrefix;
            }).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    @NonNull
    public Map<String, Object> getProperties(String name, StringConvention keyFormat) {
        if (!StringUtils.isEmpty(name)) {
            Map<String, Object> entries = this.resolveEntriesForKey(name, false, keyFormat == StringConvention.RAW ? PropertyCatalog.RAW : PropertyCatalog.GENERATED);
            if (entries != null) {
                if (keyFormat == null) {
                    keyFormat = StringConvention.RAW;
                }
                return this.resolveSubMap(name, entries, ConversionContext.MAP, keyFormat, MapFormat.MapTransformation.FLAT);
            }
            entries = this.resolveEntriesForKey(name, false, PropertyCatalog.GENERATED);
            if (keyFormat == null) {
                keyFormat = StringConvention.RAW;
            }
            if (entries == null) {
                return Collections.emptyMap();
            }
            return this.resolveSubMap(name, entries, ConversionContext.MAP, keyFormat, MapFormat.MapTransformation.FLAT);
        }
        return Collections.emptyMap();
    }

    @Override
    public <T> Optional<T> getProperty(@NonNull String name, @NonNull ArgumentConversionContext<T> conversionContext) {
        Object cached;
        if (StringUtils.isEmpty(name)) {
            return Optional.empty();
        }
        Objects.requireNonNull(conversionContext, "Conversion context should not be null");
        Class requiredType = conversionContext.getArgument().getType();
        boolean cacheableType = ClassUtils.isJavaLangType(requiredType);
        Object object = cached = cacheableType ? this.resolvedValueCache.get(this.cacheKey(name, requiredType)) : null;
        if (cached != null) {
            return cached == NO_VALUE ? Optional.empty() : Optional.of(cached);
        }
        Map<String, Object> entries = this.resolveEntriesForKey(name, false, PropertyCatalog.GENERATED);
        if (entries == null) {
            entries = this.resolveEntriesForKey(name, false, PropertyCatalog.RAW);
        }
        if (entries != null) {
            Map<String, Object> subMap;
            int i2;
            Object value = entries.get(name);
            if (value == null && (value = entries.get(this.normalizeName(name))) == null && name.indexOf(91) == -1) {
                Map<String, Object> rawEntries = this.resolveEntriesForKey(name, false, PropertyCatalog.RAW);
                Object object2 = value = rawEntries != null ? rawEntries.get(name) : null;
                if (value != null) {
                    entries = rawEntries;
                }
            }
            if (value == null && (i2 = name.indexOf(91)) > -1 && name.endsWith("]")) {
                String newKey = name.substring(0, i2);
                value = entries.get(newKey);
                String index2 = name.substring(i2 + 1, name.length() - 1);
                if (value != null) {
                    if (StringUtils.isNotEmpty(index2)) {
                        if (value instanceof List) {
                            try {
                                value = ((List)value).get(Integer.valueOf(index2));
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else if (value instanceof Map) {
                            try {
                                value = ((Map)value).get(index2);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    }
                } else if (StringUtils.isNotEmpty(index2)) {
                    String subKey = newKey + '.' + index2;
                    value = entries.get(subKey);
                }
            }
            if (value != null) {
                Optional<Object> converted = requiredType.isInstance(value = this.resolvePlaceHoldersIfNecessary(value)) && !CollectionUtils.isIterableOrMap(requiredType) ? Optional.of(value) : this.conversionService.convert(value, conversionContext);
                if (this.log.isTraceEnabled()) {
                    if (converted.isPresent()) {
                        this.log.trace("Resolved value [{}] for property: {}", converted.get(), (Object)name);
                    } else {
                        this.log.trace("Resolved value [{}] cannot be converted to type [{}] for property: {}", value, conversionContext.getArgument(), name);
                    }
                }
                if (cacheableType) {
                    this.resolvedValueCache.put(this.cacheKey(name, requiredType), converted.orElse(NO_VALUE));
                }
                return converted;
            }
            if (cacheableType) {
                this.resolvedValueCache.put(this.cacheKey(name, requiredType), NO_VALUE);
                return Optional.empty();
            }
            if (Properties.class.isAssignableFrom(requiredType)) {
                Properties properties = this.resolveSubProperties(name, entries, conversionContext);
                return Optional.of(properties);
            }
            if (Map.class.isAssignableFrom(requiredType)) {
                subMap = this.resolveSubMap(name, entries, conversionContext);
                if (!subMap.isEmpty()) {
                    return this.conversionService.convert(subMap, requiredType, conversionContext);
                }
                return Optional.of(subMap);
            }
            if (PropertyResolver.class.isAssignableFrom(requiredType)) {
                subMap = this.resolveSubMap(name, entries, conversionContext);
                return Optional.of(new MapPropertyResolver(subMap, this.conversionService));
            }
        }
        this.log.trace("No value found for property: {}", (Object)name);
        requiredType = conversionContext.getArgument().getType();
        if (Properties.class.isAssignableFrom(requiredType)) {
            return Optional.of(new Properties());
        }
        if (Map.class.isAssignableFrom(requiredType)) {
            return Optional.of(Collections.emptyMap());
        }
        return Optional.empty();
    }

    @NonNull
    private <T> String cacheKey(@NonNull String name, Class<T> requiredType) {
        return name + '|' + requiredType.getSimpleName();
    }

    public Map<String, Object> getAllProperties(StringConvention keyConvention, MapFormat.MapTransformation transformation) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isNested = transformation == MapFormat.MapTransformation.NESTED;
        Arrays.stream(this.getCatalog(keyConvention == StringConvention.RAW ? PropertyCatalog.RAW : PropertyCatalog.GENERATED)).filter(Objects::nonNull).map(Map::entrySet).flatMap(Collection::stream).forEach(entry -> {
            String k = keyConvention.format((String)entry.getKey());
            Object value = this.resolvePlaceHoldersIfNecessary(entry.getValue());
            Map finalMap = map;
            int index2 = k.indexOf(46);
            if (index2 != -1 && isNested) {
                String[] keys = DOT_PATTERN.split(k);
                for (int i2 = 0; i2 < keys.length - 1; ++i2) {
                    Object next;
                    if (!finalMap.containsKey(keys[i2])) {
                        finalMap.put(keys[i2], new HashMap());
                    }
                    if (!((next = finalMap.get(keys[i2])) instanceof Map)) continue;
                    finalMap = (Map)next;
                }
                finalMap.put(keys[keys.length - 1], value);
            } else {
                finalMap.put(k, value);
            }
        });
        return map;
    }

    protected Properties resolveSubProperties(String name, Map<String, Object> entries, ArgumentConversionContext<?> conversionContext) {
        Properties properties = new Properties();
        AnnotationMetadata annotationMetadata = conversionContext.getAnnotationMetadata();
        StringConvention keyConvention = annotationMetadata.enumValue(MapFormat.class, "keyFormat", StringConvention.class).orElse(null);
        if (keyConvention == StringConvention.RAW) {
            entries = this.resolveEntriesForKey(name, false, PropertyCatalog.RAW);
        }
        String prefix = name + '.';
        entries.entrySet().stream().filter(map -> ((String)map.getKey()).startsWith(prefix)).forEach(entry -> {
            Object value = entry.getValue();
            if (value != null) {
                String key = ((String)entry.getKey()).substring(prefix.length());
                key = keyConvention != null ? keyConvention.format(key) : key;
                properties.put(key, this.resolvePlaceHoldersIfNecessary(value.toString()));
            }
        });
        return properties;
    }

    protected Map<String, Object> resolveSubMap(String name, Map<String, Object> entries, ArgumentConversionContext<?> conversionContext) {
        AnnotationMetadata annotationMetadata = conversionContext.getAnnotationMetadata();
        StringConvention keyConvention = annotationMetadata.enumValue(MapFormat.class, "keyFormat", StringConvention.class).orElse(null);
        if (keyConvention == StringConvention.RAW) {
            entries = this.resolveEntriesForKey(name, false, PropertyCatalog.RAW);
        }
        MapFormat.MapTransformation transformation = annotationMetadata.enumValue(MapFormat.class, "transformation", MapFormat.MapTransformation.class).orElse(MapFormat.MapTransformation.NESTED);
        return this.resolveSubMap(name, entries, conversionContext, keyConvention, transformation);
    }

    @NonNull
    protected Map<String, Object> resolveSubMap(String name, Map<String, Object> entries, ArgumentConversionContext<?> conversionContext, @Nullable StringConvention keyConvention, MapFormat.MapTransformation transformation) {
        Argument<Object> valueType = conversionContext.getTypeVariable("V").orElse(Argument.OBJECT_ARGUMENT);
        boolean valueTypeIsList = List.class.isAssignableFrom(valueType.getType());
        LinkedHashMap<String, Object> subMap = new LinkedHashMap<String, Object>(entries.size());
        String prefix = name + '.';
        for (Map.Entry<String, Object> entry : entries.entrySet()) {
            String key = entry.getKey();
            if (valueTypeIsList && key.contains("[") && key.endsWith("]") || !key.startsWith(prefix)) continue;
            String subMapKey = key.substring(prefix.length());
            Object value = this.resolvePlaceHoldersIfNecessary(entry.getValue());
            if (transformation == MapFormat.MapTransformation.FLAT) {
                subMapKey = keyConvention != null ? keyConvention.format(subMapKey) : subMapKey;
                value = this.conversionService.convert(value, valueType).orElse(null);
                subMap.put(subMapKey, value);
                continue;
            }
            this.processSubmapKey(subMap, subMapKey, value, keyConvention);
        }
        return subMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPropertySource(PropertySource properties, PropertySource.PropertyConvention convention) {
        this.propertySources.put(properties.getName(), properties);
        Map<String, Object>[] mapArray = this.catalog;
        synchronized (this.catalog) {
            for (String property : properties) {
                Object newValue;
                this.log.trace("Processing property key {}", (Object)property);
                Object value = properties.get(property);
                if (value instanceof CharSequence) {
                    value = this.processRandomExpressions(convention, property, (CharSequence)value);
                } else if (value instanceof List) {
                    ListIterator<Object> i2 = ((List)value).listIterator();
                    while (i2.hasNext()) {
                        Object o = i2.next();
                        if (!(o instanceof CharSequence) || (newValue = this.processRandomExpressions(convention, property, (CharSequence)o)) == o) continue;
                        i2.set(newValue);
                    }
                }
                List<String> resolvedProperties = this.resolvePropertiesForConvention(property, convention);
                boolean first = true;
                newValue = resolvedProperties.iterator();
                while (newValue.hasNext()) {
                    String resolvedProperty = newValue.next();
                    int i3 = resolvedProperty.indexOf(91);
                    if (i3 > -1) {
                        String propertyName = resolvedProperty.substring(0, i3);
                        Map<String, Object> entries = this.resolveEntriesForKey(propertyName, true, PropertyCatalog.GENERATED);
                        if (entries != null) {
                            entries.put(resolvedProperty, value);
                            this.expandProperty(resolvedProperty.substring(i3), val -> entries.put(propertyName, val), () -> entries.get(propertyName), value);
                        }
                        if (!first) continue;
                        Map<String, Object> normalized = this.resolveEntriesForKey(resolvedProperty, true, PropertyCatalog.NORMALIZED);
                        if (normalized != null) {
                            normalized.put(propertyName, value);
                        }
                        first = false;
                        continue;
                    }
                    Map<String, Object> entries = this.resolveEntriesForKey(resolvedProperty, true, PropertyCatalog.GENERATED);
                    if (entries != null) {
                        if (value instanceof List || value instanceof Map) {
                            this.collapseProperty(resolvedProperty, entries, value);
                        }
                        entries.put(resolvedProperty, value);
                    }
                    if (!first) continue;
                    Map<String, Object> normalized = this.resolveEntriesForKey(resolvedProperty, true, PropertyCatalog.NORMALIZED);
                    if (normalized != null) {
                        normalized.put(resolvedProperty, value);
                    }
                    first = false;
                }
                Map<String, Object> rawEntries = this.resolveEntriesForKey(property, true, PropertyCatalog.RAW);
                if (rawEntries == null) continue;
                rawEntries.put(property, value);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void expandProperty(String property, Consumer<Object> containerSet, Supplier<Object> containerGet, Object actualValue) {
        if (StringUtils.isEmpty(property)) {
            containerSet.accept(actualValue);
            return;
        }
        int i2 = property.indexOf(91);
        int li = property.indexOf(93);
        if (i2 == 0 && li > -1) {
            String propertyIndex = property.substring(1, li);
            String propertyRest = property.substring(li + 1);
            Object container = containerGet.get();
            if (StringUtils.isDigits(propertyIndex)) {
                ArrayList list;
                Integer number = Integer.valueOf(propertyIndex);
                if (container instanceof List) {
                    list = (ArrayList)container;
                } else {
                    list = new ArrayList(10);
                    containerSet.accept(list);
                }
                this.fill(list, number, null);
                this.expandProperty(propertyRest, val -> list.set(number, val), () -> list.get(number), actualValue);
            } else {
                LinkedHashMap map;
                if (container instanceof Map) {
                    map = (LinkedHashMap)container;
                } else {
                    map = new LinkedHashMap(10);
                    containerSet.accept(map);
                }
                this.expandProperty(propertyRest, val -> map.put(propertyIndex, val), () -> map.get(propertyIndex), actualValue);
            }
        } else if (property.startsWith(".")) {
            LinkedHashMap map;
            String propertyRest;
            String propertyName;
            if (i2 > -1) {
                propertyName = property.substring(1, i2);
                propertyRest = property.substring(i2);
            } else {
                propertyName = property.substring(1);
                propertyRest = "";
            }
            Object v = containerGet.get();
            if (v instanceof Map) {
                map = (LinkedHashMap)v;
            } else {
                map = new LinkedHashMap(10);
                containerSet.accept(map);
            }
            this.expandProperty(propertyRest, val -> map.put(propertyName, val), () -> map.get(propertyName), actualValue);
        }
    }

    private void collapseProperty(String prefix, Map<String, Object> entries, Object value) {
        if (value instanceof List) {
            for (int i2 = 0; i2 < ((List)value).size(); ++i2) {
                Object item = ((List)value).get(i2);
                if (item == null) continue;
                this.collapseProperty(prefix + "[" + i2 + "]", entries, item);
            }
            entries.put(prefix, value);
        } else if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                Object key = entry.getKey();
                if (!(key instanceof CharSequence)) continue;
                this.collapseProperty(prefix + "." + ((CharSequence)key).toString(), entries, entry.getValue());
            }
        } else {
            entries.put(prefix, value);
        }
    }

    private CharSequence processRandomExpressions(PropertySource.PropertyConvention convention, String property, CharSequence str) {
        if (convention != PropertySource.PropertyConvention.ENVIRONMENT_VARIABLE && str.toString().contains(this.propertyPlaceholderResolver.getPrefix())) {
            StringBuffer newValue = new StringBuffer();
            Matcher matcher = RANDOM_PATTERN.matcher(str);
            boolean hasRandoms = false;
            while (matcher.find()) {
                String randomValue;
                hasRandoms = true;
                String type = matcher.group(1).trim().toLowerCase();
                String range = matcher.group(2);
                if (range != null) {
                    range = range.substring(1, range.length() - 1);
                }
                switch (type) {
                    case "port": {
                        randomValue = String.valueOf(SocketUtils.findAvailableTcpPort());
                        break;
                    }
                    case "int": 
                    case "integer": {
                        randomValue = String.valueOf(range == null ? this.random.nextInt() : this.getNextIntegerInRange(range, property));
                        break;
                    }
                    case "long": {
                        randomValue = String.valueOf(range == null ? this.random.nextLong() : this.getNextLongInRange(range, property));
                        break;
                    }
                    case "float": {
                        randomValue = String.valueOf(range == null ? this.random.nextFloat() : this.getNextFloatInRange(range, property));
                        break;
                    }
                    case "shortuuid": {
                        randomValue = UUID.randomUUID().toString().substring(25, 35);
                        break;
                    }
                    case "uuid": {
                        randomValue = UUID.randomUUID().toString();
                        break;
                    }
                    case "uuid2": {
                        randomValue = UUID.randomUUID().toString().replace("-", "");
                        break;
                    }
                    default: {
                        throw new ConfigurationException("Invalid random expression " + matcher.group(0) + " for property: " + property);
                    }
                }
                matcher.appendReplacement(newValue, randomValue);
            }
            if (hasRandoms) {
                matcher.appendTail(newValue);
                return newValue.toString();
            }
        }
        return str;
    }

    protected Map<String, Object> resolveEntriesForKey(String name, boolean allowCreate) {
        return this.resolveEntriesForKey(name, allowCreate, null);
    }

    protected Map<String, Object> resolveEntriesForKey(String name, boolean allowCreate, @Nullable PropertyCatalog propertyCatalog) {
        int index2;
        if (name.length() == 0) {
            return null;
        }
        Map<String, Object>[] catalog = this.getCatalog(propertyCatalog);
        Map<String, Object> entries = null;
        char firstChar = name.charAt(0);
        if (Character.isLetter(firstChar) && (index2 = firstChar - 65) < catalog.length && index2 >= 0) {
            entries = catalog[index2];
            if (allowCreate && entries == null) {
                catalog[index2] = entries = new LinkedHashMap<String, Object>(5);
            }
        }
        return entries;
    }

    private Map<String, Object>[] getCatalog(@Nullable PropertyCatalog propertyCatalog) {
        Map<String, Object>[] catalog;
        propertyCatalog = propertyCatalog != null ? propertyCatalog : PropertyCatalog.GENERATED;
        switch (propertyCatalog) {
            case RAW: {
                catalog = this.rawCatalog;
                break;
            }
            case NORMALIZED: {
                catalog = this.nonGenerated;
                break;
            }
            default: {
                catalog = this.catalog;
            }
        }
        return catalog;
    }

    protected void resetCaches() {
        this.containsCache.clear();
        this.resolvedValueCache.clear();
    }

    private void processSubmapKey(Map<String, Object> map, String key, Object value, @Nullable StringConvention keyConvention) {
        boolean hasKeyConvention;
        int index2 = key.indexOf(46);
        boolean bl = hasKeyConvention = keyConvention != null;
        if (index2 == -1) {
            key = hasKeyConvention ? keyConvention.format(key) : key;
            map.put(key, value);
        } else {
            Object v;
            String mapKey = key.substring(0, index2);
            String string = mapKey = hasKeyConvention ? keyConvention.format(mapKey) : mapKey;
            if (!map.containsKey(mapKey)) {
                map.put(mapKey, new LinkedHashMap());
            }
            if ((v = map.get(mapKey)) instanceof Map) {
                Map nestedMap = (Map)v;
                String nestedKey = key.substring(index2 + 1);
                this.processSubmapKey(nestedMap, nestedKey, value, keyConvention);
            } else {
                map.put(mapKey, v);
            }
        }
    }

    private String normalizeName(String name) {
        return name.replace('-', '.');
    }

    private Object resolvePlaceHoldersIfNecessary(Object value) {
        if (value instanceof CharSequence) {
            return this.propertyPlaceholderResolver.resolveRequiredPlaceholders(((Object)value).toString());
        }
        if (value instanceof List) {
            List list = value;
            ArrayList newList = new ArrayList(list);
            ListIterator<Object> i2 = newList.listIterator();
            while (i2.hasNext()) {
                Object o = i2.next();
                if (o instanceof CharSequence) {
                    i2.set(this.resolvePlaceHoldersIfNecessary(o));
                    continue;
                }
                if (!(o instanceof Map)) continue;
                Map submap = (Map)o;
                LinkedHashMap newMap = new LinkedHashMap(submap.size());
                for (Map.Entry entry : submap.entrySet()) {
                    Object k = entry.getKey();
                    Object v = entry.getValue();
                    newMap.put(k, this.resolvePlaceHoldersIfNecessary(v));
                }
                i2.set(newMap);
            }
            value = newList;
        }
        return value;
    }

    private List<String> resolvePropertiesForConvention(String property, PropertySource.PropertyConvention convention) {
        if (convention == PropertySource.PropertyConvention.ENVIRONMENT_VARIABLE) {
            return this.environmentProperties.findPropertyNamesForEnvironmentVariable(property);
        }
        return Collections.singletonList(NameUtils.hyphenate(property, true));
    }

    private void fill(List list, Integer toIndex, Object value) {
        if (toIndex >= list.size()) {
            for (int i2 = list.size(); i2 <= toIndex; ++i2) {
                list.add(i2, value);
            }
        }
    }

    private int getNextIntegerInRange(String range, String property) {
        try {
            String[] tokens = range.split(",");
            int lowerBound = Integer.parseInt(tokens[0]);
            if (tokens.length == 1) {
                return lowerBound >= 0 ? 1 : -1 * this.random.nextInt(Math.abs(lowerBound));
            }
            int upperBound = Integer.parseInt(tokens[1]);
            return lowerBound + (int)(Math.random() * (double)(upperBound - lowerBound));
        }
        catch (NumberFormatException ex) {
            throw new ValueException("Invalid range: `" + range + "` found for type Integer while parsing property: " + property, ex);
        }
    }

    private long getNextLongInRange(String range, String property) {
        try {
            String[] tokens = range.split(",");
            long lowerBound = Long.parseLong(tokens[0]);
            if (tokens.length == 1) {
                return (long)(Math.random() * (double)lowerBound);
            }
            long upperBound = Long.parseLong(tokens[1]);
            return lowerBound + (long)(Math.random() * (double)(upperBound - lowerBound));
        }
        catch (NumberFormatException ex) {
            throw new ValueException("Invalid range: `" + range + "` found for type Long while parsing property: " + property, ex);
        }
    }

    private float getNextFloatInRange(String range, String property) {
        try {
            String[] tokens = range.split(",");
            float lowerBound = Float.parseFloat(tokens[0]);
            if (tokens.length == 1) {
                return (float)(Math.random() * (double)lowerBound);
            }
            float upperBound = Float.parseFloat(tokens[1]);
            return lowerBound + (float)(Math.random() * (double)(upperBound - lowerBound));
        }
        catch (NumberFormatException ex) {
            throw new ValueException("Invalid range: `" + range + "` found for type Float while parsing property: " + property, ex);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.propertyPlaceholderResolver instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.propertyPlaceholderResolver)).close();
        }
    }

    @Deprecated
    public boolean isLogEnabled() {
        return !(this.log instanceof NOPLogger);
    }

    @Deprecated
    public void setLogEnabled(boolean logEnabled) {
        this.log = logEnabled ? LoggerFactory.getLogger(this.getClass()) : NOPLogger.NOP_LOGGER;
    }

    protected static enum PropertyCatalog {
        RAW,
        NORMALIZED,
        GENERATED;

    }
}

