/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.time.LocalDateTime
import java.time.ZoneId
import java.util.zip.ZipEntry
import java.util.zip.ZipFile


String manifest = new File( basedir, "target/classes/META-INF/MANIFEST.MF" ).text;

assert !manifest.contains( "Build-Jdk:" )
assert manifest.contains( "Build-Jdk-Spec:" )

assert !manifest.contains( "Build-By:" )

assert !manifest.contains( "Bnd-LastModified:" )


Enumeration<? extends ZipEntry> bundleEntries = new ZipFile(new File( basedir, "target/reproducible-1-SNAPSHOT.jar" )).entries()

// ZipEntry::getTime() interprets the time information in the local timezone.
long expectedTime = LocalDateTime.of(2000, 1, 1, 0, 0, 0).atZone(ZoneId.systemDefault()).toEpochSecond() * 1000

while(bundleEntries.hasMoreElements()) {
    ZipEntry entry = bundleEntries.nextElement()
    assert entry.getTime() == expectedTime
}
